/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.find;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.components.editor.ComponentEditorGrammar;
import org.antlr.works.editor.EditorTab;
import org.antlr.works.grammar.element.ElementRule;

public class Usages
extends EditorTab {
    protected JPanel panel;
    protected JScrollPane treeScrollPane;
    protected JTree tree;
    protected DefaultTreeModel model;
    protected DefaultMutableTreeNode root;
    protected DefaultMutableTreeNode node;
    protected String lastRule;
    protected ComponentEditorGrammar editor;
    protected ATEToken token;

    public Usages(ComponentEditorGrammar editor, ATEToken token) {
        this.editor = editor;
        this.token = token;
        this.panel = new JPanel(new BorderLayout());
        this.tree = new JTree();
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        DefaultTreeCellRenderer treeRenderer = new DefaultTreeCellRenderer();
        treeRenderer.setClosedIcon(null);
        treeRenderer.setLeafIcon(null);
        treeRenderer.setOpenIcon(null);
        this.tree.setCellRenderer(treeRenderer);
        this.tree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                DefaultMutableTreeNode node;
                int selRow = Usages.this.tree.getRowForLocation(e.getX(), e.getY());
                TreePath selPath = Usages.this.tree.getPathForLocation(e.getX(), e.getY());
                if (selRow != -1 && e.getClickCount() != 1 && e.getClickCount() == 2 && (node = (DefaultMutableTreeNode)selPath.getLastPathComponent()).getUserObject() instanceof UsageMatch) {
                    Usages.this.selectMatch((UsageMatch)node.getUserObject());
                }
            }
        });
        this.treeScrollPane = new JScrollPane(this.tree);
        this.treeScrollPane.setWheelScrollingEnabled(true);
        this.panel.add((Component)this.treeScrollPane, "Center");
        this.root = new DefaultMutableTreeNode();
        this.model = new DefaultTreeModel(this.root);
        this.lastRule = null;
        this.tree.setModel(this.model);
    }

    public Container getContainer() {
        return this.panel;
    }

    public void addMatch(ElementRule rule, ATEToken token) {
        if (this.lastRule == null || !this.lastRule.equals(rule.name)) {
            this.node = new DefaultMutableTreeNode();
            this.node.setUserObject(rule.name);
            this.root.add(this.node);
            this.lastRule = rule.name;
        }
        DefaultMutableTreeNode matchNode = new DefaultMutableTreeNode();
        matchNode.setUserObject(new UsageMatch(rule, token));
        this.node.add(matchNode);
        this.model.reload();
    }

    public void selectMatch(UsageMatch match) {
        this.editor.selectTextRange(match.token.getStartIndex(), match.token.getEndIndex());
    }

    public String getTabName() {
        return "Usages of \"" + this.token.getAttribute() + "\"";
    }

    public Component getTabComponent() {
        return this.getContainer();
    }

    public static class UsageMatch {
        public ElementRule rule;
        public ATEToken token;
        public String contextualText;

        public UsageMatch(ElementRule rule, ATEToken token) {
            this.rule = rule;
            this.token = token;
            this.createContextString();
        }

        public void createContextString() {
            int s;
            String text = this.token.getText();
            for (s = this.token.getStartIndex(); s > 0 && text.charAt(s) != '\n' && text.charAt(s) != '\r'; --s) {
            }
            int e = this.token.getEndIndex();
            while (s < text.length() && text.charAt(e) != '\n' && text.charAt(e) != '\r') {
                ++e;
            }
            this.contextualText = text.substring(s, e);
        }

        public String toString() {
            return this.token.getAttribute() + " @ (" + this.token.startLineNumber + ", " + (this.token.getStartIndex() - this.token.getStartLineIndex()) + ") " + this.contextualText + "        ";
        }
    }
}

