/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.editor;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.antlr.works.ate.analysis.ATEAnalysisItem;
import org.antlr.works.ate.analysis.ATEAnalysisManager;
import org.antlr.works.components.editor.ComponentEditorGrammar;
import org.antlr.works.editor.EditorInspectorItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorAnalysisManager
extends ATEAnalysisManager {
    protected static final int ANALYSIS_ITEM_ERROR = 0;
    protected static final int ANALYSIS_ITEM_WARNING = 1;
    protected static final int ANALYSIS_ITEM_OTHER = 2;
    protected final Color greenColor = new Color(0.0f, 0.9f, 0.25f, 1.0f);
    protected ComponentEditorGrammar editor;
    protected int numberOfErrors;
    protected int numberOfWarnings;

    public EditorAnalysisManager(ComponentEditorGrammar editor) {
        this.editor = editor;
    }

    public void close() {
        this.editor = null;
    }

    @Override
    public int[] getAvailableTypes() {
        return new int[]{1, 0, 2};
    }

    @Override
    public List<ATEAnalysisItem> getItemsForType(int type) {
        switch (type) {
            case 0: {
                return this.getErrors();
            }
            case 1: {
                return this.getWarnings();
            }
            case 2: {
                return this.getOthers();
            }
        }
        return null;
    }

    @Override
    public int getLinesCount() {
        return this.editor.getGrammarEngine().getNumberOfLines();
    }

    @Override
    public Color getAnalysisColor() {
        if (this.numberOfErrors == 0 && this.numberOfWarnings == 0) {
            return this.greenColor;
        }
        if (this.numberOfErrors == 0) {
            return Color.yellow;
        }
        return Color.red;
    }

    @Override
    public String getAnalysisDescription() {
        StringBuilder sb = new StringBuilder();
        if (this.numberOfErrors == 0) {
            sb.append("No error");
        } else {
            sb.append(this.numberOfErrors);
            if (this.numberOfErrors > 1) {
                sb.append(" errors found");
            } else {
                sb.append(" error found");
            }
        }
        if (this.numberOfWarnings > 0) {
            sb.append("\n");
            sb.append(this.numberOfWarnings);
            if (this.numberOfWarnings > 1) {
                sb.append(" warnings found");
            } else {
                sb.append(" warning found");
            }
        }
        return sb.toString();
    }

    public List<ATEAnalysisItem> getErrors() {
        ArrayList<ATEAnalysisItem> errors = new ArrayList<ATEAnalysisItem>();
        for (EditorInspectorItem item : this.editor.editorInspector.getErrors()) {
            errors.add(new ATEAnalysisItem(0, item.color, item.startLineNumber, item.startIndex, item.description));
        }
        this.numberOfErrors = errors.size();
        return errors;
    }

    public List<ATEAnalysisItem> getWarnings() {
        ArrayList<ATEAnalysisItem> warnings = new ArrayList<ATEAnalysisItem>();
        for (EditorInspectorItem item : this.editor.editorInspector.getWarnings()) {
            warnings.add(new ATEAnalysisItem(1, item.color, item.startLineNumber, item.startIndex, item.description));
        }
        this.numberOfWarnings = warnings.size();
        return warnings;
    }

    public List<ATEAnalysisItem> getOthers() {
        ArrayList<ATEAnalysisItem> others = new ArrayList<ATEAnalysisItem>();
        for (EditorInspectorItem item : this.editor.editorInspector.getDecisionDFAs()) {
            others.add(new ATEAnalysisItem(2, item.color, item.startLineNumber, item.startIndex, item.description));
        }
        return others;
    }
}

