/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.debugger.tree;

import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.swing.tree.TreeNode;
import org.antlr.runtime.Token;
import org.antlr.works.debugger.Debugger;
import org.antlr.works.debugger.events.DBEventLocation;
import org.antlr.works.debugger.tree.DBParseTreeModelListener;
import org.antlr.works.debugger.tree.DBTreeNode;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.utils.awtree.AWTreeModel;
import org.antlr.works.utils.awtree.AWTreeNode;
import org.antlr.xjlib.foundation.notification.XJNotificationCenter;
import org.antlr.xjlib.foundation.notification.XJNotificationObserver;

public class DBParseTreeModel
extends AWTreeModel
implements XJNotificationObserver {
    public Stack<ParseTreeNode> rules = new Stack();
    public Stack<Backtrack> backtrackStack = new Stack();
    public Color lookaheadTokenColor;
    public TreeNode lastNode;
    public DBEventLocation location;
    public Debugger debugger;
    public List<DBParseTreeModelListener> listeners = new ArrayList<DBParseTreeModelListener>();

    public DBParseTreeModel(Debugger debugger) {
        this.debugger = debugger;
        this.initRules();
        this.initColors();
        XJNotificationCenter.defaultCenter().addObserver(this, "NOTIF_PREFS_APPLIED");
    }

    public void close() {
        this.debugger = null;
        this.listeners.clear();
        XJNotificationCenter.defaultCenter().removeObserver(this);
    }

    public void addListener(DBParseTreeModelListener listener) {
        this.listeners.add(listener);
    }

    public void fireDataChanged() {
        for (DBParseTreeModelListener listener : this.listeners) {
            listener.modelChanged(this);
        }
    }

    public void initRules() {
        this.rules.clear();
        this.rules.push(new ParseTreeNode("root", null));
    }

    public void initColors() {
        this.lookaheadTokenColor = AWPrefs.getLookaheadTokenColor();
    }

    public void clear() {
        super.clear();
        this.initRules();
        this.backtrackStack.clear();
        this.setLastNode(null);
        this.fireDataChanged();
        this.location = null;
    }

    public void setLastNode(TreeNode node) {
        this.lastNode = node;
    }

    public TreeNode getLastNode() {
        return this.lastNode;
    }

    public void setLocation(DBEventLocation location) {
        this.location = location;
    }

    public void pushRule(String name) {
        ParseTreeNode parentRuleNode = this.rules.peek();
        ParseTreeNode ruleNode = new ParseTreeNode(name, this.location);
        this.rules.push(ruleNode);
        this.addNode(parentRuleNode, ruleNode);
        this.addNodeToCurrentBacktrack(ruleNode);
        this.setLastNode(ruleNode);
    }

    public void popRule() {
        this.rules.pop();
    }

    public TreeNode getRootRule() {
        return (TreeNode)this.rules.firstElement();
    }

    public TreeNode peekRule() {
        if (this.rules.isEmpty()) {
            return null;
        }
        return this.rules.peek();
    }

    public void addToken(Token token) {
        ParseTreeNode ruleNode = this.rules.peek();
        ParseTreeNode elementNode = new ParseTreeNode(token, this.location);
        this.addNode(ruleNode, elementNode);
        this.addNodeToCurrentBacktrack(elementNode);
        this.setLastNode(elementNode);
    }

    public void addException(Exception e) {
        ParseTreeNode ruleNode = this.rules.peek();
        ParseTreeNode errorNode = new ParseTreeNode(e, this.location);
        this.addNode(ruleNode, errorNode);
        this.addNodeToCurrentBacktrack(errorNode);
        this.setLastNode(errorNode);
    }

    public void addNodeToCurrentBacktrack(ParseTreeNode node) {
        if (this.backtrackStack.isEmpty()) {
            return;
        }
        Backtrack b = this.backtrackStack.peek();
        b.addNode(node);
    }

    public void beginBacktrack(int level) {
        this.backtrackStack.push(new Backtrack(level, this.lookaheadTokenColor));
    }

    public void endBacktrack(int level, boolean success) {
        Backtrack b = this.backtrackStack.pop();
        b.end(success);
        this.setLastNode(b.getLastNode());
    }

    public void notificationFire(Object source, String name) {
        if (name.equals("NOTIF_PREFS_APPLIED")) {
            this.initColors();
        }
    }

    public static class Backtrack {
        public int level;
        public Color lookaheadTokenColor;
        public LinkedList<DBTreeNode> nodes = new LinkedList();

        public Backtrack(int level, Color lookaheadTokenColor) {
            this.level = level;
            this.lookaheadTokenColor = lookaheadTokenColor;
        }

        public void addNode(DBTreeNode node) {
            node.setColor(this.lookaheadTokenColor);
            this.nodes.add(node);
        }

        public void end(boolean success) {
            Color color = this.getColor(success);
            for (DBTreeNode node : this.nodes) {
                node.setColor(color);
            }
        }

        public AWTreeNode getLastNode() {
            if (this.nodes.isEmpty()) {
                return null;
            }
            return this.nodes.getLast();
        }

        protected Color getColor(boolean success) {
            Color c = success ? Color.green.darker() : Color.red;
            for (int i = 1; i < this.level; ++i) {
                c = c.darker().darker();
            }
            return c;
        }
    }

    public static class ParseTreeNode
    extends DBTreeNode {
        protected String s;
        protected Exception e;

        public ParseTreeNode(String s, DBEventLocation location) {
            this.s = s;
            this.location = location;
        }

        public ParseTreeNode(Exception e, DBEventLocation location) {
            this.e = e;
            this.location = location;
        }

        public ParseTreeNode(Token token, DBEventLocation location) {
            super(token, location);
        }

        public String toString() {
            if (this.s != null) {
                return this.s;
            }
            if (this.e != null) {
                return this.e.toString();
            }
            return super.toString();
        }
    }
}

