/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.debugger.panels;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.antlr.works.debugger.Debugger;
import org.antlr.works.debugger.events.DBEventEnterRule;
import org.antlr.works.utils.DetachablePanel;
import org.antlr.xjlib.appkit.swing.XJTable;
import org.antlr.xjlib.appkit.swing.XJTableView;

public class DBStackPanel
extends DetachablePanel {
    public static final int INFO_COLUMN_COUNT = 0;
    public static final int INFO_COLUMN_RULE = 1;
    private XJTableView infoTableView;
    private RuleTableDataModel ruleTableDataModel;
    private Stack<DBEventEnterRule> rules = new Stack();

    public DBStackPanel(Debugger debugger) {
        super("Stack", debugger);
        this.ruleTableDataModel = new RuleTableDataModel();
        this.infoTableView = new XJTableView();
        this.setInfoTableModel(this.infoTableView.getTable(), this.ruleTableDataModel);
        this.mainPanel.add((Component)this.infoTableView, "Center");
        this.infoTableView.autoresizeColumns();
    }

    public void setInfoTableModel(XJTable table, AbstractTableModel model) {
        table.setModel(model);
        this.selectLastInfoTableItem();
    }

    public void selectLastInfoTableItem() {
        this.infoTableView.scrollToLastRow();
    }

    public void clear() {
        this.rules.clear();
        this.ruleTableDataModel.clear();
    }

    public void updateOnBreakEvent() {
        this.ruleTableDataModel.update();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DBStackPanel.this.selectLastInfoTableItem();
            }
        });
    }

    public void pushRule(DBEventEnterRule rule) {
        this.rules.push(rule);
        this.ruleTableDataModel.add(rule.name);
    }

    public void popRule() {
        this.ruleTableDataModel.remove(this.rules.peek().name);
        this.rules.pop();
    }

    public DBEventEnterRule peekRule() {
        if (this.rules.isEmpty()) {
            return null;
        }
        return this.rules.peek();
    }

    public class RuleTableDataModel
    extends AbstractTableModel {
        protected List<String> rules = new ArrayList<String>();

        public void add(String rule) {
            this.rules.add(rule);
        }

        public void remove(String rule) {
            this.rules.remove(rule);
        }

        public void clear() {
            this.rules.clear();
            this.fireTableDataChanged();
            DBStackPanel.this.infoTableView.autoresizeColumns();
        }

        public void update() {
            this.fireTableDataChanged();
            DBStackPanel.this.infoTableView.autoresizeColumns();
        }

        public int getRowCount() {
            return this.rules.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "#";
                }
                case 1: {
                    return "Rule";
                }
            }
            return super.getColumnName(column);
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return String.valueOf(rowIndex);
                }
                case 1: {
                    return this.rules.get(rowIndex);
                }
            }
            return null;
        }
    }
}

