/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.debugger.panels;

import java.awt.Color;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.antlr.runtime.Token;
import org.antlr.works.debugger.Debugger;
import org.antlr.works.debugger.input.DBInputProcessor;
import org.antlr.works.debugger.input.DBInputProcessorToken;
import org.antlr.works.debugger.input.DBInputTextTokenInfo;
import org.antlr.works.debugger.panels.DBInputConcretePanel;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.utils.TextPane;
import org.antlr.works.utils.TextUtils;

public class DBInputTokenPanel
implements DBInputConcretePanel {
    protected TextPane inputTextPane = new TextPane();
    protected JScrollPane textScrollPane;
    protected DBInputProcessorToken processorToken;

    public DBInputTokenPanel(Debugger debugger) {
        this.inputTextPane.setBackground(Color.white);
        this.inputTextPane.setBorder(null);
        this.inputTextPane.setFont(new Font(AWPrefs.getEditorFont(), 0, AWPrefs.getEditorFontSize()));
        this.inputTextPane.setText("");
        this.inputTextPane.setEditable(false);
        TextUtils.createTabs(this.inputTextPane);
        this.processorToken = new DBInputProcessorToken(debugger, this.inputTextPane);
        this.textScrollPane = new JScrollPane(this.inputTextPane);
        this.textScrollPane.setWheelScrollingEnabled(true);
    }

    public void close() {
        this.processorToken.close();
    }

    public void stop() {
        this.processorToken.stop();
    }

    public JComponent getComponent() {
        return this.textScrollPane;
    }

    public DBInputProcessor getInputProcessor() {
        return this.processorToken;
    }

    public void toggleInputTextTokensBox() {
        this.processorToken.setDrawTokensBox(!this.processorToken.isTokensBoxVisible());
    }

    public boolean isInputTokensBoxVisible() {
        return this.processorToken.isTokensBoxVisible();
    }

    public boolean isBreakpointAtToken(Token token) {
        return this.processorToken.isBreakpointAtToken(token);
    }

    public void selectToken(Token token) {
        this.processorToken.selectToken(token);
    }

    public DBInputTextTokenInfo getTokenInfoForToken(Token token) {
        return this.processorToken.getTokenInfoForToken(token);
    }

    public void updateOnBreakEvent() {
        this.processorToken.updateOnBreakEvent();
    }
}

