/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.debugger.panels;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.antlr.works.debugger.Debugger;
import org.antlr.works.debugger.events.DBEvent;
import org.antlr.works.debugger.tivo.DBPlayerContextInfo;
import org.antlr.works.utils.DetachablePanel;
import org.antlr.xjlib.appkit.swing.XJTable;
import org.antlr.xjlib.appkit.swing.XJTableView;

public class DBEventsPanel
extends DetachablePanel {
    public static final int INFO_COLUMN_COUNT = 0;
    public static final int INFO_COLUMN_EVENT = 1;
    public static final int INFO_COLUMN_SUBRULE = 2;
    public static final int INFO_COLUMN_DECISION = 3;
    public static final int INFO_COLUMN_MARK = 4;
    public static final int INFO_COLUMN_BACKTRACK = 5;
    protected XJTableView infoTableView;
    protected EventTableDataModel eventTableDataModel = new EventTableDataModel();

    public DBEventsPanel(Debugger debugger) {
        super("Events", debugger);
        this.infoTableView = new XJTableView();
        this.infoTableView.setFocusable(true);
        this.setInfoTableModel(this.infoTableView.getTable(), this.eventTableDataModel);
        this.mainPanel.add((Component)this.infoTableView, "Center");
        this.infoTableView.autoresizeColumns();
    }

    public void setInfoTableModel(XJTable table, AbstractTableModel model) {
        table.setModel(model);
        this.selectLastInfoTableItem();
    }

    public void selectLastInfoTableItem() {
        this.infoTableView.scrollToLastRow();
    }

    public int getNumberOfEvents() {
        return this.eventTableDataModel.getRowCount();
    }

    public void clear() {
        this.eventTableDataModel.clear();
    }

    public void updateOnBreakEvent() {
        this.eventTableDataModel.update();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DBEventsPanel.this.selectLastInfoTableItem();
            }
        });
    }

    public void addEvent(DBEvent event, DBPlayerContextInfo info) {
        this.eventTableDataModel.add(event, info);
    }

    public String getEventsAsString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.eventTableDataModel.getHeadersAsString());
        sb.append("\n");
        List<EventTableDataModel.EventInfo> events = this.eventTableDataModel.events;
        for (int i = 0; i < events.size(); ++i) {
            sb.append(i);
            sb.append(":\t");
            sb.append(events.get(i).toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public class EventTableDataModel
    extends AbstractTableModel {
        protected List<EventInfo> events = new ArrayList<EventInfo>();

        public void add(DBEvent event, DBPlayerContextInfo info) {
            this.events.add(new EventInfo(event, info));
        }

        public void clear() {
            this.events.clear();
            this.fireTableDataChanged();
            DBEventsPanel.this.infoTableView.autoresizeColumns();
        }

        public void update() {
            this.fireTableDataChanged();
            DBEventsPanel.this.infoTableView.autoresizeColumns();
        }

        public int getRowCount() {
            return this.events.size();
        }

        public int getColumnCount() {
            return 6;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "#";
                }
                case 1: {
                    return "Event";
                }
                case 2: {
                    return "Subrule";
                }
                case 3: {
                    return "Decision";
                }
                case 4: {
                    return "Mark";
                }
                case 5: {
                    return "Backtrack";
                }
            }
            return super.getColumnName(column);
        }

        public Class getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return String.class;
                }
                case 3: {
                    return String.class;
                }
                case 4: {
                    return String.class;
                }
                case 5: {
                    return String.class;
                }
            }
            return super.getColumnClass(columnIndex);
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            EventInfo info = this.events.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return String.valueOf(rowIndex);
                }
                case 1: {
                    return info.event;
                }
                case 2: {
                    return info.getSubrule();
                }
                case 3: {
                    return info.getDecision();
                }
                case 4: {
                    return info.getMark();
                }
                case 5: {
                    return info.getBacktrack();
                }
            }
            return null;
        }

        public String getHeadersAsString() {
            return "#\tEvent\tSubrule\tDecision\tMark\tBacktrack";
        }

        public class EventInfo {
            public DBEvent event;
            public int subrule;
            public int decision;
            public int mark;
            public int backtrack;

            public EventInfo(DBEvent event, DBPlayerContextInfo info) {
                this.event = event;
                this.subrule = info.getSubrule();
                this.decision = info.getDecision();
                this.mark = info.getMark();
                this.backtrack = info.getBacktrack();
            }

            public Object getSubrule() {
                return this.subrule == -1 ? null : String.valueOf(this.subrule);
            }

            public Object getDecision() {
                return this.decision == -1 ? null : String.valueOf(this.decision);
            }

            public Object getMark() {
                return this.mark == -1 ? null : String.valueOf(this.mark);
            }

            public Object getBacktrack() {
                return this.backtrack == -1 ? null : String.valueOf(this.backtrack);
            }

            public String getTextForExport(int value) {
                if (value == -1) {
                    return "-";
                }
                return String.valueOf(value);
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append(this.event.toString());
                sb.append("\t");
                sb.append(this.getTextForExport(this.subrule));
                sb.append("\t");
                sb.append(this.getTextForExport(this.decision));
                sb.append("\t");
                sb.append(this.getTextForExport(this.mark));
                sb.append("\t");
                sb.append(this.getTextForExport(this.backtrack));
                return sb.toString();
            }
        }
    }
}

