/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.debugger.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.antlr.works.debugger.Debugger;
import org.antlr.works.debugger.events.DBEvent;
import org.antlr.works.debugger.tivo.DBPlayerContextInfo;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.stats.StatisticsAW;
import org.antlr.works.utils.IconManager;
import org.antlr.works.utils.NumberSet;
import org.antlr.works.utils.Toolbar;
import org.antlr.xjlib.appkit.swing.XJRollOverButton;

public class DBControlPanel
extends JPanel {
    protected JButton stopButton;
    protected JButton goToStartButton;
    protected JButton goToEndButton;
    protected JButton fastForwardButton;
    protected JButton backButton;
    protected JButton forwardButton;
    protected JButton stepOverButton;
    protected JCheckBox breakAllButton;
    protected JCheckBox breakLocationButton;
    protected JCheckBox breakConsumeButton;
    protected JCheckBox breakLTButton;
    protected JCheckBox breakExceptionButton;
    protected JLabel infoLabel;
    protected Debugger debugger;

    public DBControlPanel(Debugger debugger) {
        super(new BorderLayout());
        this.debugger = debugger;
        Toolbar box = Toolbar.createHorizontalToolbar();
        this.stopButton = this.createStopButton();
        box.addElement(this.stopButton);
        box.addGroupSeparator();
        this.goToStartButton = this.createGoToStartButton();
        box.addElement(this.goToStartButton);
        this.backButton = this.createStepBackButton();
        box.addElement(this.backButton);
        this.forwardButton = this.createStepForwardButton();
        box.addElement(this.forwardButton);
        this.stepOverButton = this.createStepOverButton();
        box.addElement(this.stepOverButton);
        this.fastForwardButton = this.createFastForwardButton();
        box.addElement(this.fastForwardButton);
        this.goToEndButton = this.createGoToEndButton();
        box.addElement(this.goToEndButton);
        box.addGroupSeparator();
        this.createBreakEvents(box);
        box.addElement(Box.createHorizontalGlue());
        box.addElement(this.createInfoLabelPanel());
        this.add((Component)box, "Center");
    }

    public void close() {
        AWPrefs.getPreferences().unbindFromPreferences(this.breakAllButton, "PREF_DEBUG_BREAK_ALL");
        AWPrefs.getPreferences().unbindFromPreferences(this.breakLocationButton, "PREF_DEBUG_BREAK_LOCATION");
        AWPrefs.getPreferences().unbindFromPreferences(this.breakConsumeButton, "PREF_DEBUG_BREAK_CONSUME");
        AWPrefs.getPreferences().unbindFromPreferences(this.breakLTButton, "PREF_DEBUG_BREAK_LT");
        AWPrefs.getPreferences().unbindFromPreferences(this.breakExceptionButton, "PREF_DEBUG_BREAK_EXCEPTION");
        this.debugger = null;
    }

    public JButton createStopButton() {
        XJRollOverButton button = XJRollOverButton.createMediumButton(IconManager.shared().getIconStop());
        button.setToolTipText("Stop");
        button.setFocusable(false);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DBControlPanel.this.debugger.debuggerStop(false);
                StatisticsAW.shared().recordEvent(140);
            }
        });
        return button;
    }

    public JButton createStepBackButton() {
        XJRollOverButton button = XJRollOverButton.createMediumButton(IconManager.shared().getIconStepBackward());
        button.setToolTipText("Step Back");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DBControlPanel.this.debugger.getRecorder().stepBackward(DBControlPanel.this.getBreakEvent());
                DBControlPanel.this.updateInterfaceLater();
                StatisticsAW.shared().recordEvent(141);
            }
        });
        return button;
    }

    public JButton createStepForwardButton() {
        XJRollOverButton button = XJRollOverButton.createMediumButton(IconManager.shared().getIconStepForward());
        button.setToolTipText("Step Forward");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DBControlPanel.this.debugger.getRecorder().stepForward(DBControlPanel.this.getBreakEvent());
                DBControlPanel.this.updateInterfaceLater();
                StatisticsAW.shared().recordEvent(142);
            }
        });
        return button;
    }

    public JButton createStepOverButton() {
        XJRollOverButton button = XJRollOverButton.createMediumButton(IconManager.shared().getIconStepOver());
        button.setToolTipText("Step Over");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DBControlPanel.this.debugger.getRecorder().stepOver();
                DBControlPanel.this.updateInterfaceLater();
                StatisticsAW.shared().recordEvent(143);
            }
        });
        return button;
    }

    public JButton createGoToStartButton() {
        XJRollOverButton button = XJRollOverButton.createMediumButton(IconManager.shared().getIconGoToStart());
        button.setToolTipText("Go To Start");
        button.setFocusable(false);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DBControlPanel.this.debugger.resetGrammarLocation();
                DBControlPanel.this.debugger.getRecorder().goToStart();
                DBControlPanel.this.updateInterfaceLater();
                StatisticsAW.shared().recordEvent(145);
            }
        });
        return button;
    }

    public JButton createGoToEndButton() {
        XJRollOverButton button = XJRollOverButton.createMediumButton(IconManager.shared().getIconGoToEnd());
        button.setToolTipText("Go To End");
        button.setFocusable(false);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DBControlPanel.this.debugger.getRecorder().goToEnd();
                DBControlPanel.this.updateInterfaceLater();
                StatisticsAW.shared().recordEvent(146);
            }
        });
        return button;
    }

    public JButton createFastForwardButton() {
        XJRollOverButton button = XJRollOverButton.createMediumButton(IconManager.shared().getIconFastForward());
        button.setToolTipText("Fast forward");
        button.setFocusable(false);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DBControlPanel.this.debugger.getRecorder().fastForward();
                DBControlPanel.this.updateInterfaceLater();
                StatisticsAW.shared().recordEvent(144);
            }
        });
        return button;
    }

    public void createBreakEvents(Toolbar box) {
        box.addElement(new JLabel("Break on:"));
        this.breakAllButton = this.createBreakButton("All");
        box.addElement(this.breakAllButton);
        this.breakLocationButton = this.createBreakButton("Location");
        box.addElement(this.breakLocationButton);
        this.breakConsumeButton = this.createBreakButton("Consume");
        box.addElement(this.breakConsumeButton);
        this.breakLTButton = this.createBreakButton("LT");
        box.addElement(this.breakLTButton);
        this.breakExceptionButton = this.createBreakButton("Exception");
        box.addElement(this.breakExceptionButton);
        AWPrefs.getPreferences().bindToPreferences(this.breakAllButton, "PREF_DEBUG_BREAK_ALL", false);
        AWPrefs.getPreferences().bindToPreferences(this.breakLocationButton, "PREF_DEBUG_BREAK_LOCATION", false);
        AWPrefs.getPreferences().bindToPreferences(this.breakConsumeButton, "PREF_DEBUG_BREAK_CONSUME", true);
        AWPrefs.getPreferences().bindToPreferences(this.breakLTButton, "PREF_DEBUG_BREAK_LT", false);
        AWPrefs.getPreferences().bindToPreferences(this.breakExceptionButton, "PREF_DEBUG_BREAK_EXCEPTION", false);
    }

    public JCheckBox createBreakButton(String title) {
        JCheckBox button = new JCheckBox(title);
        button.setFocusable(false);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DBControlPanel.this.getBreakEvent().isEmpty()) {
                    DBControlPanel.this.breakAllButton.setSelected(true);
                    AWPrefs.getPreferences().setBoolean("PREF_DEBUG_BREAK_ALL", true);
                }
            }
        });
        return button;
    }

    public JComponent createInfoLabelPanel() {
        this.infoLabel = new JLabel();
        return this.infoLabel;
    }

    public Set getBreakEvent() {
        NumberSet set = new NumberSet();
        if (this.breakAllButton.isSelected()) {
            set.add(0);
        }
        if (this.breakLocationButton.isSelected()) {
            set.add(4);
        }
        if (this.breakConsumeButton.isSelected()) {
            set.add(5);
        }
        if (this.breakLTButton.isSelected()) {
            set.add(7);
        }
        if (this.breakExceptionButton.isSelected()) {
            set.add(26);
        }
        return set;
    }

    public void updateStatusInfo() {
        StringBuilder info = new StringBuilder();
        String status = "-";
        switch (this.debugger.getRecorder().getStatus()) {
            case 0: {
                status = "Stopped";
                break;
            }
            case 1: {
                status = "Stopping";
                break;
            }
            case 2: {
                status = "Launching";
                break;
            }
            case 3: {
                status = "Running";
                break;
            }
            case 4: {
                status = "Break on " + DBEvent.getEventName(this.debugger.getRecorder().getStoppedOnEvent());
            }
        }
        info.append(status);
        DBPlayerContextInfo context = this.debugger.getPlayer().getContextInfo();
        if (context.isBacktracking()) {
            info.append(" (backtrack ");
            info.append(context.getBacktrack());
            info.append(")");
        }
        this.infoLabel.setText(info.toString());
        this.updateInterface();
    }

    public void updateInterface() {
        this.stopButton.setEnabled(this.debugger.getRecorder().getStatus() != 0);
        boolean enabled = this.debugger.getRecorder().isAlive();
        boolean atBeginning = this.debugger.getRecorder().isAtBeginning();
        boolean atEnd = this.debugger.getRecorder().isAtEnd();
        this.backButton.setEnabled(enabled && !atBeginning);
        this.forwardButton.setEnabled(enabled && !atEnd);
        this.stepOverButton.setEnabled(enabled && !atEnd);
        this.fastForwardButton.setEnabled(enabled && !atEnd);
        this.goToStartButton.setEnabled(enabled && !atBeginning);
        this.goToEndButton.setEnabled(enabled && !atEnd);
    }

    public void updateInterfaceLater() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DBControlPanel.this.updateInterface();
            }
        });
    }
}

