/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.components.container;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.antlr.works.ate.syntax.misc.ATELine;
import org.antlr.works.components.ComponentToolbar;
import org.antlr.works.components.ComponentWindow;
import org.antlr.works.components.ComponentWindowImpl;
import org.antlr.works.components.container.ComponentContainer;
import org.antlr.works.components.container.ComponentContainerGrammarMenu;
import org.antlr.works.components.container.ComponentContainerInternal;
import org.antlr.works.components.container.ComponentDocumentInternal;
import org.antlr.works.components.document.ComponentDocument;
import org.antlr.works.components.document.ComponentDocumentFactory;
import org.antlr.works.components.editor.ComponentEditor;
import org.antlr.works.components.editor.ComponentEditorGrammar;
import org.antlr.works.debugger.Debugger;
import org.antlr.works.debugger.api.DebuggerDelegate;
import org.antlr.works.editor.EditorConsole;
import org.antlr.works.editor.EditorTab;
import org.antlr.works.generate.CodeGenerate;
import org.antlr.works.grammar.element.ElementBlock;
import org.antlr.works.grammar.element.ElementImport;
import org.antlr.works.grammar.element.ElementRule;
import org.antlr.works.grammar.engine.GrammarEngine;
import org.antlr.works.menu.ActionDebugger;
import org.antlr.works.menu.ActionGoTo;
import org.antlr.works.menu.ActionRefactor;
import org.antlr.works.menu.ContextualMenuFactory;
import org.antlr.works.utils.Console;
import org.antlr.xjlib.appkit.document.XJDocument;
import org.antlr.xjlib.appkit.frame.XJFrameInterface;
import org.antlr.xjlib.appkit.menu.XJMainMenuBar;
import org.antlr.xjlib.appkit.menu.XJMenu;
import org.antlr.xjlib.appkit.menu.XJMenuItem;
import org.antlr.xjlib.appkit.swing.XJTabbedPane;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.foundation.XJUtils;

public class ComponentContainerGrammar
implements ComponentContainer {
    private final Set<ComponentContainer> containers = new LinkedHashSet<ComponentContainer>();
    private final Map<Component, ComponentContainer> componentToContainer = new HashMap<Component, ComponentContainer>();
    private final Map<Integer, EditorTab> indexToEditorTab = new HashMap<Integer, EditorTab>();
    private ComponentEditor editor;
    private ComponentContainer selectedContainer;
    private ComponentContainerGrammarMenu componentContainerGrammarMenu;
    private ComponentToolbar toolbar;
    private Debugger debugger;
    private XJTabbedPane editorsTab;
    private JTabbedPane bottomTab;
    private JPanel toolbarPanel;
    private JPanel rulesPanel;
    private JPanel bottomPanel;
    private JPanel sdPanel;
    private JPanel interpreterPanel;
    private JPanel consolePanel;
    private JPanel debuggerPanel;
    private JPanel mainPanel;
    private EditorsTabChangeListener etc;
    private MouseListener ml;
    private ChangeListener cl;
    private final List<EditorTab> tabs = new ArrayList<EditorTab>();
    private final Set<String> loadedGrammarFileNames = new HashSet<String>();
    private final Map<String, GrammarEngine> engines = new HashMap<String, GrammarEngine>();
    private final ComponentWindow window;
    private JSplitPane horizontalSplit;
    private static final int CLOSING_INDEX_LIMIT = 4;

    public ComponentContainerGrammar(ComponentWindow window) {
        this.window = window;
        this.selectedContainer = this;
        this.containers.add(this);
        this.debugger = new Debugger(new ContainerDebuggerDelegate());
        this.componentContainerGrammarMenu = new ComponentContainerGrammarMenu(this);
        this.toolbar = new ComponentToolbar(this);
    }

    public void awake() {
        this.componentContainerGrammarMenu.awake();
        this.debugger.awake();
        this.toolbar.awake();
        this.editorsTab = new XJTabbedPane();
        this.bottomTab = new JTabbedPane();
        this.bottomTab.setTabPlacement(3);
        this.toolbarPanel = new JPanel(new BorderLayout());
        this.toolbarPanel.setBorder(null);
        this.rulesPanel = new JPanel(new BorderLayout());
        this.rulesPanel.setBorder(null);
        this.bottomPanel = new JPanel(new BorderLayout());
        this.bottomPanel.setBorder(null);
        this.sdPanel = new JPanel(new BorderLayout());
        this.sdPanel.setBorder(null);
        this.bottomTab.addTab("Syntax Diagram", this.sdPanel);
        this.interpreterPanel = new JPanel(new BorderLayout());
        this.interpreterPanel.setBorder(null);
        this.bottomTab.addTab("Interpreter", this.interpreterPanel);
        this.consolePanel = new JPanel(new BorderLayout());
        this.consolePanel.setBorder(null);
        this.bottomTab.addTab("Console", this.consolePanel);
        this.debuggerPanel = new JPanel(new BorderLayout());
        this.debuggerPanel.setBorder(null);
        this.bottomTab.addTab("Debugger", this.debuggerPanel);
        this.etc = new EditorsTabChangeListener();
        this.editorsTab.addChangeListener(this.etc);
        this.ml = new BottomTabbedPaneMouseListener();
        this.bottomTab.addMouseListener(this.ml);
        this.cl = new BottomTabbedPaneChangeListener();
        this.bottomTab.addChangeListener(this.cl);
    }

    public void assemble(boolean separateRules) {
        if (separateRules) {
            this.horizontalSplit = new JSplitPane();
            this.horizontalSplit.setBorder(null);
            this.horizontalSplit.setOrientation(0);
            this.horizontalSplit.setTopComponent(this.editorsTab);
            this.horizontalSplit.setBottomComponent(this.bottomPanel);
            this.horizontalSplit.setContinuousLayout(true);
            this.horizontalSplit.setOneTouchExpandable(true);
            this.horizontalSplit.setResizeWeight(0.6);
        } else {
            JSplitPane verticalSplit = new JSplitPane();
            verticalSplit.setBorder(null);
            verticalSplit.setOrientation(1);
            verticalSplit.setLeftComponent(this.rulesPanel);
            verticalSplit.setRightComponent(this.editorsTab);
            verticalSplit.setContinuousLayout(true);
            verticalSplit.setOneTouchExpandable(true);
            verticalSplit.setResizeWeight(0.2);
            this.horizontalSplit = new JSplitPane();
            this.horizontalSplit.setBorder(null);
            this.horizontalSplit.setOrientation(0);
            this.horizontalSplit.setTopComponent(verticalSplit);
            this.horizontalSplit.setBottomComponent(this.bottomPanel);
            this.horizontalSplit.setContinuousLayout(true);
            this.horizontalSplit.setOneTouchExpandable(true);
            this.horizontalSplit.setResizeWeight(0.7);
        }
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setBorder(null);
        this.mainPanel.add((Component)this.toolbarPanel, "North");
        this.mainPanel.add((Component)this.horizontalSplit, "Center");
        this.window.setContentPanel(this.mainPanel);
    }

    public void refreshMainMenuBar() {
        if (this.getXJFrame().getMainMenuBar() != null) {
            this.getXJFrame().getMainMenuBar().refreshState();
        }
    }

    public void addGrammar(ComponentContainer container) {
        JPanel c = container.getEditor().getPanel();
        this.componentToContainer.put(c, container);
        this.containers.add(container);
    }

    public boolean loadGrammar(String name) {
        String fileName = name + ".g";
        String folder = this.getDocument().getDocumentFolder();
        if (folder == null) {
            return false;
        }
        String file = XJUtils.concatPath(folder, fileName);
        if (!new File(file).exists()) {
            return false;
        }
        if (this.loadedGrammarFileNames.contains(fileName)) {
            return true;
        }
        this.loadedGrammarFileNames.add(fileName);
        ComponentDocumentFactory factory = new ComponentDocumentFactory(ComponentWindowImpl.class);
        ComponentDocumentInternal doc = factory.createInternalDocument(this);
        ComponentContainerInternal container = (ComponentContainerInternal)doc.getContainer();
        doc.awake();
        try {
            doc.load(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        this.window.addDocument(doc);
        this.addGrammar(container);
        return true;
    }

    public ComponentContainer getContainerForName(String name) {
        for (ComponentContainer c : this.containers) {
            if (!XJUtils.getPathByDeletingPathExtension(c.getDocument().getDocumentName()).equals(name)) continue;
            return c;
        }
        return null;
    }

    public ComponentEditorGrammar selectEditor(String name) {
        ComponentContainer c = this.getContainerForName(name);
        if (c != null) {
            return this.selectGrammar(c);
        }
        return null;
    }

    public void selectGrammar(XJDocument doc) {
        for (ComponentContainer c : this.containers) {
            if (c.getDocument() != doc) continue;
            this.selectGrammar(c);
            break;
        }
    }

    private ComponentEditorGrammar selectGrammar(ComponentContainer c) {
        JPanel panel = c.getEditor().getPanel();
        if (!this.editorsTab.hasComponent(panel)) {
            this.editorsTab.addComponent(c.getDocument().getDocumentName(), panel);
        }
        this.editorsTab.selectComponent(panel);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ComponentContainerGrammar.this.getSelectedEditor().getTextEditor().getTextPane().requestFocus();
            }
        });
        return this.getSelectedEditor();
    }

    public void dirtyChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ComponentContainerGrammar.this.updateEditorDirtyFlag();
            }
        });
    }

    public void editorContentChanged() {
        this.updateEditorDirtyFlag();
    }

    private void updateEditorDirtyFlag() {
        for (ComponentContainer c : this.containers) {
            JPanel panel = c.getEditor().getPanel();
            int index = this.editorsTab.indexOfComponent(panel);
            if (index == -1) continue;
            String title = c.getDocument().getDocumentName();
            if (title == null) {
                title = "";
            }
            if (c.getDocument().isDirty()) {
                this.editorsTab.setTitleAt(index, "* " + title);
                continue;
            }
            this.editorsTab.setTitleAt(index, title);
        }
    }

    public ComponentToolbar getToolbar() {
        return this.toolbar;
    }

    public ComponentEditorGrammar getSelectedEditor() {
        return (ComponentEditorGrammar)this.getSelectedContainer().getEditor();
    }

    public ComponentContainer getSelectedContainer() {
        return this.selectedContainer;
    }

    public Debugger getDebugger() {
        return this.debugger;
    }

    public ActionDebugger getActionDebugger() {
        return this.componentContainerGrammarMenu.getActionDebugger();
    }

    public ActionRefactor getActionRefactor() {
        return this.componentContainerGrammarMenu.getActionRefactor();
    }

    public ActionGoTo getActionGoTo() {
        return this.componentContainerGrammarMenu.getActionGoTo();
    }

    public void saveAll() {
        for (ComponentContainer container : this.containers) {
            container.getDocument().save(false);
        }
    }

    public ComponentContainerGrammarMenu getComponentContainerGrammarMenu() {
        return this.componentContainerGrammarMenu;
    }

    public boolean close() {
        for (ComponentContainer container : this.containers) {
            if (container == this) continue;
            container.close();
        }
        this.componentContainerGrammarMenu.close();
        this.editor.close();
        this.debugger.close();
        this.toolbar.close();
        this.editorsTab.removeChangeListener(this.etc);
        this.bottomTab.removeMouseListener(this.ml);
        this.bottomTab.removeChangeListener(this.cl);
        this.ml = null;
        this.cl = null;
        return true;
    }

    public void setDocument(ComponentDocument document) {
        this.window.setDocument(document);
    }

    public ComponentDocument getDocument() {
        return (ComponentDocument)this.window.getDocument();
    }

    public Dimension getSize() {
        return this.window.getSize();
    }

    public void becomingVisibleForTheFirstTime() {
        this.addGrammar(this);
        this.selectGrammar(this);
        this.getSelectedEditor().becomingVisibleForTheFirstTime();
        this.debugger.componentShouldLayout(this.getSize());
        for (ComponentContainer container : this.containers) {
            if (container == this) continue;
            container.becomingVisibleForTheFirstTime();
        }
    }

    public void setDirty() {
        this.window.setDirty();
    }

    public void createFile(String name) {
        String path = this.getEditor().getDocument().getDocumentFolder();
        String file = XJUtils.concatPath(path, name + ".g");
        String content = "grammar " + name + ";\n";
        try {
            XJUtils.writeStringToFile(content, file);
        }
        catch (IOException e) {
            XJAlert.display(this.window.getJavaContainer(), "Create File Error", "Cannot create file '" + name + "' because:\n" + e.toString());
            return;
        }
        this.reloadEditor(this.getSelectedEditor());
        this.selectEditor(name);
    }

    public void setEditor(ComponentEditor editor) {
        this.editor = editor;
    }

    public ComponentEditor getEditor() {
        return this.editor;
    }

    public XJFrameInterface getXJFrame() {
        return this.window;
    }

    public XJMainMenuBar getMainMenuBar() {
        return this.window.getMainMenuBar();
    }

    public void customizeFileMenu(XJMenu menu) {
        this.componentContainerGrammarMenu.customizeFileMenu(menu);
    }

    public void customizeMenuBar(XJMainMenuBar menubar) {
        this.componentContainerGrammarMenu.customizeMenuBar(menubar);
    }

    public void menuItemState(XJMenuItem item) {
        this.componentContainerGrammarMenu.menuItemState(item);
    }

    public void handleMenuSelected(XJMenu menu) {
        this.componentContainerGrammarMenu.handleMenuSelected(menu);
    }

    public JComponent getRulesComponent() {
        return this.rulesPanel;
    }

    public JComponent getEditorComponent() {
        return this.mainPanel;
    }

    public void windowActivated() {
        for (ComponentContainer container : this.containers) {
            container.getEditor().componentActivated();
        }
        for (EditorTab et : this.tabs) {
            et.editorActivated();
        }
    }

    public ContextualMenuFactory createContextualMenuFactory() {
        return new ContextualMenuFactory(this.componentContainerGrammarMenu);
    }

    public JPopupMenu getContextualMenu(int textIndex) {
        return this.componentContainerGrammarMenu.getContextualMenu(textIndex);
    }

    public void addTab(EditorTab tab) {
        int index = this.getSimilarTab(tab);
        if (index == -1) {
            this.tabs.add(tab);
            this.bottomTab.add(tab.getTabName(), tab.getTabComponent());
            index = this.bottomTab.getTabCount() - 1;
        } else {
            this.tabs.remove(index);
            this.tabs.add(index, tab);
            this.bottomTab.removeTabAt(index + 4);
            this.bottomTab.insertTab(tab.getTabName(), null, tab.getTabComponent(), null, index + 4);
        }
        this.indexToEditorTab.put(index, tab);
        this.selectTab(tab.getTabComponent());
    }

    private void closeTab(int index) {
        if (index < 4) {
            return;
        }
        this.tabs.remove(index - 4);
        this.bottomTab.removeTabAt(index);
    }

    public void selectConsoleTab(ComponentEditor editor) {
        this.switchToEditor((ComponentEditorGrammar)editor);
        this.selectTab(this.consolePanel);
    }

    public void selectInterpreterTab(ComponentEditor editor) {
        this.switchToEditor((ComponentEditorGrammar)editor);
        this.selectTab(this.interpreterPanel);
    }

    public void selectSyntaxDiagramTab(ComponentEditor editor) {
        this.switchToEditor((ComponentEditorGrammar)editor);
        this.selectTab(this.sdPanel);
    }

    public void documentLoaded(ComponentDocument document) {
    }

    public void editorParsed(ComponentEditor editor) {
        this.reloadEditor(editor);
    }

    private void reloadEditor(ComponentEditor editor) {
        GrammarEngine engine = ((ComponentEditorGrammar)editor).getGrammarEngine();
        this.engines.put(editor.getDocument().getDocumentNameWithoutExtension(), engine);
        engine.parserCompleted();
        for (ElementImport element : engine.getImports()) {
            this.loadGrammar(element.getName());
        }
        this.updateHierarchy();
        engine.updateAll();
        for (ComponentContainer c : this.containers) {
            ComponentEditorGrammar eg = (ComponentEditorGrammar)c.getEditor();
            eg.getTextEditor().damage();
        }
    }

    private void updateHierarchy() {
        GrammarEngine engine = this.engines.get(this.getDocument().getDocumentNameWithoutExtension());
        HashSet<GrammarEngine> alreadyVisitedEngines = new HashSet<GrammarEngine>();
        engine.updateHierarchy(this.engines, alreadyVisitedEngines);
    }

    public int getSimilarTab(EditorTab tab) {
        for (int i = 0; i < this.tabs.size(); ++i) {
            EditorTab t = this.tabs.get(i);
            if (!t.getTabName().equals(tab.getTabName())) continue;
            return i;
        }
        return -1;
    }

    public EditorTab getSelectedTab() {
        int index = this.bottomTab.getSelectedIndex();
        switch (index) {
            case 0: {
                return this.getSelectedEditor().getComponentSD();
            }
            case 1: {
                return this.getSelectedEditor().getComponentInterpreter();
            }
            case 2: {
                return this.getSelectedEditor().getComponentConsole();
            }
            case 3: {
                return this.debugger;
            }
        }
        return this.indexToEditorTab.get(index);
    }

    public void selectTab(Component c) {
        if (this.bottomTab.getSelectedComponent() != c) {
            this.bottomTab.setSelectedComponent(c);
            this.getSelectedEditor().refreshMainMenuBar();
        }
        this.makeBottomTabVisible();
    }

    private void makeBottomTabVisible() {
        if (this.horizontalSplit.getBottomComponent().getHeight() == 0) {
            this.horizontalSplit.setDividerLocation(this.horizontalSplit.getLastDividerLocation());
        }
    }

    private void switchToEditor(final ComponentEditorGrammar editor) {
        this.setComponent(this.toolbarPanel, this.toolbar.getToolbar());
        this.setComponent(this.rulesPanel, editor.getComponentRules());
        this.setComponent(this.sdPanel, editor.getComponentSD());
        this.setComponent(this.interpreterPanel, editor.getComponentInterpreter());
        this.setComponent(this.consolePanel, editor.getComponentConsole());
        this.setComponent(this.debuggerPanel, this.debugger);
        this.bottomPanel.removeAll();
        this.bottomPanel.add((Component)this.bottomTab, "Center");
        this.bottomPanel.add((Component)editor.getStatusComponent(), "South");
        this.bottomPanel.revalidate();
        this.bottomPanel.repaint();
        this.toolbar.updateStates();
        editor.refreshMainMenuBar();
        this.window.setTitle(this.selectedContainer.getDocument().getDocumentPath());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                editor.getTextEditor().getTextPane().requestFocus();
            }
        });
    }

    public void setComponent(JPanel panel, EditorTab tab) {
        this.setComponent(panel, tab.getTabComponent());
    }

    public void setComponent(JPanel panel, Component c) {
        panel.removeAll();
        panel.add(c);
        panel.revalidate();
        panel.repaint();
    }

    public class BottomTabbedPaneChangeListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            ComponentContainerGrammar.this.getSelectedEditor().refreshMainMenuBar();
        }
    }

    public class BottomTabbedPaneMouseListener
    extends MouseAdapter {
        public void displayPopUp(MouseEvent event) {
            if (ComponentContainerGrammar.this.bottomTab.getSelectedIndex() < 4) {
                return;
            }
            if (!event.isPopupTrigger()) {
                return;
            }
            JPopupMenu popup = new JPopupMenu();
            JMenuItem item = new JMenuItem("Close");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    ComponentContainerGrammar.this.closeTab(ComponentContainerGrammar.this.bottomTab.getSelectedIndex());
                }
            });
            popup.add(item);
            popup.show(event.getComponent(), event.getX(), event.getY());
        }

        public void mousePressed(MouseEvent event) {
            this.displayPopUp(event);
        }

        public void mouseReleased(MouseEvent event) {
            this.displayPopUp(event);
        }
    }

    private class EditorsTabChangeListener
    implements ChangeListener {
        private EditorsTabChangeListener() {
        }

        public void stateChanged(ChangeEvent event) {
            Component c = ComponentContainerGrammar.this.editorsTab.getSelectedComponent();
            ComponentContainerGrammar.this.selectedContainer = (ComponentContainer)ComponentContainerGrammar.this.componentToContainer.get(c);
            ComponentEditorGrammar editor = (ComponentEditorGrammar)ComponentContainerGrammar.this.selectedContainer.getEditor();
            ComponentContainerGrammar.this.switchToEditor(editor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ContainerDebuggerDelegate
    implements DebuggerDelegate {
        @Override
        public GrammarEngine getGrammarEngine() {
            return ComponentContainerGrammar.this.getSelectedEditor().getGrammarEngine();
        }

        @Override
        public String getGrammarName() {
            return XJUtils.getPathByDeletingPathExtension(ComponentContainerGrammar.this.getSelectedEditor().getGrammarFileName());
        }

        @Override
        public void debuggerStarted() {
            ComponentContainerGrammar.this.selectTab(ComponentContainerGrammar.this.debuggerPanel);
            ((EditorConsole)this.getConsole()).makeCurrent();
            for (ComponentContainer c : ComponentContainerGrammar.this.containers) {
                c.getEditor().setEditable(false);
            }
            ComponentContainerGrammar.this.refreshMainMenuBar();
        }

        @Override
        public void debuggerStopped() {
            ComponentContainerGrammar.this.getSelectedEditor().setDebuggerLocation(-1);
            for (ComponentContainer c : ComponentContainerGrammar.this.containers) {
                c.getEditor().setEditable(true);
            }
            ComponentContainerGrammar.this.refreshMainMenuBar();
        }

        @Override
        public void debuggerSetLocation(String grammar, int line, int column) {
            ComponentContainerGrammar.this.selectEditor(grammar);
            int grammarIndex = this.computeAbsoluteGrammarIndex(line, column);
            if (grammarIndex >= 0) {
                ComponentContainerGrammar.this.getSelectedEditor().setDebuggerLocation(grammarIndex);
            }
        }

        @Override
        public void debuggerSelectText(String grammar, int line, int column) {
            ComponentContainerGrammar.this.selectEditor(grammar);
            int grammarIndex = this.computeAbsoluteGrammarIndex(line, column);
            if (grammarIndex >= 0) {
                ComponentContainerGrammar.this.getSelectedEditor().selectTextRange(grammarIndex, grammarIndex + 1);
            }
        }

        @Override
        public XJDocument getDocument() {
            return ComponentContainerGrammar.this.getSelectedEditor().getDocument();
        }

        @Override
        public List<ElementRule> getRules() {
            return ComponentContainerGrammar.this.getSelectedEditor().getRules();
        }

        @Override
        public List<ElementRule> getSortedRules() {
            return ComponentContainerGrammar.this.getSelectedEditor().getSortedRules();
        }

        @Override
        public boolean ensureDocumentSaved() {
            return ComponentContainerGrammar.this.getSelectedEditor().ensureDocumentSaved();
        }

        @Override
        public CodeGenerate getCodeGenerate() {
            return new CodeGenerate(ComponentContainerGrammar.this.getSelectedEditor(), null);
        }

        @Override
        public String getTokenVocab() {
            return ComponentContainerGrammar.this.getSelectedEditor().getGrammarEngine().getTokenVocab();
        }

        @Override
        public Container getContainer() {
            return ComponentContainerGrammar.this.getSelectedEditor().getJavaContainer();
        }

        @Override
        public Console getConsole() {
            return ComponentContainerGrammar.this.getSelectedEditor().getConsole();
        }

        @Override
        public List<ElementBlock> getBlocks() {
            return ComponentContainerGrammar.this.getSelectedEditor().getGrammarEngine().getBlocks();
        }

        @Override
        public Map<Integer, Set<String>> getBreakpoints() {
            HashMap<Integer, Set<String>> breakpoints = new HashMap<Integer, Set<String>>();
            for (ComponentContainer c : ComponentContainerGrammar.this.containers) {
                ComponentEditorGrammar g = (ComponentEditorGrammar)c.getEditor();
                for (Integer line : g.getBreakpoints()) {
                    HashSet<String> names = (HashSet<String>)breakpoints.get(line);
                    if (names == null) {
                        names = new HashSet<String>();
                        breakpoints.put(line, names);
                    }
                    names.add(XJUtils.getPathByDeletingPathExtension(g.getGrammarFileName()));
                }
            }
            return breakpoints;
        }

        @Override
        public ContextualMenuFactory createContextualMenuFactory() {
            return ComponentContainerGrammar.this.createContextualMenuFactory();
        }

        @Override
        public void selectConsoleTab() {
            ComponentContainerGrammar.this.getSelectedEditor().selectConsoleTab();
        }

        private int computeAbsoluteGrammarIndex(int lineIndex, int column) {
            List<ATELine> lines = ComponentContainerGrammar.this.getSelectedEditor().getLines();
            if (lineIndex - 1 < 0 || lineIndex - 1 >= lines.size()) {
                return -1;
            }
            ATELine line = lines.get(lineIndex - 1);
            return line.position + column - 1;
        }
    }
}

