/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.ate.syntax.generic;

import java.util.List;
import java.util.Stack;
import org.antlr.works.ate.syntax.misc.ATEToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ATESyntaxParser {
    private List<ATEToken> tokens;
    private Stack<Integer> marks = new Stack();
    private int position;
    private ATEToken t0;
    private ATEToken t1;

    public void close() {
        if (this.tokens != null) {
            this.tokens.clear();
        }
        this.t1 = null;
        this.t0 = null;
    }

    public void parse(List<ATEToken> tokens) {
        this.tokens = tokens;
        this.marks.clear();
        this.position = -1;
        this.clearTokenCache();
        this.parseTokens();
    }

    public abstract void parseTokens();

    public List<ATEToken> getTokens() {
        return this.tokens;
    }

    public int getPosition() {
        return this.position;
    }

    public void mark() {
        this.marks.push(this.position);
    }

    public void rewind() {
        this.position = this.marks.pop();
        this.clearTokenCache();
    }

    public boolean previousToken() {
        --this.position;
        this.clearTokenCache();
        return this.position >= 0;
    }

    public boolean nextToken() {
        ++this.position;
        this.clearTokenCache();
        return this.position < this.tokens.size();
    }

    public boolean moreTokens() {
        return this.position < this.tokens.size();
    }

    public boolean skip(int count) {
        if (count == 1) {
            return this.nextToken();
        }
        for (int i = 0; i < count; ++i) {
            if (this.nextToken()) continue;
            return false;
        }
        return true;
    }

    public ATEToken T(int index) {
        if (index == 0) {
            if (this.t0 == null) {
                this.t0 = this.getToken(0);
            }
            return this.t0;
        }
        if (index == 1) {
            if (this.t1 == null) {
                this.t1 = this.getToken(1);
            }
            return this.t1;
        }
        return this.getToken(index);
    }

    public ATEToken getToken(int index) {
        if (this.position + index >= 0 && this.position + index < this.tokens.size()) {
            return this.tokens.get(this.position + index);
        }
        return null;
    }

    private void clearTokenCache() {
        this.t0 = null;
        this.t1 = null;
    }

    public boolean matchSingleComment(int index) {
        if (this.isSingleComment(index)) {
            this.nextToken();
            return true;
        }
        return false;
    }

    public boolean matchComplexComment(int index) {
        if (this.isComplexComment(index)) {
            this.nextToken();
            return true;
        }
        return false;
    }

    public boolean matchSingleQuoteString(int index) {
        if (this.isTokenType(index, 1)) {
            this.nextToken();
            return true;
        }
        return false;
    }

    public boolean isChar(int index, String c) {
        return this.isTokenType(index, 6) && this.T(index).getAttribute().equals(c);
    }

    public boolean isSingleComment(int index) {
        return this.isTokenType(index, 3);
    }

    public boolean isComplexComment(int index) {
        return this.isTokenType(index, 4);
    }

    public boolean isID(int index) {
        return this.isTokenType(index, 5);
    }

    public boolean isID(int index, String attribute) {
        return this.isTokenType(index, 5) && this.T(index).getAttribute().equals(attribute);
    }

    public boolean isTokenType(int index, int type) {
        return this.T(index) != null && this.T((int)index).type == type;
    }
}

