/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.ate;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.BadLocationException;
import org.antlr.works.ate.ATEPanel;

public abstract class ATEUnderlyingManager {
    protected ATEPanel textEditor;
    protected UnderlyingShape underlyingShape;
    protected boolean underlying = true;
    public static final int SHAPE_SAW_TOOTH = 1;
    public static final int SHAPE_LINE = 2;
    public static final int SHAPE_RECT = 3;

    public ATEUnderlyingManager(ATEPanel textEditor) {
        this.textEditor = textEditor;
        this.underlyingShape = new UnderlyingShape();
    }

    public void close() {
        this.textEditor = null;
    }

    public void setUnderlying(boolean flag) {
        this.underlying = flag;
    }

    public void reset() {
        this.underlyingShape.reset();
    }

    public void paint(Graphics g) {
        if (!this.underlying) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        if (this.underlyingShape.isReady()) {
            this.underlyingShape.draw(g2d);
            return;
        }
        this.underlyingShape.begin();
        this.render(g);
        this.underlyingShape.end();
        this.underlyingShape.draw(g2d);
    }

    public abstract void render(Graphics var1);

    public void drawUnderlineAtIndexes(Graphics g, Color c, int start, int end, int shape) {
        try {
            Rectangle r1 = this.textEditor.textPane.modelToView(start);
            Rectangle r2 = this.textEditor.textPane.modelToView(end);
            g.setColor(c);
            switch (shape) {
                case 1: {
                    int width = r2.x - r1.x;
                    int triangle_size = 5;
                    for (int triangle = 0; triangle < width / triangle_size; ++triangle) {
                        int x = r1.x + triangle * triangle_size;
                        int y = r1.y + r1.height - 1;
                        g.drawLine(x, y, x + triangle_size / 2, y - triangle_size / 2);
                        g.drawLine(x + triangle_size / 2, y - triangle_size / 2, x + triangle_size, y);
                        this.underlyingShape.addLine(c, x, y, x + triangle_size / 2, y - triangle_size / 2);
                        this.underlyingShape.addLine(c, x + triangle_size / 2, y - triangle_size / 2, x + triangle_size, y);
                    }
                    break;
                }
                case 2: {
                    g.drawLine(r1.x, r1.y + r1.height, r2.x, r2.y + r2.height);
                    this.underlyingShape.addLine(c, r1.x, r1.y + r1.height, r2.x, r2.y + r2.height);
                    break;
                }
                case 3: {
                    g.drawRect(r1.x, r1.y, r2.x + r2.width - r1.x, r1.height);
                    this.underlyingShape.addRect(c, r1.x, r1.y, r2.x + r2.width, r2.y + r2.height);
                }
            }
        }
        catch (BadLocationException e) {
            // empty catch block
        }
    }

    public static class UnderlyingShape {
        public Map<Color, GeneralPath> shapes = new HashMap<Color, GeneralPath>();
        public boolean ready = false;

        public void addLine(Color c, int x1, int y1, int x2, int y2) {
            GeneralPath gp = this.shapes.get(c);
            if (gp == null) {
                gp = new GeneralPath();
                this.shapes.put(c, gp);
            }
            gp.moveTo(x1, y1);
            gp.lineTo(x2, y2);
        }

        public void addRect(Color c, int x1, int y1, int x2, int y2) {
            GeneralPath gp = this.shapes.get(c);
            if (gp == null) {
                gp = new GeneralPath();
                this.shapes.put(c, gp);
            }
            gp.moveTo(x1, y1);
            gp.lineTo(x2, y1);
            gp.lineTo(x2, y2);
            gp.lineTo(x1, y2);
            gp.lineTo(x1, y1);
        }

        public void draw(Graphics2D g) {
            for (Color c : this.shapes.keySet()) {
                g.setColor(c);
                g.draw(this.shapes.get(c));
            }
        }

        public void begin() {
            this.reset();
        }

        public void end() {
            this.ready = true;
        }

        public boolean isReady() {
            return this.ready;
        }

        public void reset() {
            this.shapes.clear();
            this.ready = false;
        }
    }
}

