package org.antlr.works.components.project.file;

import org.antlr.works.components.ComponentDocument;
import org.antlr.works.components.ComponentEditor;
import org.antlr.works.components.grammar.CDocumentGrammar;
import org.antlr.works.components.grammar.CEditorGrammar;
import org.antlr.works.components.project.CContainerProject;
import org.antlr.works.project.ProjectFileItem;

import javax.swing.*;
import java.awt.*;
/*

[The "BSD licence"]
Copyright (c) 2005-2006 Jean Bovet
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright
notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*/

public class CContainerProjectGrammar extends CContainerProjectFile {

    public CContainerProjectGrammar(CContainerProject project, ProjectFileItem item) {
        super(project, item);
    }

    public void awake() {
        // We need to set a border for the grammar panel because it doesn't
        // have one by default when used alone in a window
        editor.getPanel().setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, Color.lightGray));
    }

    public ComponentDocument createDocument() {
        return new CDocumentGrammar();
    }

    public ComponentEditor createEditor() {
        return new CEditorGrammar(this);
    }
}
