# Part of the A-A-P recipe executive: Testing of remembering signatures

# Copyright (C) 2002-2003 Stichting NLnet Labs
# Permission to copy and use this file is specified in the file COPYING.
# If this file is missing you can find it here: http://www.a-a-p.org/COPYING

import sys, os, stat

def runaap(args):
    return os.system("%s ..%sMain.py %s" % (sys.argv[1], os.sep, args))

os.chdir("rectest")

# Create a recipe and try running it.
# Then run it again and check it doesn't do the same thing twice.
rec = "rectest.aap"
inp = "rectest.in"
out = "rectest.out"

f = open(rec, "w")
f.write("""
%s: %s
    :cat %s >> %s
""" % (out, inp, inp, out))
f.close()

f = open(inp, "w")
f.write("This is input\n")
f.close()

f = open(out, "w")
f.write("This is output\n")
f.close()

# When running twice, the second time nothing should happen, since the source
# file didn't change.
runaap("-f %s %s" % (rec, out))
st1 = os.stat(out)
runaap("-f %s %s" % (rec, out))
st2 = os.stat(out)

res = 0
if st1[stat.ST_SIZE] != st2[stat.ST_SIZE]:
    print "Aap rebuild when it was not needed"
    res = 1

f = open(inp, "w")
f.write("This is foo again\n")
f.close()

# When running again while the source has changed, the result must change as
# well.
runaap("-f %s %s" % (rec, out))
st2 = os.stat(out)
if st1[stat.ST_SIZE] == st2[stat.ST_SIZE]:
    print "Aap did not rebuild when it was needed"
    res = 1

os.remove(rec)
os.remove(inp)
os.remove(out)

sys.exit(res)


# vim: set sw=4 et sts=4 tw=79 fo+=l:
