<p>This page is the site accessibility statement for {$modvars.ZConfig.sitename}. If you have any questions or comments, please feel free to <a href="mailto:{$modvars.ZConfig.adminmail}">contact the site administrator</a>.</p>
<h2>Access keys</h2>
<p>Most browsers support jumping to specific links by typing keys defined on the site. Under the Microsoft Windows operating system, you can press the 'Alt' key plus an access key; on an Apple Macintosh operating system, you can press the 'Control' key plus an access key.</p>
<p>The following access keys are defined for all pages on this site:</p>
<ul>
<li>No access keys currently defined.</li>
{*
<li>define your sites access keys here</li>
<li>add each key as a seperate list item</li>
*}
</ul>
<h2>Standards compliance</h2>
<ol>
<li>All pages on this site are <a href="http://bobby.watchfire.com/">Bobby <acronym title="triple A">AAA</acronym>-approved</a>, and comply with <a href="http://bobby.watchfire.com/bobby/html/en/browsereport.jsp">all the Bobby guidelines</a>. This is a question of judgment: many accessibility features can be measured, but many others cannot. All the guidelines have been reviewed, and it is believed that all the site's pages are in compliance.</li>
<li>All pages on this site are <acronym title="Web Content Accessibility Guidelines">WCAG</acronym> <acronym title="triple A">AAA</acronym>-approved, and comply with <a href="http://www.w3.org/TR/WAI-WEBCONTENT/full-checklist.html">all priority 1, 2, and 3 guidelines</a> of the <a href="http://www.w3.org/TR/WCAG10/"><acronym title="World Wide Web Consortium">W3C</acronym> Web Content Accessibility Guidelines</a>. Again, this is a question of judgment: many of the guidelines are intentionally vague, and cannot be tested automatically. All the guidelines have been reviewed, and it is believed that all the site's pages are in compliance.</li>
<li>All pages on this site are <a href="http://bobby.watchfire.com/">approved under the terms of Section 508</a>, and comply with all of the <acronym title="United States">U.S.</acronym> Federal Government <a href="http://www.section508.gov/">Section 508 Guidelines</a>. Once again, this is a question of judgment. All the guidelines have been reviewed, and it is believed that all the site's pages are in compliance.</li>
<li>All pages on this site <a href="http://validator.w3.org/">validate as <acronym title="extensible hypertext markup language">XHTML</acronym> 1.0 Strict</a>. This is not a question of judgment: a program can determine with 100% accuracy whether a page is valid XHTML. For example, you can <a href="http://validator.w3.org/check?uri=referer">click here to check this  page for XHTML validity</a>.</li>
<li>All pages on this site use structured semantic mark-up language. H2 tags are used for main titles, and H3 tags are used for subtitles. For example, on this page you are reading, JAWS users can skip to the next section within the accessibility statement by pressing <kbd>ALT+INSERT+3</kbd>.</li>
</ol>
<h2>Navigation aids</h2>
<ol>
<li>All pages have <tt>rel=previous, next, up,</tt> and <tt>home</tt> links to aid navigation in text-only browsers. Mozilla users can also take advantage of this feature by opening the 'View' menu, and selecting 'Show/Hide', 'Site Navigation Bar', 'Show Only As Needed' (or 'Show Always').</li>
<li>All pages include a search box (access key 4). Advanced search options are available on the <a href="{modurl modname='Search' type='user' func='form'}">site search page</a>.</li>
{*
<li>include any other navigation aids here</li>
*}
</ol>
<h2>Links</h2>
<ol>
<li>All links have title attributes which describe the link in greater detail, unless the text of the link already fully describes the target (such as the headline of an article).</li>
<li>Links are written to make sense even when read out of context.</li>
</ol>
<h2>Images</h2>
<ol>
<li>All content images used in this site include descriptive <code>ALT</code> attributes. Purely-decorative graphics include null <code>ALT</code> attributes.</li>
<li>Complex images include <acronym title="long description">LONGDESC</acronym> attributes, or in-line descriptions to explain the significance of each image to non-visual readers.</li>
</ol>
<h2>Visual design</h2>
<ol>
<li>This site uses cascading style sheets for visual layout.</li>
<li>Only relative font sizes are used, so as to be compatible with the user-specified 'text size' option in visual browsers.</li>
<li>If your browser or browsing device does not support style sheets at all, the content of each page will still be readable.</li>
</ol>
