// Wild Magic Source Code
// David Eberly
// http://www.geometrictools.com
// Copyright (c) 1998-2009
//
// This library is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation; either version 2.1 of the License, or (at
// your option) any later version.  The license is available for reading at
// either of the locations:
//     http://www.gnu.org/copyleft/lgpl.html
//     http://www.geometrictools.com/License/WildMagicLicense.pdf
//
// Version: 4.0.0 (2006/06/28)

#include "Wm4SoftRendererPCH.h"
#include "Wm4SoftRenderer.h"
#include "Wm4SoftResources.h"
using namespace Wm4;

//----------------------------------------------------------------------------
void SoftRenderer::ApplyVertexShader ()
{
    // Resize the output array, if necessary.
    int iVQuantity = m_pkVBResource->VQuantity;
    int iRequestedChannels = m_iNumOutputChannels*iVQuantity;
    m_kOutputVertex.EnsureCapacity(iRequestedChannels);

    const float* afInVertex = m_pkVBResource->IVertex;
    const float* afRegister = m_kVRegister.GetData();
    float* afOutVertex = m_kOutputVertex.GetData();
    for (int i = 0; i < iVQuantity; i++)
    {
        // The hardware-based shaders store text strings for the vertex
        // program, which are passed to the hardware via OpenGL or DirectX.
        // The software-based shaders have C implementations.
        m_oVProgram(afRegister,afInVertex,afOutVertex);

        afInVertex += m_iNumInputChannels;
        afOutVertex += m_iNumOutputChannels;
    }

    // This is the vertex index where points generated by clipping will be
    // stored in m_kOutputVertex.  The actual 'float' index is
    // m_iNumOutputChannels*m_iNextVertexIndex.
    m_iNextVertexIndex = iVQuantity;
}
//----------------------------------------------------------------------------
