// Wild Magic Source Code
// David Eberly
// http://www.geometrictools.com
// Copyright (c) 1998-2009
//
// This library is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation; either version 2.1 of the License, or (at
// your option) any later version.  The license is available for reading at
// either of the locations:
//     http://www.gnu.org/copyleft/lgpl.html
//     http://www.geometrictools.com/License/WildMagicLicense.pdf
//
// Version: 4.0.0 (2006/06/28)

#ifndef WM4MASSSPRINGCURVE_H
#define WM4MASSSPRINGCURVE_H

#include "Wm4PhysicsLIB.h"
#include "Wm4ParticleSystem.h"

namespace Wm4
{

template <class Real, class TVector>
class WM4_PHYSICS_ITEM MassSpringCurve : public ParticleSystem<Real,TVector>
{
public:
    // Construction and destruction.  This class represents a set of N-1
    // springs connecting N masses that lie on a curve.  Spring i connects
    // masses i-1 and i for 1 <= i <= N-1.
    MassSpringCurve (int iNumParticles, Real fStep);
    virtual ~MassSpringCurve ();

    int GetNumSprings () const;
    Real& Constant (int i);  // spring constant
    Real& Length (int i);  // spring resting length

    // Callback for acceleration (ODE solver uses x" = F/m) applied to
    // particle i.  The positions and velocities are not necessarily
    // m_akPosition and m_akVelocity since the ODE solver evaluates the
    // impulse function at intermediate positions.
    virtual TVector Acceleration (int i, Real fTime,
        const TVector* akPosition, const TVector* akVelocity);

    // The default external force is zero.  Derive a class from this one to
    // provide nonzero external forces such as gravity, wind, friction,
    // and so on.  This function is called by Acceleration(...) to append the
    // acceleration F/m generated by the external force F.
    virtual TVector ExternalAcceleration (int i, Real fTime,
        const TVector* akPosition, const TVector* akVelocity);

protected:
    using ParticleSystem<Real,TVector>::m_iNumParticles;
    using ParticleSystem<Real,TVector>::m_afInvMass;

    int m_iNumSprings;
    Real* m_afConstant;
    Real* m_afLength;
};

typedef MassSpringCurve<float,Vector2f> MassSpringCurve2f;
typedef MassSpringCurve<double,Vector2d> MassSpringCurve2d;
typedef MassSpringCurve<float,Vector3f> MassSpringCurve3f;
typedef MassSpringCurve<double,Vector3d> MassSpringCurve3d;

}

#endif
