// Wild Magic Source Code
// David Eberly
// http://www.geometrictools.com
// Copyright (c) 1998-2009
//
// This library is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation; either version 2.1 of the License, or (at
// your option) any later version.  The license is available for reading at
// either of the locations:
//     http://www.gnu.org/copyleft/lgpl.html
//     http://www.geometrictools.com/License/WildMagicLicense.pdf
//
// Version: 4.6.0 (2007/08/20)

#ifndef WM4CONTELLIPSE2MINCR_H
#define WM4CONTELLIPSE2MINCR_H

#include "Wm4FoundationLIB.h"
#include "Wm4Matrix2.h"

// The ellipse in general form is  X^t A X + B^t X + C = 0 where
// A is a positive definite 2x2 matrix, B is a 2x1 vector, C is a
// scalar, and X is a 2x1 vector X.  Completing the square,
// (X-U)^t A (X-U) = U^t A U - C where U = -0.5 A^{-1} B.  Define
// M = A/(U^t A U - C).  The ellipse is (X-U)^t M (X-U) = 1.  Factor
// M = R^t D R where R is orthonormal and D is diagonal with positive
// diagonal terms.  If Y = R(X-U), then the ellipse is 1 = Y^t D Y =
// d1*y1^2+d2*y2^2.  For an ellipse (x/a)^2+(y/b)^2 = 1, the area is
// pi*a*b.  For Y^t D Y = 1, the area is therefore pi/sqrt(d1*d2).
// Finally, note that det(M) = det(D) = d1*d2, so the area of the
// ellipse is pi/sqrt(det(M)).
//
// Compute minimal area ellipse (X-C)^t R^t D R (X-C) = 1 given center
// C and orientation matrix R by finding diagonal D.  Minimal area is
// pi/sqrt(D[0]*D[1]).

namespace Wm4
{

template <class Real>
class WM4_FOUNDATION_ITEM ContEllipse2MinCR
{
public:
    ContEllipse2MinCR (int iQuantity, const Vector2<Real>* akPoint,
        const Vector2<Real>& rkC, const Matrix2<Real>& rkR, Real afD[2]);

private:
    void MaxProduct (int iQuantity, std::vector<Vector2<Real> >& rkA,
        Real& rfX, Real& rfY);
};

typedef ContEllipse2MinCR<float> ContEllipse2MinCRf;
typedef ContEllipse2MinCR<double> ContEllipse2MinCRd;

}

#endif
