/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;

public class TruthTable {
    private ArrayList rules = null;
    private Var[] vars = null;
    private HashMap letterToVal = null;
    private boolean isFile = false;
    private static PrintStream out = System.out;
    public static final String VERSION = "1.2.1";

    public static void main(String[] stringArray) {
        TruthTable truthTable = new TruthTable();
        BufferedReader bufferedReader = null;
        System.out.println("TruthTable version: 1.2.1");
        System.out.println("\nHello and welcome to Greg's Truth Table generator!\nVery little error checking has been built into this so\ndo try to follow these simple conventions:\n\n-----------------------------------------------------\nAND: ^ OR: v NOT: ! XOR: x\nImplication: -> Biconditional: <->\n\nThe following letters are not allowed as variables:\nx v i d\nYou may use the uppercase versions\n-----------------------------------------------------\n");
        String string = null;
        String string2 = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            if (stringArray.length == 2 && stringArray[0].equals("-f")) {
                truthTable.setFile(stringArray[1]);
            }
            while (!bl) {
                System.out.print("Enter the single-character variables you will use\nseparated by spaces or press return to quit:\n> ");
                string2 = bufferedReader.readLine();
                if (string2.length() == 0) break;
                try {
                    truthTable.addVars(string2.split(" "));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.out.println(illegalArgumentException.getMessage());
                    continue;
                }
                System.out.println("\nNow enter your propositions one at a time\nPress the return key to print the table:");
                System.out.print("> ");
                while (!(string = bufferedReader.readLine().trim()).equals("")) {
                    System.out.print("> ");
                    truthTable.addRule(string);
                }
                truthTable.print();
                if (truthTable.fileOpen()) {
                    System.out.println("\nTable written to: " + stringArray[1] + "\n");
                }
                truthTable.reset();
            }
            truthTable.setFile(null);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public TruthTable() {
        this.rules = new ArrayList();
        this.letterToVal = new HashMap();
    }

    public TruthTable(int n) {
        this.vars = new Var[n];
        this.rules = new ArrayList();
        this.letterToVal = new HashMap();
    }

    public void addVars(String[] stringArray) {
        if (this.vars == null) {
            this.vars = new Var[stringArray.length];
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.indexOf(120) != -1 || string.indexOf(118) != -1 || string.indexOf(105) != -1 || string.indexOf(100) != -1) {
                this.vars = null;
                throw new IllegalArgumentException("Bad variable name");
            }
            this.letterToVal.put(string, new Integer(i));
            this.vars[i] = new Var(string);
        }
    }

    public void reset() {
        this.letterToVal.clear();
        this.rules.clear();
        this.vars = null;
    }

    public void addRule(String string) {
        this.rules.add(string);
    }

    public void setFile(String string) {
        if (string != null) {
            this.isFile = true;
            try {
                out = new PrintStream(new FileOutputStream(string));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                out.close();
                out = System.out;
                this.isFile = false;
            }
        } else if (this.isFile) {
            this.isFile = false;
            out.close();
        }
    }

    public boolean fileOpen() {
        return this.isFile;
    }

    public void finalize() {
        if (this.isFile) {
            this.isFile = false;
            out.close();
        }
    }

    public static void print(String string) {
        out.print(string);
    }

    public static void println(String string) {
        TruthTable.print(string + "\n");
    }

    public void print() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.rules.size();
        int n5 = this.vars.length;
        boolean[] blArray = new boolean[n5];
        int n6 = 0;
        n6 += 2 * n5;
        for (n = 0; n < n4; ++n) {
            n6 += 3 + ((String)this.rules.get(n)).length();
        }
        char[] cArray = new char[n6 + 2];
        for (n = 0; n <= n6; ++n) {
            cArray[n] = 45;
        }
        cArray[n] = 10;
        out.print('\n');
        out.print(cArray);
        out.print(' ');
        for (n = 0; n < n5; ++n) {
            TruthTable.print(this.vars[n].letter + " ");
            blArray[n] = true;
        }
        for (n = 0; n < n4; ++n) {
            TruthTable.print("| " + this.rules.get(n) + " ");
        }
        out.print('\n');
        out.print(cArray);
        int n7 = (int)Math.pow(2.0, n5);
        String string = null;
        int n8 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        Object var15_13 = null;
        for (n = 0; n < n7; ++n) {
            this.initVals(blArray, n);
            out.print(' ');
            this.printTruths(blArray);
            for (n2 = 0; n2 < n4; ++n2) {
                string = (String)this.rules.get(n2);
                n8 = string.length();
                string = string.replaceAll("<->", "d");
                string = string.replaceAll("->", "i");
                for (n3 = 0; n3 < n5; ++n3) {
                    string = string.replaceAll(this.vars[n3].letter, this.boolToStr(blArray[(Integer)this.letterToVal.get(this.vars[n3].letter)]));
                }
                int n9 = string.length();
                for (n3 = 0; n3 < n9; ++n3) {
                    char c = string.charAt(n3);
                    if (c == ' ') continue;
                    arrayList.add(String.valueOf(c));
                }
                out.print('|');
                this.printSpaces(n8 + 2, true);
                TruthTable.print(this.parse(arrayList, 0, false));
                this.printSpaces(n8 + 2, false);
                arrayList.clear();
            }
            out.print('\n');
        }
        out.print(cArray);
        out.print('\n');
    }

    private void printSpaces(int n, boolean bl) {
        int n2 = n % 2 == 0 && !bl ? n / 2 - 1 : n / 2;
        for (int i = 0; i < n2; ++i) {
            out.print(' ');
        }
    }

    private String parse(ArrayList arrayList, int n, boolean bl) {
        this.parseSubGroup(arrayList, n, "!", bl);
        this.parseSubGroup(arrayList, n, "^", bl);
        this.parseSubGroup(arrayList, n, "v", bl);
        this.parseSubGroup(arrayList, n, "x", bl);
        this.parseSubGroup(arrayList, n, "i", bl);
        this.parseSubGroup(arrayList, n, "d", bl);
        return (String)arrayList.get(0);
    }

    private void parseSubGroup(ArrayList arrayList, int n, String string, boolean bl) {
        String string2 = null;
        while (n < arrayList.size()) {
            string2 = (String)arrayList.get(n);
            if (string2.equals("(")) {
                arrayList.remove(n);
                this.parse(arrayList, n, true);
                if (n + 1 < arrayList.size()) {
                    arrayList.remove(n + 1);
                }
            } else if (string2.equals(")")) {
                if (bl) {
                    return;
                }
                arrayList.remove(n);
                continue;
            }
            if (string2.equals(string)) {
                if (string2.equals("!")) {
                    arrayList.remove(n);
                    string2 = (String)arrayList.get(n);
                    if (!string2.equals("(")) {
                        if (string2.equals("T")) {
                            arrayList.set(n, "F");
                        } else {
                            arrayList.set(n, "T");
                        }
                    } else {
                        this.parse(arrayList, n + 1, true);
                        arrayList.remove(n);
                        string2 = (String)arrayList.get(n);
                        if (string2.equals("T")) {
                            arrayList.set(n, "F");
                        } else {
                            arrayList.set(n, "T");
                        }
                        if (n + 1 < arrayList.size()) {
                            arrayList.remove(n + 1);
                        }
                    }
                } else {
                    String string3 = (String)arrayList.get(n - 1);
                    String string4 = (String)arrayList.get(n + 1);
                    if (!string4.equals("(")) {
                        if (this.process(string3, string4, string2)) {
                            arrayList.set(n - 1, "T");
                        } else {
                            arrayList.set(n - 1, "F");
                        }
                        arrayList.remove(n);
                        arrayList.remove(n);
                        --n;
                    } else {
                        this.parse(arrayList, n + 2, true);
                        arrayList.remove(n + 1);
                        string4 = (String)arrayList.get(n + 1);
                        if (this.process(string3, string4, string2)) {
                            arrayList.set(n - 1, "T");
                        } else {
                            arrayList.set(n - 1, "F");
                        }
                        arrayList.remove(n);
                        arrayList.remove(n);
                        if (n < arrayList.size()) {
                            arrayList.remove(n);
                        }
                        --n;
                    }
                }
            }
            ++n;
        }
    }

    private boolean process(String string, String string2, String string3) {
        boolean bl = string.equals("T");
        boolean bl2 = string2.equals("T");
        char c = string3.charAt(0);
        switch (c) {
            case '^': {
                return bl && bl2;
            }
            case 'v': {
                return bl || bl2;
            }
            case 'x': {
                return bl != bl2;
            }
            case 'i': {
                return !bl || bl2;
            }
            case 'd': {
                return bl == bl2;
            }
        }
        throw new RuntimeException("unknown operator: " + c);
    }

    private String boolToStr(boolean bl) {
        return bl ? "T" : "F";
    }

    private void printTruths(boolean[] blArray) {
        for (int i = 0; i < blArray.length; ++i) {
            if (blArray[i]) {
                TruthTable.print("T ");
                continue;
            }
            TruthTable.print("F ");
        }
    }

    private void initVals(boolean[] blArray, int n) {
        int n2 = 1;
        for (int i = 1; i <= blArray.length; ++i) {
            blArray[blArray.length - i] = (n & n2) <= 0;
            n2 <<= 1;
        }
    }

    private class Var {
        public String letter;
        public boolean value;

        public Var(String string) {
            this.letter = string;
        }
    }
}

