/*
 * Decompiled with CFR 0.152.
 */
package userInterface;

import enumerators.SaveFileType;
import enumerators.SyntacticViewLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import syntaxTree.Properties;
import syntaxTree.SyntacticAssociation;
import syntaxTree.SyntacticFeature;
import syntaxTree.SyntacticStructure;
import syntaxTree.SyntaxFacade;
import syntaxTree.TraceComponent;
import userInterface.ListenerAssociationPane;
import userInterface.ListenerBezierPane;
import userInterface.ListenerGlassPane;
import userInterface.ListenerHighlightPane;
import userInterface.ListenerMovementPane;
import userInterface.ObservableClipboard;
import userInterface.ObservableFont;
import userInterface.ObservableFontBold;
import userInterface.ObservableFontItalic;
import userInterface.ObservableFontSize;
import userInterface.ObservableFontStrikethrough;
import userInterface.ObservableFontSubscript;
import userInterface.ObservableFontSuperscript;
import userInterface.ObservableFontUnderline;
import userInterface.UserAssociationPane;
import userInterface.UserBezierPane;
import userInterface.UserFrame;
import userInterface.UserGlassPane;
import userInterface.UserHighlightPane;
import userInterface.UserMovementPane;

public class UserInternalFrame
extends JInternalFrame {
    private static final long serialVersionUID = 1L;
    private int mMinWidth;
    private int mMinHeight;
    private SaveFileType mSaveFileType;
    private SyntaxFacade mSyntaxFacade;
    private SyntacticViewLayout mSyntacticViewLayout;
    private UserFrame mUserFrame;
    private float mScale;
    private TraceComponent mTrace;
    private Properties mProperties;

    public UserInternalFrame(UserFrame pUserFrame, int pCount) {
        super("Document #" + pCount, true, true, true, true);
        this.mUserFrame = pUserFrame;
        this.mProperties = new Properties();
        this.mSyntaxFacade = new SyntaxFacade(this);
        this.mSaveFileType = SaveFileType.XML;
        this.setSize(this.mUserFrame.getDesktopPane().getSize());
        this.mSyntacticViewLayout = SyntacticViewLayout.D_STRUCTURE;
        this.mTrace = new TraceComponent(this);
        this.getContentPane().setBackground(new Color(255, 255, 255));
        this.getContentPane().add(this.mTrace);
        this.setScale(1.0f);
        this.setMinHeight(this.getHeight());
        this.setMinWidth(this.getWidth());
    }

    public Map getAttributes() {
        return this.mUserFrame.getUserControl().getAttributes();
    }

    public SyntacticViewLayout getSyntacticViewLayout() {
        return this.mSyntacticViewLayout;
    }

    public void setSyntacticViewLayout(SyntacticViewLayout pSvl) {
        this.mSyntacticViewLayout = pSvl;
    }

    public SyntaxFacade getSyntaxFacade() {
        return this.mSyntaxFacade;
    }

    public SaveFileType getSaveFileType() {
        return this.mSaveFileType;
    }

    public void setSaveFileType(SaveFileType pSaveFileType) {
        this.mSaveFileType = pSaveFileType;
    }

    public void setScale(float pScale) {
        this.mScale = pScale;
    }

    public float getScale() {
        return this.mScale;
    }

    public ObservableClipboard getObservableClipboard() {
        return this.mUserFrame.getObservableClipboard();
    }

    public ObservableFont getObservableFont() {
        return this.mUserFrame.getObservableFont();
    }

    public ObservableFontSize getObservableFontSize() {
        return this.mUserFrame.getObservableFontSize();
    }

    public ObservableFontBold getObservableFontBold() {
        return this.mUserFrame.getObservableFontBold();
    }

    public ObservableFontItalic getObservableFontItalic() {
        return this.mUserFrame.getObservableFontItalic();
    }

    public ObservableFontUnderline getObservableFontUnderline() {
        return this.mUserFrame.getObservableFontUnderline();
    }

    public ObservableFontSubscript getObservableFontSubscript() {
        return this.mUserFrame.getObservableSubscript();
    }

    public ObservableFontStrikethrough getObservableFontStrikethrough() {
        return this.mUserFrame.getObservableFontStrikethrough();
    }

    public ObservableFontSuperscript getObservableFontSuperscript() {
        return this.mUserFrame.getObservableSuperscript();
    }

    public void activateGlassPane(SyntacticStructure pSS, SyntacticStructure pSSChild) {
        UserGlassPane lUGP = new UserGlassPane(this.mUserFrame, pSS, pSSChild);
        lUGP.setSyntacticStructure(pSS);
        ListenerGlassPane lListenerGlassPane = new ListenerGlassPane(this.mUserFrame);
        lUGP.addMouseListener(lListenerGlassPane);
        lUGP.addMouseMotionListener(lListenerGlassPane);
        this.setGlassPane(lUGP);
        this.getGlassPane().setVisible(true);
    }

    public void deactivateGlassPane() {
        this.setGlassPane(new JLabel());
        this.getGlassPane().setVisible(false);
    }

    public void activateBezierPane(SyntacticStructure pSS) {
        UserBezierPane lUBP = new UserBezierPane(this.mUserFrame, pSS);
        ListenerBezierPane listenerBezierPane = new ListenerBezierPane(this.mUserFrame);
        lUBP.addMouseListener(listenerBezierPane);
        lUBP.addMouseMotionListener(listenerBezierPane);
        this.setGlassPane(lUBP);
        this.getGlassPane().setVisible(true);
    }

    public void deactivateBezierPane() {
        this.setGlassPane(new JLabel());
        this.getGlassPane().setVisible(false);
    }

    public void activateHighlightPane() {
        UserHighlightPane lUHP = new UserHighlightPane(this.mUserFrame);
        ListenerHighlightPane listenerHighlightPane = new ListenerHighlightPane(this.mUserFrame);
        lUHP.addMouseListener(listenerHighlightPane);
        lUHP.addMouseMotionListener(listenerHighlightPane);
        this.setGlassPane(lUHP);
        this.getGlassPane().setVisible(true);
    }

    public void deactivateHighlightPane() {
        this.setGlassPane(new JLabel());
        this.getGlassPane().setVisible(false);
    }

    public void activateMovementPane(Component component, MouseEvent pme) {
        if (component instanceof SyntacticAssociation) {
            component = ((SyntacticAssociation)component).getSyntacticStructure();
        }
        if (component instanceof SyntacticFeature) {
            component = ((SyntacticFeature)component).getSyntacticFeatureSet().getSyntacticStructure();
        }
        if (component instanceof SyntacticStructure) {
            UserMovementPane lUMP = new UserMovementPane(this.mUserFrame, (SyntacticStructure)component);
            ListenerMovementPane listenerMovementPane = new ListenerMovementPane(this.mUserFrame);
            lUMP.addMouseListener(listenerMovementPane);
            lUMP.addMouseMotionListener(listenerMovementPane);
            this.setGlassPane(lUMP);
            this.getGlassPane().setVisible(true);
        }
    }

    public void deactivateMovementPane() {
        this.setGlassPane(new JLabel());
        this.getGlassPane().setVisible(false);
    }

    public void activateAssociationPane(SyntacticFeature feature) {
        UserAssociationPane lUAP = new UserAssociationPane(this.mUserFrame, feature);
        ListenerAssociationPane listenerAssociationPane = new ListenerAssociationPane(this.mUserFrame);
        lUAP.addMouseListener(listenerAssociationPane);
        lUAP.addMouseMotionListener(listenerAssociationPane);
        this.setGlassPane(lUAP);
        this.getGlassPane().setVisible(true);
    }

    public void deactivateAssociationPane() {
        this.setGlassPane(new JLabel());
        this.getGlassPane().setVisible(false);
    }

    public UserFrame getUserFrame() {
        return this.mUserFrame;
    }

    public void setMinWidth(int mMinWidth) {
        this.mMinWidth = mMinWidth;
    }

    public int getMinWidth() {
        return this.mMinWidth;
    }

    public void setMinHeight(int mMinHeight) {
        this.mMinHeight = mMinHeight;
    }

    public int getMinHeight() {
        return this.mMinHeight;
    }

    public TraceComponent getTrace() {
        return this.mTrace;
    }

    public Properties getProperties() {
        return this.mProperties;
    }

    public UserHighlightPane getHighlightPane() {
        if (this.getGlassPane() instanceof UserHighlightPane) {
            return (UserHighlightPane)this.getGlassPane();
        }
        return null;
    }
}

