/*
 * Decompiled with CFR 0.152.
 */
package userInterface;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import staticFunctions.Sizer;
import syntaxTree.SyntaxFacade;
import userInterface.ObservableBackgroundColor;
import userInterface.ObservableClipboard;
import userInterface.ObservableFont;
import userInterface.ObservableFontBold;
import userInterface.ObservableFontColor;
import userInterface.ObservableFontItalic;
import userInterface.ObservableFontSize;
import userInterface.ObservableFontStrikethrough;
import userInterface.ObservableFontSubscript;
import userInterface.ObservableFontSuperscript;
import userInterface.ObservableFontUnderline;
import userInterface.ObservableLineColor;
import userInterface.ObservableNew;
import userInterface.ObservableStack;
import userInterface.ObservableZoom;
import userInterface.UserControl;
import userInterface.UserDesktopPane;
import userInterface.UserInternalFrame;
import userInterface.UserMenuBar;
import userInterface.UserObjectBrowser;
import userInterface.UserToolBar;

public class UserFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private ObservableFontSuperscript mObservableSuperscript;
    private ObservableFontSubscript mObservableSubscript;
    private ObservableFontUnderline mObservableUnderline;
    private ObservableFontItalic mObservableItalic;
    private ObservableFontBold mObservableBold;
    private ObservableFontSize mObservableSize;
    private ObservableFont mObservableFont;
    private ObservableClipboard mClipboard;
    private ObservableZoom mZoom;
    private ObservableStack mObservableStack;
    private ObservableNew mObservableNew;
    private ResourceBundle mI18n;
    private Locale mCurrentLocale;
    private Locale[] mSupportedLocales = new Locale[]{Locale.CANADA, Locale.CANADA_FRENCH};
    private UserDesktopPane mDesktopPane;
    private JSplitPane mSplitPane;
    private JPanel mPanelCenter;
    private BoxLayout mBoxLayout;
    private JPanel mPanelNorth;
    private UserToolBar mToolBarFile;
    private UserToolBar mToolBarFonts;
    private JMenuBar mMenuBar;
    private JPanel mObjectBrowser;
    private UserControl mUserControl;
    private ObservableFontStrikethrough mObservableStrikethrough;
    private ObservableFontColor mObservableFontColor;
    private ObservableBackgroundColor mObservableBackgroundColor;
    private ObservableLineColor mObservableLineColor;

    public UserFrame() {
        this.setVisible(false);
        this.setDefaultCloseOperation(0);
        this.setObservableZoom(new ObservableZoom(1.0f));
        this.mCurrentLocale = this.mSupportedLocales[0];
        this.seti18n(this.mCurrentLocale);
        this.setDefaults();
        this.setObservableNew(new ObservableNew(0));
        this.setObservableStack(new ObservableStack(null));
        this.setObservableClipboard(new ObservableClipboard(null));
        this.setObservableFont(new ObservableFont("Doulos SIL"));
        this.setObservableFontSize(new ObservableFontSize(10));
        this.setObservableFontBold(new ObservableFontBold(false));
        this.setObservableFontItalic(new ObservableFontItalic(false));
        this.setObservableFontUnderline(new ObservableFontUnderline(false));
        this.setObservableFontStrikethrough(new ObservableFontStrikethrough(false));
        this.setObservableSubscript(new ObservableFontSubscript(false));
        this.setObservableSuperscript(new ObservableFontSuperscript(false));
        this.setObservableFontColor(new ObservableFontColor(new Color(0, 0, 0)));
        this.setObservableBackgroundColor(new ObservableBackgroundColor(new Color(255, 255, 255)));
        this.setObservableLineColor(new ObservableLineColor(new Color(0, 0, 0)));
        this.mToolBarFile = new UserToolBar(this, 15);
        this.mToolBarFonts = new UserToolBar(this, 16);
        this.mObjectBrowser = new UserObjectBrowser(this);
        this.mDesktopPane = new UserDesktopPane(this);
        this.mUserControl = new UserControl(this);
        this.mPanelNorth = new JPanel();
        this.mPanelCenter = new JPanel();
        this.mPanelCenter.validate();
        this.mMenuBar = new UserMenuBar(this);
        this.setLayout();
        this.pack();
        this.resize();
        this.setVisible(true);
        this.getUserControl().createNewTree();
        this.getObservableNew().setValue(this.getDesktopPane().getAllFrames().length + 1);
    }

    private void setObservableBackgroundColor(ObservableBackgroundColor color) {
        this.mObservableBackgroundColor = color;
    }

    private void setObservableFontColor(ObservableFontColor color) {
        this.mObservableFontColor = color;
    }

    private void setObservableFontUnderline(ObservableFontUnderline pUnderline) {
        this.mObservableUnderline = pUnderline;
    }

    protected ObservableFontUnderline getObservableFontUnderline() {
        return this.mObservableUnderline;
    }

    private void setObservableFontItalic(ObservableFontItalic pItalic) {
        this.mObservableItalic = pItalic;
    }

    private void setObservableFontStrikethrough(ObservableFontStrikethrough pStrikethrough) {
        this.mObservableStrikethrough = pStrikethrough;
    }

    protected ObservableFontItalic getObservableFontItalic() {
        return this.mObservableItalic;
    }

    private void setObservableFontBold(ObservableFontBold pBold) {
        this.mObservableBold = pBold;
    }

    protected ObservableFontBold getObservableFontBold() {
        return this.mObservableBold;
    }

    private void setObservableFontSize(ObservableFontSize pSize) {
        this.mObservableSize = pSize;
    }

    protected ObservableFontSize getObservableFontSize() {
        return this.mObservableSize;
    }

    private void setObservableClipboard(ObservableClipboard pObservableClipboard) {
        this.mClipboard = pObservableClipboard;
    }

    private void setObservableZoom(ObservableZoom zoom) {
        this.mZoom = zoom;
    }

    protected ObservableZoom getObservableZoom() {
        return this.mZoom;
    }

    public ObservableClipboard getObservableClipboard() {
        return this.mClipboard;
    }

    protected void seti18n(Locale pCurrentLocale) {
        this.mI18n = ResourceBundle.getBundle("TreeFormBundle", pCurrentLocale);
    }

    public ResourceBundle getI18n() {
        return this.mI18n;
    }

    private void setDefaults() {
        this.addWindowListener(new WindowAdapter(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void windowClosing(WindowEvent e) {
                if (UserFrame.this.getObservableNew().getValue() != 0) {
                    int I = JOptionPane.showConfirmDialog(null, "Clicking NO will exit the program without saving any trees.", "Save trees first?", 1);
                    if (I == 0) {
                        UserFrame.this.getUserControl().saveAllTrees(UserFrame.this.getDesktopPane());
                        return;
                    } else {
                        if (I != 1) return;
                        System.exit(0);
                    }
                    return;
                } else {
                    System.exit(0);
                }
            }
        });
        this.setTitle("TreeForm");
        ImageIcon treeFormIcon = (ImageIcon)this.mI18n.getObject("TREEFORM_ICON_SMALL");
        this.setIconImage(treeFormIcon.getImage());
    }

    protected UserControl getUserControl() {
        return this.mUserControl;
    }

    private void resize() {
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize((int)dim.getWidth(), (int)dim.getHeight() - 30);
    }

    private void setLayout() {
        this.setJMenuBar(this.mMenuBar);
        this.mBoxLayout = new BoxLayout(this.mPanelNorth, 3);
        this.mPanelNorth.setLayout(this.mBoxLayout);
        this.mPanelNorth.add(this.mToolBarFile);
        this.mPanelNorth.add(this.mToolBarFonts);
        JScrollPane jsp = new JScrollPane(this.mDesktopPane);
        this.mSplitPane = new JSplitPane(1, this.mObjectBrowser, jsp);
        this.mSplitPane.setDividerLocation(Sizer.scaledButtonSize().width * 2 + 14);
        this.getContentPane().add((Component)this.mPanelNorth, "North");
        this.getContentPane().add((Component)this.mSplitPane, "Center");
    }

    public UserDesktopPane getDesktopPane() {
        return this.mDesktopPane;
    }

    public UserInternalFrame getInternalFrame() {
        return this.getDesktopPane().getInternalFrame();
    }

    public SyntaxFacade getSyntaxFacade() {
        return this.getDesktopPane().getInternalFrame().getSyntaxFacade();
    }

    protected JPanel getObjectBrowser() {
        return this.mObjectBrowser;
    }

    protected UserToolBar getToolBarFile() {
        return this.mToolBarFile;
    }

    protected UserToolBar getToolBarFonts() {
        return this.mToolBarFonts;
    }

    private void setObservableNew(ObservableNew pObservableNew) {
        this.mObservableNew = pObservableNew;
    }

    protected ObservableNew getObservableNew() {
        return this.mObservableNew;
    }

    protected ObservableStack getObservableStack() {
        return this.mObservableStack;
    }

    private void setObservableStack(ObservableStack pObservableStack) {
        this.mObservableStack = pObservableStack;
    }

    private void setObservableFont(ObservableFont pObservableFont) {
        this.mObservableFont = pObservableFont;
    }

    protected ObservableFont getObservableFont() {
        return this.mObservableFont;
    }

    protected void setObservableSuperscript(ObservableFontSuperscript mObservableSuperscript) {
        this.mObservableSuperscript = mObservableSuperscript;
    }

    protected ObservableFontSuperscript getObservableSuperscript() {
        return this.mObservableSuperscript;
    }

    protected void setObservableSubscript(ObservableFontSubscript mObservableSubscript) {
        this.mObservableSubscript = mObservableSubscript;
    }

    protected ObservableFontSubscript getObservableSubscript() {
        return this.mObservableSubscript;
    }

    protected ObservableFontStrikethrough getObservableFontStrikethrough() {
        return this.mObservableStrikethrough;
    }

    public ObservableFontColor getObservableFontColor() {
        return this.mObservableFontColor;
    }

    public ObservableBackgroundColor getObservableBackgroundColor() {
        return this.mObservableBackgroundColor;
    }

    public ObservableLineColor getObservableLineColor() {
        return this.mObservableLineColor;
    }

    public void setObservableLineColor(ObservableLineColor color) {
        this.mObservableLineColor = color;
    }

    public Font changeFont() {
        AffineTransform lAT;
        int lStyle = 0;
        if (this.getObservableFontBold().getValue()) {
            ++lStyle;
        }
        if (this.getObservableFontItalic().getValue()) {
            lStyle += 2;
        }
        Font lFont = new Font(this.getObservableFont().getValue(), lStyle, this.getObservableFontSize().getValue());
        if (this.getObservableSubscript().getValue()) {
            lAT = new AffineTransform();
            lAT.translate(0.0, 1.0);
            lAT.scale(0.6666666666666666, 0.6666666666666666);
            lFont = lFont.deriveFont(lAT);
        }
        if (this.getObservableSuperscript().getValue()) {
            lAT = new AffineTransform();
            lAT.translate(0.0, -3.0);
            lAT.scale(0.6666666666666666, 0.6666666666666666);
            lFont = lFont.deriveFont(lAT);
        }
        return lFont;
    }
}

