/*
 * Decompiled with CFR 0.152.
 */
package userInterface;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import staticFunctions.Sizer;
import userInterface.ObservableLineColor;
import userInterface.ObservableNew;
import userInterface.UserFrame;

public class UserButtonLineColor
extends JButton
implements Observer {
    private static final long serialVersionUID = 1L;
    private ObservableNew mObservableNew;
    private Color mColor;
    private boolean mIconSize;
    private UserFrame mUserFrame;

    public UserButtonLineColor(UserFrame userFrame, boolean iconSize, ObservableLineColor observableFontColor, ObservableNew observableNew) {
        this.mUserFrame = userFrame;
        this.mObservableNew = observableNew;
        this.mColor = Color.black;
        this.mIconSize = iconSize;
        if (iconSize) {
            this.setPreferredSize(new Dimension(32, 32));
        } else {
            this.setPreferredSize(new Dimension(24, 24));
        }
    }

    public void update(Observable arg0, Object arg1) {
        if (arg0 == this.mObservableNew) {
            if (this.mObservableNew.getValue() == 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    public void setColor(Color foreground) {
        this.mColor = foreground;
        this.mUserFrame.getSyntaxFacade().setLineColor(this.mColor);
        this.repaint();
    }

    public Color getColor() {
        return this.mColor;
    }

    public void paintComponent(Graphics pG) {
        super.paintComponent(pG);
        Graphics2D mGraphics2D = (Graphics2D)pG;
        mGraphics2D.setColor(Color.BLACK);
        mGraphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        mGraphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        if (this.mIconSize) {
            mGraphics2D.scale(1.3333333730697632, 1.3333333730697632);
        }
        mGraphics2D.setStroke(new BasicStroke(0.5f));
        Arc2D.Double arc2D = new Arc2D.Double(3.0, 3.0, 7.0, 7.0, 0.0, 360.0, 2);
        mGraphics2D.setColor(Color.BLUE);
        mGraphics2D.fill(arc2D);
        mGraphics2D.setColor(Sizer.BROWN1);
        mGraphics2D.draw(arc2D);
        arc2D = new Arc2D.Double(3.0, 3.0, 7.0, 7.0, 0.0, 240.0, 2);
        mGraphics2D.setColor(Color.GREEN);
        mGraphics2D.fill(arc2D);
        mGraphics2D.setColor(Sizer.BROWN1);
        mGraphics2D.draw(arc2D);
        arc2D = new Arc2D.Double(3.0, 3.0, 7.0, 7.0, 0.0, 120.0, 2);
        mGraphics2D.setColor(Color.RED);
        mGraphics2D.fill(arc2D);
        mGraphics2D.setColor(Sizer.BROWN1);
        mGraphics2D.draw(arc2D);
        mGraphics2D.setColor(this.mColor);
        mGraphics2D.setStroke(new BasicStroke(1.5f));
        mGraphics2D.drawLine(12, 10, 20, 20);
        mGraphics2D.drawLine(12, 10, 8, 14);
        mGraphics2D.drawLine(16, 16, 12, 20);
    }

    public void setHighlight() {
        this.mUserFrame.getInternalFrame().getSyntaxFacade().setLineColor(this.mColor);
    }
}

