/*
 * Decompiled with CFR 0.152.
 */
package userInterface;

import java.awt.Color;
import java.awt.Toolkit;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import userInterface.ListenerCloseProperties;
import userInterface.ListenerDefaultFontSize;
import userInterface.ListenerFrameBackgroundColor;
import userInterface.ListenerFrameFontColor;
import userInterface.ListenerFrameLineColor;
import userInterface.ListenerLeftPad;
import userInterface.ListenerLineLength;
import userInterface.ListenerLineWidth;
import userInterface.ListenerRestoreDefaults;
import userInterface.ListenerTopPad;
import userInterface.UserColorChooser;
import userInterface.UserInternalFrame;

public class PropertiesFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JSlider lineLength;
    private JSlider lineWidth;
    private JSlider leftPad;
    private JSlider topPad;
    private JButton close;
    private JLabel lineLengthLabel;
    private JLabel lineWidthLabel;
    private JLabel leftPadLabel;
    private JLabel topPadLabel;
    private UserInternalFrame mFrame;
    private JSlider defaultFontSize;
    private JLabel defaultFontSizeLabel;
    private JButton restoreDefaults;
    private JColorChooser textColor;
    private JTabbedPane tabbedPane;
    private JPanel textColorPanel;
    private JPanel highlightColorPanel;
    private UserColorChooser highlightColor;
    private JPanel lineColorPanel;
    private UserColorChooser lineColor;

    public PropertiesFrame(UserInternalFrame frame) {
        this.mFrame = frame;
        this.lineLengthLabel = new JLabel((String)this.mFrame.getUserFrame().getI18n().getObject("LINE_HEIGHT_LABEL"));
        this.lineLength = new JSlider();
        this.lineLength.setMajorTickSpacing(5);
        this.lineLength.setMinorTickSpacing(1);
        this.lineLength.setMaximum(100);
        this.lineLength.setPaintTicks(true);
        this.lineLength.setPaintLabels(true);
        this.lineLength.setValue(frame.getProperties().getMinLineLength());
        this.lineLength.addChangeListener(new ListenerLineLength(frame.getProperties(), frame.getUserFrame().getInternalFrame().getSyntaxFacade()));
        this.lineWidthLabel = new JLabel((String)this.mFrame.getUserFrame().getI18n().getObject("LINE_WIDTH_LABEL"));
        this.lineWidth = new JSlider();
        this.lineWidth.setMajorTickSpacing(5);
        this.lineWidth.setMinorTickSpacing(1);
        this.lineWidth.setMaximum(100);
        this.lineWidth.setPaintTicks(true);
        this.lineWidth.setPaintLabels(true);
        this.lineWidth.setValue(frame.getProperties().getMinLineWidth());
        this.lineWidth.addChangeListener(new ListenerLineWidth(frame.getProperties(), frame.getUserFrame().getInternalFrame().getSyntaxFacade()));
        this.leftPadLabel = new JLabel((String)this.mFrame.getUserFrame().getI18n().getObject("LEFT_PAD_LABEL"));
        this.leftPad = new JSlider();
        this.leftPad.setMajorTickSpacing(20);
        this.leftPad.setMaximum(200);
        this.leftPad.setPaintTicks(true);
        this.leftPad.setPaintLabels(true);
        this.leftPad.setValue(frame.getProperties().getLeftTranslate());
        this.leftPad.addChangeListener(new ListenerLeftPad(frame.getProperties(), frame.getUserFrame().getInternalFrame().getSyntaxFacade()));
        this.topPadLabel = new JLabel((String)this.mFrame.getUserFrame().getI18n().getObject("TOP_PAD_LABEL"));
        this.topPad = new JSlider();
        this.topPad.setMajorTickSpacing(20);
        this.topPad.setMaximum(200);
        this.topPad.setPaintTicks(true);
        this.topPad.setPaintLabels(true);
        this.topPad.setValue(frame.getProperties().getTopTranslate());
        this.topPad.addChangeListener(new ListenerTopPad(frame.getProperties(), frame.getUserFrame().getInternalFrame().getSyntaxFacade()));
        this.defaultFontSizeLabel = new JLabel((String)this.mFrame.getUserFrame().getI18n().getObject("FONT_SIZE_LABEL"));
        this.defaultFontSize = new JSlider();
        this.defaultFontSize.setMajorTickSpacing(1);
        this.defaultFontSize.setMinorTickSpacing(1);
        this.defaultFontSize.setMinimum(4);
        this.defaultFontSize.setMaximum(30);
        this.defaultFontSize.setPaintTicks(true);
        this.defaultFontSize.setPaintLabels(true);
        this.defaultFontSize.setValue(frame.getProperties().getDefaultFontSize());
        this.defaultFontSize.addChangeListener(new ListenerDefaultFontSize(frame.getProperties(), frame.getUserFrame().getInternalFrame().getSyntaxFacade()));
        this.tabbedPane = new JTabbedPane();
        this.textColorPanel = new JPanel();
        this.textColor = new UserColorChooser(frame.getProperties());
        this.textColor.setColor(frame.getProperties().getFontColor());
        this.textColor.getSelectionModel().addChangeListener(new ListenerFrameFontColor(frame.getProperties(), frame.getUserFrame()));
        this.textColorPanel.add(this.textColor);
        this.highlightColorPanel = new JPanel();
        this.highlightColor = new UserColorChooser(frame.getProperties());
        this.highlightColor.setColor(frame.getProperties().getBackgroundColor());
        this.highlightColor.getSelectionModel().addChangeListener(new ListenerFrameBackgroundColor(frame.getProperties(), frame.getUserFrame()));
        this.highlightColorPanel.add(this.highlightColor);
        this.lineColorPanel = new JPanel();
        this.lineColor = new UserColorChooser(frame.getProperties());
        this.lineColor.setColor(frame.getProperties().getLineColor());
        this.lineColor.getSelectionModel().addChangeListener(new ListenerFrameLineColor(frame.getProperties(), frame.getUserFrame()));
        this.lineColorPanel.add(this.lineColor);
        this.tabbedPane.addTab("Text Color", this.textColorPanel);
        this.tabbedPane.addTab("Text Highlight", this.highlightColorPanel);
        this.tabbedPane.addTab("Line Color", this.lineColorPanel);
        this.close = new JButton((String)this.mFrame.getUserFrame().getI18n().getObject("CLOSE_PROPERTIES_LABEL"));
        this.close.addActionListener(new ListenerCloseProperties(this));
        this.restoreDefaults = new JButton((String)this.mFrame.getUserFrame().getI18n().getObject("RESTORE_PROPERTIES_LABEL"));
        this.restoreDefaults.addActionListener(new ListenerRestoreDefaults(frame.getProperties(), frame.getUserFrame().getInternalFrame().getSyntaxFacade(), this));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        this.getContentPane().add(this.lineLengthLabel);
        this.getContentPane().add(this.lineLength);
        this.getContentPane().add(this.lineWidthLabel);
        this.getContentPane().add(this.lineWidth);
        this.getContentPane().add(this.leftPadLabel);
        this.getContentPane().add(this.leftPad);
        this.getContentPane().add(this.topPadLabel);
        this.getContentPane().add(this.topPad);
        this.getContentPane().add(this.defaultFontSizeLabel);
        this.getContentPane().add(this.defaultFontSize);
        this.getContentPane().add(this.tabbedPane);
        this.getContentPane().add(this.restoreDefaults);
        this.getContentPane().add(this.close);
        this.setBounds((int)((double)Toolkit.getDefaultToolkit().getScreenSize().width * 0.45), (int)((double)Toolkit.getDefaultToolkit().getScreenSize().height * 0.0), (int)((double)Toolkit.getDefaultToolkit().getScreenSize().width * 0.5), (int)((double)Toolkit.getDefaultToolkit().getScreenSize().height * 0.95));
        this.setVisible(true);
    }

    public UserInternalFrame getUIF() {
        return this.mFrame;
    }

    public void setMinTextWidth(int i) {
        this.lineWidth.setValue(i);
    }

    public void setLineLength(int i) {
        this.lineLength.setValue(i);
    }

    public void setLeftTranslate(int leftTranslate) {
        this.leftPad.setValue(leftTranslate);
    }

    public void setTopTranslate(int topTranslate) {
        this.topPad.setValue(topTranslate);
    }

    public void setFontSize(int i) {
        this.defaultFontSize.setValue(i);
    }

    public void setFontColor(Color fontColor) {
        this.textColor.setColor(fontColor);
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.highlightColor.setColor(backgroundColor);
    }

    public void setLineColor(Color lineColor2) {
        this.lineColor.setColor(lineColor2);
    }
}

