package org.sunflow.core.shader;

import org.sunflow.SunflowAPI;
import org.sunflow.core.ParameterList;
import org.sunflow.core.Ray;
import org.sunflow.core.ShadingState;
import org.sunflow.core.Texture;
import org.sunflow.image.Color;
import org.sunflow.math.Vector3;

public class TexturedPhongShader extends PhongShader {
    private Texture tex;

    public TexturedPhongShader() {
        tex = null;
    }

    @Override
    public boolean update(ParameterList pl, SunflowAPI api) {
        String filename = pl.getString("texture", null);
        if (filename != null)
            // EP : Made texture cache local to a SunFlow API instance
            tex = api.getTextureCache().getTexture(api.resolveTextureFilename(filename), false);
        return tex != null && super.update(pl, api);
    }

    @Override
    public Color getDiffuse(ShadingState state) {
        return tex.getPixel(state.getUV().x, state.getUV().y);
    }

    // EP : Added transparency management  
    @Override
    public Color getRadiance(ShadingState state) {
        Color opacity;
        if (isOpaque() || (opacity = getOpacity(state)).isWhite()) {
            return super.getRadiance(state);
        } else {
            state.faceforward();
            state.initLightSamples();
            state.initCausticSamples();
            Vector3 refrDir = state.getRay().getDirection();
            Color refraction = state.traceRefraction(new Ray(state.getPoint(), refrDir), 0);
            return Color.sub(Color.WHITE, opacity).mul(refraction);
        }
    }
    
    @Override
    public boolean isOpaque() {
        return !(tex.isTransparent());
    }
    
    @Override
    public Color getOpacity(ShadingState state) {
        return tex.getOpacity(state.getUV().x, state.getUV().y);
    }
    // EP : End of modification
}