/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.geom.plane;

import com.jogamp.graph.geom.Vertex;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import jogamp.graph.geom.plane.NoninvertibleTransformException;
import jogamp.graph.geom.plane.Path2D;
import jogamp.graph.geom.plane.PathIterator;
import jogamp.graph.math.MathFloat;

public class AffineTransform
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1330973210523860834L;
    static final String determinantIsZero = "Determinant is zero";
    public static final int TYPE_IDENTITY = 0;
    public static final int TYPE_TRANSLATION = 1;
    public static final int TYPE_UNIFORM_SCALE = 2;
    public static final int TYPE_GENERAL_SCALE = 4;
    public static final int TYPE_QUADRANT_ROTATION = 8;
    public static final int TYPE_GENERAL_ROTATION = 16;
    public static final int TYPE_GENERAL_TRANSFORM = 32;
    public static final int TYPE_FLIP = 64;
    public static final int TYPE_MASK_SCALE = 6;
    public static final int TYPE_MASK_ROTATION = 24;
    static final int TYPE_UNKNOWN = -1;
    static final float ZERO = 1.0E-10f;
    private final Vertex.Factory<? extends Vertex> pointFactory;
    float m00;
    float m10;
    float m01;
    float m11;
    float m02;
    float m12;
    transient int type;

    public AffineTransform() {
        this.pointFactory = null;
        this.type = 0;
        this.m11 = 1.0f;
        this.m00 = 1.0f;
        this.m12 = 0.0f;
        this.m02 = 0.0f;
        this.m01 = 0.0f;
        this.m10 = 0.0f;
    }

    public AffineTransform(Vertex.Factory<? extends Vertex> factory) {
        this.pointFactory = factory;
        this.type = 0;
        this.m11 = 1.0f;
        this.m00 = 1.0f;
        this.m12 = 0.0f;
        this.m02 = 0.0f;
        this.m01 = 0.0f;
        this.m10 = 0.0f;
    }

    public AffineTransform(AffineTransform affineTransform) {
        this.pointFactory = affineTransform.pointFactory;
        this.type = affineTransform.type;
        this.m00 = affineTransform.m00;
        this.m10 = affineTransform.m10;
        this.m01 = affineTransform.m01;
        this.m11 = affineTransform.m11;
        this.m02 = affineTransform.m02;
        this.m12 = affineTransform.m12;
    }

    public AffineTransform(Vertex.Factory<? extends Vertex> factory, float f, float f2, float f3, float f4, float f5, float f6) {
        this.pointFactory = factory;
        this.type = -1;
        this.m00 = f;
        this.m10 = f2;
        this.m01 = f3;
        this.m11 = f4;
        this.m02 = f5;
        this.m12 = f6;
    }

    public AffineTransform(Vertex.Factory<? extends Vertex> factory, float[] fArray) {
        this.pointFactory = factory;
        this.type = -1;
        this.m00 = fArray[0];
        this.m10 = fArray[1];
        this.m01 = fArray[2];
        this.m11 = fArray[3];
        if (fArray.length > 4) {
            this.m02 = fArray[4];
            this.m12 = fArray[5];
        }
    }

    public int getType() {
        float f;
        float f2;
        if (this.type != -1) {
            return this.type;
        }
        int n = 0;
        if ((double)(this.m00 * this.m01 + this.m10 * this.m11) != 0.0) {
            return n |= 0x20;
        }
        if ((double)this.m02 != 0.0 || (double)this.m12 != 0.0) {
            n |= 1;
        } else if ((double)this.m00 == 1.0 && (double)this.m11 == 1.0 && (double)this.m01 == 0.0 && (double)this.m10 == 0.0) {
            n = 0;
            return n;
        }
        if ((double)(this.m00 * this.m11 - this.m01 * this.m10) < 0.0) {
            n |= 0x40;
        }
        if ((f2 = this.m00 * this.m00 + this.m10 * this.m10) != (f = this.m01 * this.m01 + this.m11 * this.m11)) {
            n |= 4;
        } else if ((double)f2 != 1.0) {
            n |= 2;
        }
        if ((double)this.m00 == 0.0 && (double)this.m11 == 0.0 || (double)this.m10 == 0.0 && (double)this.m01 == 0.0 && ((double)this.m00 < 0.0 || (double)this.m11 < 0.0)) {
            n |= 8;
        } else if ((double)this.m01 != 0.0 || (double)this.m10 != 0.0) {
            n |= 0x10;
        }
        return n;
    }

    public float getScaleX() {
        return this.m00;
    }

    public float getScaleY() {
        return this.m11;
    }

    public float getShearX() {
        return this.m01;
    }

    public float getShearY() {
        return this.m10;
    }

    public float getTranslateX() {
        return this.m02;
    }

    public float getTranslateY() {
        return this.m12;
    }

    public boolean isIdentity() {
        return this.getType() == 0;
    }

    public void getMatrix(float[] fArray) {
        fArray[0] = this.m00;
        fArray[1] = this.m10;
        fArray[2] = this.m01;
        fArray[3] = this.m11;
        if (fArray.length > 4) {
            fArray[4] = this.m02;
            fArray[5] = this.m12;
        }
    }

    public float getDeterminant() {
        return this.m00 * this.m11 - this.m01 * this.m10;
    }

    public void setTransform(float f, float f2, float f3, float f4, float f5, float f6) {
        this.type = -1;
        this.m00 = f;
        this.m10 = f2;
        this.m01 = f3;
        this.m11 = f4;
        this.m02 = f5;
        this.m12 = f6;
    }

    public void setTransform(AffineTransform affineTransform) {
        this.type = affineTransform.type;
        this.setTransform(affineTransform.m00, affineTransform.m10, affineTransform.m01, affineTransform.m11, affineTransform.m02, affineTransform.m12);
    }

    public void setToIdentity() {
        this.type = 0;
        this.m11 = 1.0f;
        this.m00 = 1.0f;
        this.m12 = 0.0f;
        this.m02 = 0.0f;
        this.m01 = 0.0f;
        this.m10 = 0.0f;
    }

    public void setToTranslation(float f, float f2) {
        this.m11 = 1.0f;
        this.m00 = 1.0f;
        this.m10 = 0.0f;
        this.m01 = 0.0f;
        this.m02 = f;
        this.m12 = f2;
        this.type = f == 0.0f && f2 == 0.0f ? 0 : 1;
    }

    public void setToScale(float f, float f2) {
        this.m00 = f;
        this.m11 = f2;
        this.m12 = 0.0f;
        this.m02 = 0.0f;
        this.m01 = 0.0f;
        this.m10 = 0.0f;
        this.type = f != 1.0f || f2 != 1.0f ? -1 : 0;
    }

    public void setToShear(float f, float f2) {
        this.m11 = 1.0f;
        this.m00 = 1.0f;
        this.m12 = 0.0f;
        this.m02 = 0.0f;
        this.m01 = f;
        this.m10 = f2;
        this.type = f != 0.0f || f2 != 0.0f ? -1 : 0;
    }

    public void setToRotation(float f) {
        float f2 = MathFloat.sin(f);
        float f3 = MathFloat.cos(f);
        if (MathFloat.abs(f3) < 1.0E-10f) {
            f3 = 0.0f;
            f2 = f2 > 0.0f ? 1.0f : -1.0f;
        } else if (MathFloat.abs(f2) < 1.0E-10f) {
            f2 = 0.0f;
            f3 = f3 > 0.0f ? 1.0f : -1.0f;
        }
        this.m00 = this.m11 = f3;
        this.m01 = -f2;
        this.m10 = f2;
        this.m12 = 0.0f;
        this.m02 = 0.0f;
        this.type = -1;
    }

    public void setToRotation(float f, float f2, float f3) {
        this.setToRotation(f);
        this.m02 = f2 * (1.0f - this.m00) + f3 * this.m10;
        this.m12 = f3 * (1.0f - this.m00) - f2 * this.m10;
        this.type = -1;
    }

    public static <T extends Vertex> AffineTransform getTranslateInstance(Vertex.Factory<? extends Vertex> factory, float f, float f2) {
        AffineTransform affineTransform = new AffineTransform(factory);
        affineTransform.setToTranslation(f, f2);
        return affineTransform;
    }

    public static <T extends Vertex> AffineTransform getScaleInstance(Vertex.Factory<? extends Vertex> factory, float f, float f2) {
        AffineTransform affineTransform = new AffineTransform(factory);
        affineTransform.setToScale(f, f2);
        return affineTransform;
    }

    public static <T extends Vertex> AffineTransform getShearInstance(Vertex.Factory<? extends Vertex> factory, float f, float f2) {
        AffineTransform affineTransform = new AffineTransform(factory);
        affineTransform.setToShear(f, f2);
        return affineTransform;
    }

    public static <T extends Vertex> AffineTransform getRotateInstance(Vertex.Factory<? extends Vertex> factory, float f) {
        AffineTransform affineTransform = new AffineTransform(factory);
        affineTransform.setToRotation(f);
        return affineTransform;
    }

    public static <T extends Vertex> AffineTransform getRotateInstance(Vertex.Factory<? extends Vertex> factory, float f, float f2, float f3) {
        AffineTransform affineTransform = new AffineTransform(factory);
        affineTransform.setToRotation(f, f2, f3);
        return affineTransform;
    }

    public void translate(float f, float f2) {
        this.concatenate(AffineTransform.getTranslateInstance(this.pointFactory, f, f2));
    }

    public void scale(float f, float f2) {
        this.concatenate(AffineTransform.getScaleInstance(this.pointFactory, f, f2));
    }

    public void shear(float f, float f2) {
        this.concatenate(AffineTransform.getShearInstance(this.pointFactory, f, f2));
    }

    public void rotate(float f) {
        this.concatenate(AffineTransform.getRotateInstance(this.pointFactory, f));
    }

    public void rotate(float f, float f2, float f3) {
        this.concatenate(AffineTransform.getRotateInstance(this.pointFactory, f, f2, f3));
    }

    AffineTransform multiply(AffineTransform affineTransform, AffineTransform affineTransform2) {
        return new AffineTransform(affineTransform.pointFactory, affineTransform.m00 * affineTransform2.m00 + affineTransform.m10 * affineTransform2.m01, affineTransform.m00 * affineTransform2.m10 + affineTransform.m10 * affineTransform2.m11, affineTransform.m01 * affineTransform2.m00 + affineTransform.m11 * affineTransform2.m01, affineTransform.m01 * affineTransform2.m10 + affineTransform.m11 * affineTransform2.m11, affineTransform.m02 * affineTransform2.m00 + affineTransform.m12 * affineTransform2.m01 + affineTransform2.m02, affineTransform.m02 * affineTransform2.m10 + affineTransform.m12 * affineTransform2.m11 + affineTransform2.m12);
    }

    public void concatenate(AffineTransform affineTransform) {
        this.setTransform(this.multiply(affineTransform, this));
    }

    public void preConcatenate(AffineTransform affineTransform) {
        this.setTransform(this.multiply(this, affineTransform));
    }

    public AffineTransform createInverse() throws NoninvertibleTransformException {
        float f = this.getDeterminant();
        if (MathFloat.abs(f) < 1.0E-10f) {
            throw new NoninvertibleTransformException(determinantIsZero);
        }
        return new AffineTransform(this.pointFactory, this.m11 / f, -this.m10 / f, -this.m01 / f, this.m00 / f, (this.m01 * this.m12 - this.m11 * this.m02) / f, (this.m10 * this.m02 - this.m00 * this.m12) / f);
    }

    public Vertex transform(Vertex vertex, Vertex vertex2) {
        if (vertex2 == null) {
            vertex2 = this.pointFactory.create();
        }
        float f = vertex.getX();
        float f2 = vertex.getY();
        vertex2.setCoord(f * this.m00 + f2 * this.m01 + this.m02, f * this.m10 + f2 * this.m11 + this.m12, 0.0f);
        return vertex2;
    }

    public void transform(Vertex[] vertexArray, int n, Vertex[] vertexArray2, int n2, int n3) {
        while (--n3 >= 0) {
            Vertex vertex = vertexArray[n++];
            float f = vertex.getX();
            float f2 = vertex.getY();
            Vertex vertex2 = vertexArray2[n2];
            if (vertex2 == null) {
                throw new IllegalArgumentException("dst[" + n2 + "] is null");
            }
            vertex2.setCoord(f * this.m00 + f2 * this.m01 + this.m02, f * this.m10 + f2 * this.m11 + this.m12, 0.0f);
            vertexArray2[n2++] = vertex2;
        }
    }

    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        int n4 = 2;
        if (fArray == fArray2 && n < n2 && n2 < n + n3 * 2) {
            n = n + n3 * 2 - 2;
            n2 = n2 + n3 * 2 - 2;
            n4 = -2;
        }
        while (--n3 >= 0) {
            float f = fArray[n + 0];
            float f2 = fArray[n + 1];
            fArray2[n2 + 0] = f * this.m00 + f2 * this.m01 + this.m02;
            fArray2[n2 + 1] = f * this.m10 + f2 * this.m11 + this.m12;
            n += n4;
            n2 += n4;
        }
    }

    public Vertex deltaTransform(Vertex vertex, Vertex vertex2) {
        if (vertex2 == null) {
            vertex2 = this.pointFactory.create();
        }
        float f = vertex.getX();
        float f2 = vertex.getY();
        vertex2.setCoord(f * this.m00 + f2 * this.m01, f * this.m10 + f2 * this.m11, 0.0f);
        return vertex2;
    }

    public void deltaTransform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        while (--n3 >= 0) {
            float f = fArray[n++];
            float f2 = fArray[n++];
            fArray2[n2++] = f * this.m00 + f2 * this.m01;
            fArray2[n2++] = f * this.m10 + f2 * this.m11;
        }
    }

    public Vertex inverseTransform(Vertex vertex, Vertex vertex2) throws NoninvertibleTransformException {
        float f = this.getDeterminant();
        if (MathFloat.abs(f) < 1.0E-10f) {
            throw new NoninvertibleTransformException(determinantIsZero);
        }
        if (vertex2 == null) {
            vertex2 = this.pointFactory.create();
        }
        float f2 = vertex.getX() - this.m02;
        float f3 = vertex.getY() - this.m12;
        vertex2.setCoord((f2 * this.m11 - f3 * this.m01) / f, (f3 * this.m00 - f2 * this.m10) / f, 0.0f);
        return vertex2;
    }

    public void inverseTransform(float[] fArray, int n, float[] fArray2, int n2, int n3) throws NoninvertibleTransformException {
        float f = this.getDeterminant();
        if (MathFloat.abs(f) < 1.0E-10f) {
            throw new NoninvertibleTransformException(determinantIsZero);
        }
        while (--n3 >= 0) {
            float f2 = fArray[n++] - this.m02;
            float f3 = fArray[n++] - this.m12;
            fArray2[n2++] = (f2 * this.m11 - f3 * this.m01) / f;
            fArray2[n2++] = (f3 * this.m00 - f2 * this.m10) / f;
        }
    }

    public Path2D createTransformedShape(Path2D path2D) {
        if (path2D == null) {
            return null;
        }
        if (path2D instanceof Path2D) {
            return path2D.createTransformedShape(this);
        }
        PathIterator pathIterator = path2D.iterator(this);
        Path2D path2D2 = new Path2D(pathIterator.getWindingRule());
        path2D2.append(pathIterator, false);
        return path2D2;
    }

    public String toString() {
        return this.getClass().getName() + "[[" + this.m00 + ", " + this.m01 + ", " + this.m02 + "], [" + this.m10 + ", " + this.m11 + ", " + this.m12 + "]]";
    }

    public AffineTransform clone() {
        try {
            return (AffineTransform)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof AffineTransform) {
            AffineTransform affineTransform = (AffineTransform)object;
            return this.m00 == affineTransform.m00 && this.m01 == affineTransform.m01 && this.m02 == affineTransform.m02 && this.m10 == affineTransform.m10 && this.m11 == affineTransform.m11 && this.m12 == affineTransform.m12;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.type = -1;
    }
}

