/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.curve.text;

import com.jogamp.graph.curve.OutlineShape;
import com.jogamp.graph.curve.opengl.GLRegion;
import com.jogamp.graph.curve.opengl.RenderState;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.geom.AABBox;
import com.jogamp.graph.geom.Triangle;
import com.jogamp.graph.geom.Vertex;
import com.jogamp.graph.geom.opengl.SVertex;
import java.util.ArrayList;
import javax.media.opengl.GL2ES2;
import jogamp.graph.curve.opengl.RegionFactory;
import jogamp.graph.curve.text.GlyphShape;
import jogamp.graph.font.FontInt;

public class GlyphString {
    public static final int STATIC_FONT_SIZE = 10;
    private ArrayList<GlyphShape> glyphs = new ArrayList();
    private CharSequence str;
    private String fontname;
    private GLRegion region;
    private SVertex origin = new SVertex();

    public static GlyphString createString(OutlineShape outlineShape, Vertex.Factory<? extends Vertex> factory, Font font, String string) {
        return GlyphString.createString(outlineShape, factory, font, 10, string);
    }

    public static GlyphString createString(OutlineShape outlineShape, Vertex.Factory<? extends Vertex> factory, Font font, int n, String string) {
        ArrayList<OutlineShape> arrayList = ((FontInt)font).getOutlineShapes(string, n, factory);
        GlyphString glyphString = new GlyphString(font.getName(3), string);
        glyphString.createfromOutlineShapes(factory, arrayList);
        if (null != outlineShape) {
            for (int i = 0; i < glyphString.glyphs.size(); ++i) {
                outlineShape.addOutlineShape(glyphString.glyphs.get(i).getShape());
            }
        }
        return glyphString;
    }

    public GlyphString(String string, CharSequence charSequence) {
        this.fontname = string;
        this.str = charSequence;
    }

    public void addGlyphShape(GlyphShape glyphShape) {
        this.glyphs.add(glyphShape);
    }

    public CharSequence getString() {
        return this.str;
    }

    public void createfromOutlineShapes(Vertex.Factory<? extends Vertex> factory, ArrayList<OutlineShape> arrayList) {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            GlyphShape glyphShape;
            if (arrayList.get(i) == null || (glyphShape = new GlyphShape(factory, arrayList.get(i))).getNumVertices() < 3) continue;
            this.addGlyphShape(glyphShape);
        }
    }

    public GLRegion createRegion(GL2ES2 gL2ES2, int n) {
        this.region = RegionFactory.create(n);
        int n2 = this.region.getNumVertices();
        for (int i = 0; i < this.glyphs.size(); ++i) {
            GlyphShape glyphShape = this.glyphs.get(i);
            ArrayList<Triangle> arrayList = glyphShape.triangulate();
            this.region.addTriangles(arrayList);
            ArrayList<Vertex> arrayList2 = glyphShape.getVertices();
            for (int j = 0; j < arrayList2.size(); ++j) {
                Vertex vertex = arrayList2.get(j);
                vertex.setId(n2++);
                this.region.addVertex(vertex);
            }
        }
        return this.region;
    }

    public String getTextHashCode() {
        return "" + this.fontname.hashCode() + this.str.hashCode();
    }

    public void renderString3D(GL2ES2 gL2ES2) {
        this.region.draw(gL2ES2, null, 0, 0, null);
    }

    public void renderString3D(GL2ES2 gL2ES2, RenderState renderState, int n, int n2, int[] nArray) {
        this.region.draw(gL2ES2, renderState, n, n2, nArray);
    }

    public Vertex getOrigin() {
        return this.origin;
    }

    public void destroy(GL2ES2 gL2ES2, RenderState renderState) {
        if (null != gL2ES2 && null != renderState) {
            this.region.destroy(gL2ES2, renderState);
            this.region = null;
        } else if (null != this.region) {
            throw new InternalError("destroy called w/o GL context, but has a region");
        }
        this.glyphs.clear();
    }

    public AABBox getBounds() {
        return this.region.getBounds();
    }
}

