/*
 Copyright (c) 2010, Yahoo! Inc. All rights reserved.
 Code licensed under the BSD License:
 http://developer.yahoo.com/yui/license.html
 version: 3.3.0
 build: 3167
 */
YUI.add('resize-constrain',function(Y){var Lang=Y.Lang,isBoolean=Lang.isBoolean,isNumber=Lang.isNumber,isString=Lang.isString,capitalize=Y.Resize.capitalize,isNode=function(v){return(v instanceof Y.Node);},toNumber=function(num){return parseFloat(num)||0;},BORDER_BOTTOM_WIDTH='borderBottomWidth',BORDER_LEFT_WIDTH='borderLeftWidth',BORDER_RIGHT_WIDTH='borderRightWidth',BORDER_TOP_WIDTH='borderTopWidth',BORDER='border',BOTTOM='bottom',CON='con',CONSTRAIN='constrain',HOST='host',LEFT='left',MAX_HEIGHT='maxHeight',MAX_WIDTH='maxWidth',MIN_HEIGHT='minHeight',MIN_WIDTH='minWidth',NODE='node',OFFSET_HEIGHT='offsetHeight',OFFSET_WIDTH='offsetWidth',PRESEVE_RATIO='preserveRatio',REGION='region',RESIZE_CONTRAINED='resizeConstrained',RIGHT='right',TICK_X='tickX',TICK_Y='tickY',TOP='top',WIDTH='width',VIEW='view',VIEWPORT_REGION='viewportRegion';function ResizeConstrained(){ResizeConstrained.superclass.constructor.apply(this,arguments);}
Y.mix(ResizeConstrained,{NAME:RESIZE_CONTRAINED,NS:CON,ATTRS:{constrain:{setter:function(v){if(v&&(isNode(v)||isString(v)||v.nodeType)){v=Y.one(v);}
return v;}},minHeight:{value:15,validator:isNumber},minWidth:{value:15,validator:isNumber},maxHeight:{value:Infinity,validator:isNumber},maxWidth:{value:Infinity,validator:isNumber},preserveRatio:{value:false,validator:isBoolean},tickX:{value:false},tickY:{value:false}}});Y.extend(ResizeConstrained,Y.Plugin.Base,{constrainSurrounding:null,initializer:function(){var instance=this,host=instance.get(HOST);host.delegate.dd.plug(Y.Plugin.DDConstrained,{tickX:instance.get(TICK_X),tickY:instance.get(TICK_Y)});host.after('resize:align',Y.bind(instance._handleResizeAlignEvent,instance));host.on('resize:start',Y.bind(instance._handleResizeStartEvent,instance));},_checkConstrain:function(axis,axisConstrain,offset){var instance=this,point1,point1Constrain,point2,point2Constrain,host=instance.get(HOST),info=host.info,constrainBorders=instance.constrainSurrounding.border,region=instance._getConstrainRegion();if(region){point1=info[axis]+info[offset];point1Constrain=region[axisConstrain]-toNumber(constrainBorders[capitalize(BORDER,axisConstrain,WIDTH)]);if(point1>=point1Constrain){info[offset]-=(point1-point1Constrain);}
point2=info[axis];point2Constrain=region[axis]+toNumber(constrainBorders[capitalize(BORDER,axis,WIDTH)]);if(point2<=point2Constrain){info[axis]+=(point2Constrain-point2);info[offset]-=(point2Constrain-point2);}}},_checkHeight:function(){var instance=this,host=instance.get(HOST),info=host.info,maxHeight=(instance.get(MAX_HEIGHT)+host.totalVSurrounding),minHeight=(instance.get(MIN_HEIGHT)+host.totalVSurrounding);instance._checkConstrain(TOP,BOTTOM,OFFSET_HEIGHT);if(info.offsetHeight>maxHeight){host._checkSize(OFFSET_HEIGHT,maxHeight);}
if(info.offsetHeight<minHeight){host._checkSize(OFFSET_HEIGHT,minHeight);}},_checkRatio:function(){var instance=this,host=instance.get(HOST),info=host.info,originalInfo=host.originalInfo,oWidth=originalInfo.offsetWidth,oHeight=originalInfo.offsetHeight,oTop=originalInfo.top,oLeft=originalInfo.left,oBottom=originalInfo.bottom,oRight=originalInfo.right,wRatio=function(){return(info.offsetWidth/oWidth);},hRatio=function(){return(info.offsetHeight/oHeight);},isClosestToHeight=host.changeHeightHandles,bottomDiff,constrainBorders,constrainRegion,leftDiff,rightDiff,topDiff;if(instance.get(CONSTRAIN)&&host.changeHeightHandles&&host.changeWidthHandles){constrainRegion=instance._getConstrainRegion();constrainBorders=instance.constrainSurrounding.border;bottomDiff=(constrainRegion.bottom-toNumber(constrainBorders[BORDER_BOTTOM_WIDTH]))-oBottom;leftDiff=oLeft-(constrainRegion.left+toNumber(constrainBorders[BORDER_LEFT_WIDTH]));rightDiff=(constrainRegion.right-toNumber(constrainBorders[BORDER_RIGHT_WIDTH]))-oRight;topDiff=oTop-(constrainRegion.top+toNumber(constrainBorders[BORDER_TOP_WIDTH]));if(host.changeLeftHandles&&host.changeTopHandles){isClosestToHeight=(topDiff<leftDiff);}
else if(host.changeLeftHandles){isClosestToHeight=(bottomDiff<leftDiff);}
else if(host.changeTopHandles){isClosestToHeight=(topDiff<rightDiff);}
else{isClosestToHeight=(bottomDiff<rightDiff);}}
if(isClosestToHeight){info.offsetWidth=oWidth*hRatio();instance._checkWidth();info.offsetHeight=oHeight*wRatio();}
else{info.offsetHeight=oHeight*wRatio();instance._checkHeight();info.offsetWidth=oWidth*hRatio();}
if(host.changeTopHandles){info.top=oTop+(oHeight-info.offsetHeight);}
if(host.changeLeftHandles){info.left=oLeft+(oWidth-info.offsetWidth);}
Y.each(info,function(value,key){if(isNumber(value)){info[key]=Math.round(value);}});},_checkRegion:function(){var instance=this,host=instance.get(HOST),region=instance._getConstrainRegion();return Y.DOM.inRegion(null,region,true,host.info);},_checkWidth:function(){var instance=this,host=instance.get(HOST),info=host.info,maxWidth=(instance.get(MAX_WIDTH)+host.totalHSurrounding),minWidth=(instance.get(MIN_WIDTH)+host.totalHSurrounding);instance._checkConstrain(LEFT,RIGHT,OFFSET_WIDTH);if(info.offsetWidth<minWidth){host._checkSize(OFFSET_WIDTH,minWidth);}
if(info.offsetWidth>maxWidth){host._checkSize(OFFSET_WIDTH,maxWidth);}},_getConstrainRegion:function(){var instance=this,host=instance.get(HOST),node=host.get(NODE),constrain=instance.get(CONSTRAIN),region=null;if(constrain){if(constrain==VIEW){region=node.get(VIEWPORT_REGION);}
else if(isNode(constrain)){region=constrain.get(REGION);}
else{region=constrain;}}
return region;},_handleResizeAlignEvent:function(event){var instance=this,host=instance.get(HOST);instance._checkHeight();instance._checkWidth();if(instance.get(PRESEVE_RATIO)){instance._checkRatio();}
if(instance.get(CONSTRAIN)&&!instance._checkRegion()){host.info=host.lastInfo;}},_handleResizeStartEvent:function(event){var instance=this,constrain=instance.get(CONSTRAIN),host=instance.get(HOST);instance.constrainSurrounding=host._getBoxSurroundingInfo(constrain);}});Y.namespace('Plugin');Y.Plugin.ResizeConstrained=ResizeConstrained;},'3.3.0',{requires:['resize-base','plugin'],skinnable:false});
