<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');
/*********************************************************************************
 * SugarCRM is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004 - 2007 SugarCRM Inc.
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 * 
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 * 
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU General Public License version 3.
 * 
 * In accordance with Section 7(b) of the GNU General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * SugarCRM" logo. If the display of the logo is not reasonably feasible for
 * technical reasons, the Appropriate Legal Notices must display the words
 * "Powered by SugarCRM".
 ********************************************************************************/
/*********************************************************************************

 * Description:  Contains a variety of utility functions used to display UI 
 * components such as form headers and footers.  Intended to be modified on a per 
 * theme basis.
 * Portions created by SugarCRM are Copyright (C) SugarCRM, Inc.
 * All Rights Reserved.
 * Contributor(s): ______________________________________..
 ********************************************************************************/
function get_validate_import_parent_fields_js (&$parent_fields)
{
	global $mod_strings;

	$err_multiple = $mod_strings['ERR_MULTIPLE_PARENTS'];
	$print_parent_array = "";

	foreach ($parent_fields as $parent_id=>$translation)
	{
		$print_parent_array .= "parents['$parent_id'] = '". $translation . "';\n";
		
	}

	$the_script  = <<<EOQ

<script type="text/javascript" language="Javascript">
<!--  to hide script contents from old browsers

function verify_parent_data(form) 
{
	var isError = false;
	var errorMessage = "$err_multiple";
	var got_parent = false;
	var got_multiple = false;

	var parents = new Object();

	$print_parent_array

	for(i=0;i < form.length;i++)
	{
		if ( got_multiple == true )
		{
			break;
		}

		if ( form.elements[i].name.indexOf("colnum",0) == 0)
		{
			
		
			if ( form.elements[i].value == "-1")
			{
				continue;
			}

			for (parent_id in parents)
			{
				if ( parent_id == form.elements[i].value)
				{
					if ( got_parent == false)
					{
						got_parent = true;
					}
					else
					{
						got_multiple = true;
					}

					break;
				}	
			}
		}
	}

	if (got_multiple == true) 
	{
		alert( errorMessage);
		return false;
	}


	return true;
}


function formsubmit(theform) {

		var url=site_url.site_url + "/TreeData.php?" + get_post_url(theform);
		var callback =	{
			  success: function(o) {    
			    	var targetdiv=document.getElementById('activetimeperiodsworksheet');
	    			targetdiv.innerHTML=o.responseText;
			  },
			  failure: function(o) {/*failure handler code*/}
		};
	
		var trobj = YAHOO.util.Connect.asyncRequest('GET',url, callback, null);
}

// end hiding contents from old browsers  -->
</script>

EOQ;
	return $the_script;

}

function get_validate_import_fields_js (&$req_fields,&$all_fields,$verify_parent)
{
	global $mod_strings;

	if ( $verify_parent)
	{
		$return_verify_parent_data = "return verify_parent_data(form);\n";
	}
	else
	{
		$return_verify_parent_data = "";
	}
	$err_multiple = $mod_strings['ERR_MULTIPLE'];
	$err_required = $mod_strings['ERR_MISSING_REQUIRED_FIELDS']; 
	$err_select_full_name = $mod_strings['ERR_SELECT_FULL_NAME']; 
	$print_required_array = "";

	foreach ($req_fields as $required=>$unused)
	{
		$print_required_array .= "required['$required'] = '". $all_fields[$required] . "';\n";
		
	}

	$the_script  = <<<EOQ

<script type="text/javascript" language="Javascript">
<!--  to hide script contents from old browsers

function verify_data(form) 
{
	var isError = false;
	var errorMessage = "";

        var hash = new Object();

	var required = new Object();

	$print_required_array

	for(i=0;i < form.length;i++)
	{
		if ( form.elements[i].name.indexOf("colnum",0) == 0)
		{
		
			if ( form.elements[i].value == "-1")
			{
				continue;
			}
			if ( hash[ form.elements[i].value ] == 1)
			{
				// got same field more than once
				isError = true;
			}
			hash[form.elements[i].value] = 1;
		}
        }

	if (isError == true) 
	{
		alert( "$err_multiple" );
		return false;
	}

	if (hash['full_name'] == 1 && (hash['last_name'] == 1 || hash['first_name'] == 1) )
	{
		alert( "$err_select_full_name" );
		return false;
	}

	for(var field_name in required)
	{
		// contacts hack to bypass errors if full_name is set
		if (field_name == 'last_name' && 
				hash['full_name'] == 1)
		{
			continue;
		}
		if ( hash[ field_name ] != 1 )
		{
				isError = true;
				errorMessage += "$err_required " + required[field_name];
		}
	}

	if (isError == true) 
	{
		alert( errorMessage);
		return false;
	}


	$return_verify_parent_data

	return true;
}

// end hiding contents from old browsers  -->
</script>

EOQ;

	return $the_script;
}




function get_validate_upload_js () 
{
	global $mod_strings;

	$err_missing_required_fields = $mod_strings['ERR_MISSING_REQUIRED_FIELDS'];
	$lbl_select_file = $mod_strings['ERR_SELECT_FILE'];
	$lbl_custom = $mod_strings['LBL_CUSTOM'];

	$the_script  = <<<EOQ

<script type="text/javascript" language="Javascript">
<!--  to hide script contents from old browsers

function verify_data(form) 
{
	var isError = false;
	var errorMessage = "";
	if (form.userfile.value == "") 
	{
		isError = true;
		errorMessage += "\\n$lbl_select_file";
        } 

	if (isError == true) 
	{
		alert("$err_missing_required_fields" + errorMessage);
		return false;
	}


	return true;
}

// end hiding contents from old browsers  -->
</script>

EOQ;

	return $the_script;
}

function get_chooser_js()
{
$the_script  = <<<EOQ

<script type="text/javascript" language="javascript">
<!--  to hide script contents from old browsers

function set_chooser()
{
    var chosen_indices = '';
    var selectedOptions = document.getElementById('choose_index_td').getElementsByTagName('select')[0].options.length;
    for (i = 0; i < selectedOptions; i++)
    {
        chosen_indices += document.getElementById('choose_index_td').getElementsByTagName('select')[0].options[i].value;        
        if (i != (selectedOptions - 1))    
            chosen_indices += "&";
    }
    document.Import.display_tabs_def.value = chosen_indices;
	/*
	for(i=0; i < object_refs['choose_index'].options.length ;i++)
	{
	         chosen_indices += "choose_index[]="+object_refs['choose_index'].options[i].value+"&";
	}    
	document.Import.display_tabs_def.value = chosen_indices;
    */
}
// end hiding contents from old browsers  -->
</script>
EOQ;

return $the_script;
}


function getFieldSelect(&$column_fields,$colnum,&$required_fields,$suggest_field,$translated_fields)
{
	global $mod_strings;
	global $app_strings;
	global $outlook_contacts_field_map;

	$output = "<select name=\"colnum" . $colnum ."\">\n";
	$output .= "<option value=\"-1\">". $mod_strings['LBL_DONT_MAP'] . "</option>";

	$count = 0;
	$req_mark = ""; 

	asort($translated_fields);

	foreach ($translated_fields as $field=>$name)
	{

	 	if (! isset($column_fields[$field]))
		{
			continue;
		}

		$output .= "<option value=\"".$field;

		if ( isset( $suggest_field) && 
			$field == $suggest_field)
		{
			$output .= "\" SELECTED>";
		}
		else 
		{
			$output .= "\">";
		}
		if ( isset( $required_fields[$field]))
		{
			$req_mark = " ". $app_strings['LBL_REQUIRED_SYMBOL'];
		} 
		else
		{
			$req_mark = "";
		}
        
        // Bug 16944 - Remove any trailing colons or spaces in the option labels
        $name = rtrim($name," :");
        
		$output .=  $name . $req_mark."</option>\n";

		$count ++;
	}

	$output .= "</select>\n";

	return $output;

}


function get_readonly_js () 
{
?>
<script type="text/javascript" language="Javascript">
<!--  to hide script contents from old browsers

function set_readonly(form) 
{
	
	if (form.save_map.checked) 
	{ 
		form.save_map.value='on'; 
		form.save_map_as.readOnly=false;
		form.save_map_as.focus();
	}
	else 
	{
		form.save_map.value='off'; 
		form.save_map_as.value=""; 
		form.save_map_as.readOnly=true; 
	}
}

// end hiding contents from old browsers  -->
</script>

<?php
}


?>
