<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');
/*********************************************************************************
 * SugarCRM is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004 - 2007 SugarCRM Inc.
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 * 
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 * 
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU General Public License version 3.
 * 
 * In accordance with Section 7(b) of the GNU General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * SugarCRM" logo. If the display of the logo is not reasonably feasible for
 * technical reasons, the Appropriate Legal Notices must display the words
 * "Powered by SugarCRM".
 ********************************************************************************/

/**
 * Set up an array of Jobs with the appropriate metadata
 * 'jobName' => array (
 * 		'X' => 'name',
 * )
 * 'X' should be an increment of 1
 * 'name' should be the EXACT name of your function
 *
 * Your function should not be passed any parameters
 * Always  return a Boolean. If it does not the Job will not terminate itself
 * after completion, and the webserver will be forced to time-out that Job instance.
 * DO NOT USE sugar_cleanup(); in your function flow or includes.  this will
 * break Schedulers.  That function is called at the foot of cron.php
 */

/**
 * This array provides the Schedulers admin interface with values for its "Job"
 * dropdown menu.
 */
$job_strings = array (
	0 => 'refreshJobs',
	1 => 'pollMonitoredInboxes',
	2 => 'runMassEmailCampaign',
	3 => 'pruneDatabase',
	4 => 'trimTracker',
	/*4 => 'securityAudit()',*/
	5 => 'pollMonitoredInboxesForBouncedCampaignEmails',








);

/**
 * Job 0 refreshes all job schedulers at midnight
 * DEPRECATED
 */
function refreshJobs() {
	return true;
}


/**
 * Job 1
 */
function pollMonitoredInboxes() {

	$GLOBALS['log']->info('----->Scheduler fired job of type pollMonitoredInboxes()');
	global $dictionary;
	global $app_strings;
	require_once('modules/InboundEmail/InboundEmail.php');
	require_once('modules/Emails/Email.php');

	$ie = new InboundEmail();
	$r = $ie->db->query('SELECT id, name FROM inbound_email WHERE is_personal = 0 AND deleted=0 AND status=\'Active\' AND mailbox_type != \'bounce\'');
	$GLOBALS['log']->debug('Just got Result from get all Inbounds of Inbound Emails');

	while($a = $ie->db->fetchByAssoc($r)) {
		$GLOBALS['log']->debug('In while loop of Inbound Emails');


		$ieX = new InboundEmail();
		$ieX->retrieve($a['id']);
		$newMsgs = array();
		$connectToMailServer = false;
		if ($ieX->isPop3Protocol()) {
			$newMsgs = $ieX->getPop3NewMessagesToDownload();
		}
		if($ieX->connectMailserver() == 'true') {
			$connectToMailServer = true;
		} // if

		$GLOBALS['log']->debug('Trying to connect to mailserver for [ '.$a['name'].' ]');
		if($connectToMailServer) {
			$GLOBALS['log']->debug('Connected to mailserver');
			if (!$ieX->isPop3Protocol()) {
				$newMsgs = $ieX->getNewMessageIds();
			}
			if(is_array($newMsgs)) {
				$current = 1;
				$total = count($newMsgs);
				require_once("include/SugarFolders/SugarFolders.php");
				$sugarFolder = new SugarFolder();
				$groupFolderId = $ieX->groupfolder_id;
				$isGroupFolderExists = false;
				if ($groupFolderId != null && $groupFolderId != "") {
					$sugarFolder->retrieve($groupFolderId);
					$isGroupFolderExists = true;



				}
				$messagesToDelete = array();
				foreach($newMsgs as $k => $msgNo) {
					$uid = $msgNo;
					if ($ieX->isPop3Protocol()) {
						$uid = $ieX->getUIDLForMessage($msgNo);
					} else {
						$uid = imap_uid($ieX->conn, $msgNo);
					} // else
					if ($isGroupFolderExists) {



						if ($ieX->importOneEmail($msgNo, $uid)) {
							// add to folder
							$sugarFolder->addBean($ieX->email);
							if ($ieX->isPop3Protocol()) {
								$messagesToDelete[] = $msgNo;
								//$ieX->deleteMessageOnMailServer($msgNo);
							} else {
								$messagesToDelete[] = $uid;
								//$ieX->deleteMessageOnMailServer($uid);
							}
						} // if
					} else {
							if($ieX->isAutoImport()) {
								$ieX->importOneEmail($msgNo, $uid);
							} else {
								/*If the group folder doesn't exist then download only those messages
								 which has caseid in message*/
								$email = new Email();
								$header = imap_headerinfo($ieX->conn, $msgNo);
								$email->name = $ieX->handleMimeHeaderDecode($header->subject);
								$email->from_addr = $ieX->convertImapToSugarEmailAddress($header->from);
								$email->reply_to_email  = $ieX->convertImapToSugarEmailAddress($header->reply_to);
								if(!empty($email->reply_to_email)) {
									$contactAddr = $email->reply_to_email;
								} else {
									$contactAddr = $email->from_addr;
								}
								if (($ieX->mailbox_type == 'support') || ($ieX->mailbox_type == 'pick')) {
									if(!class_exists('aCase')) {
										require_once('modules/Cases/Case.php');
									}
									$c = new aCase();
									$GLOBALS['log']->debug('looking for a case for '.$email->name);
									if ($ieX->getCaseIdFromCaseNumber($email->name, $c)) {
										$ieX->importOneEmail($msgNo, $uid);
									} else {
										$ieX->handleAutoresponse($email, $contactAddr);
									} // else
								} else {
									$ieX->handleAutoresponse($email, $contactAddr);
								} // else
							} // else
					} // else
					$GLOBALS['log']->debug('***** On message [ '.$current.' of '.$total.' ] *****');
					$current++;
				} // for
			} // if
			if ($isGroupFolderExists)	 {
				if ($ieX->isPop3Protocol()) {
					$ieX->deleteMessageOnMailServerForPop3(implode(",", $messagesToDelete));
				} else {
					$ieX->deleteMessageOnMailServer(implode($app_strings['LBL_EMAIL_DELIMITER'], $messagesToDelete));
				}
			}
			imap_expunge($ieX->conn);
			imap_close($ieX->conn, CL_EXPUNGE);

		} else {
			$GLOBALS['log']->fatal("SCHEDULERS: could not get an IMAP connection resource for ID [ {$a['id']} ]. Skipping mailbox [ {$a['name']} ].");
			// cn: bug 9171 - continue while
		} // else
	} // while

	return true;
}

/**
 * Job 2
 */
function runMassEmailCampaign() {
	if (!class_exists('LoggerManager')){
		require('log4php/LoggerManager.php');
	}
	$GLOBALS['log'] = LoggerManager::getLogger('emailmandelivery');
	$GLOBALS['log']->debug('Called:runMassEmailCampaign');

	if (!class_exists('PearDatabase')){
		require('include/database/PearDatabase.php');
	}
	require_once('include/utils.php');
	global $beanList;
	global $beanFiles;
	require("config.php");
	require('include/modules.php');
	if(!class_exists('AclController')) {
		require('modules/ACL/ACLController.php');
	}

	require('modules/EmailMan/EmailManDelivery.php');
	return true;
}

/**
 *  Job 3
 */
function pruneDatabase() {
	$GLOBALS['log']->info('----->Scheduler fired job of type pruneDatabase()');
	$backupDir	= 'cache/backups';
	$backupFile	= 'backup-pruneDatabase-GMT0_'.gmdate('Y_m_d-H_i_s', strtotime('now')).'.php';

	$db = PearDatabase::getInstance();
	$tables = $db->getTablesArray();

//_ppd($tables);
	if(!empty($tables)) {
		foreach($tables as $kTable => $table) {
			// find tables with deleted=1
			$qDel = 'SELECT * FROM '.$table.' WHERE deleted = 1';
			$rDel = $db->query($qDel);// OR continue; // continue if no 'deleted' column

			// make a backup INSERT query if we are deleting.
			while($aDel = $db->fetchByAssoc($rDel)) {
				// build column names
				$rCols = $db->query('SHOW COLUMNS FROM '.$table);
				$colName = array();

				while($aCols = $db->fetchByAssoc($rCols)) {
					$colName[] = $aCols['Field'];
				}

				$query = 'INSERT INTO '.$table.' (';
				$values = '';
				foreach($colName as $kC => $column) {
					$query .= $column.', ';
					$values .= '"'.$aDel[$column].'", ';
				}

				$query  = substr($query, 0, (strlen($query) - 2));
				$values = substr($values, 0, (strlen($values) - 2));
				$query .= ') VALUES ('.str_replace("'", "&#039;", $values).');';

				$queryString[] = $query;

				if(empty($colName)) {
					$GLOBALS['log']->fatal('pruneDatabase() could not get the columns for table ('.$table.')');
				}
			} // end aDel while()
			// now do the actual delete
			$db->query('DELETE FROM '.$table.' WHERE deleted = 1');
		} // foreach() tables

		// now output file with SQL
		if(!function_exists('mkdir_recursive')) {
			require_once('include/dir_inc.php');
		}
		if(!function_exists('write_array_to_file')) {
			require_once('include/utils/file_utils.php');
		}
		if(!file_exists($backupDir) || !file_exists($backupDir.'/'.$backupFile)) {
			// create directory if not existent
			mkdir_recursive($backupDir, false);
		}
		// write cache file

		write_array_to_file('pruneDatabase', $queryString, $backupDir.'/'.$backupFile);
		return true;
	}
	return false;
}


///**
// * Job 4
// */

//function securityAudit() {
//	// do something
//	return true;
//}

function trimTracker()
{
    global $sugar_config;

	$GLOBALS['log']->info('----->Scheduler fired job of type trimTracker()');
	$history_max = (!empty($sugar_config['history_max_viewed'])) ? $sugar_config['history_max_viewed'] : 10;
	$history_max += (!empty($sugar_config['history_padding'])) ? $sugar_config['history_padding'] : 5;

	$db = PearDatabase::getInstance();
	switch ($db->dbType)
	{
	    case 'mssql': // MSSQL
	        $subquery = "select top $history_max id FROM tracker t2 WHERE t2.user_id = t1.user_id AND visible = 1 ORDER BY id DESC";
	        break;

	    case 'oci8': // ORACLE
	        $subquery = "select min(id) minid FROM (select id, ROWNUM as seq FROM tracker t2 WHERE t2.user_id = t1.user_id AND visible = 1 ORDER BY id DESC) t3 WHERE t3.seq < $history_max";
	        break;

	    default: // MySQL
	        $subquery = "select id FROM tracker t2 WHERE t2.user_id = t1.user_id AND visible = 1 ORDER BY id DESC LIMIT ".((int)$history_max-1).",1";
	}
	$query = "select user_id, ($subquery) minid FROM tracker t1 GROUP by user_id";
    $GLOBALS['log']->info('----->Scheduler is finding the rows to remove by running '.$query);
    $db->query($query, true);

    $row = $db->fetchByAssoc($result, -1, false);
    if ($row)
    {
		$minID = $row['minid'];
		$GLOBALS['log']->debug('----->Scheduler found '.$row['user_id']. ' ' .$row['minid']);
        while($row = $db->fetchByAssoc($result, -1, false))
        {
            if($row['minid'] < $minID)
            {
            	$minID = $row['minid'];
            }
        }
        if (!empty($minID))
        {
            $query = "DELETE FROM tracker WHERE id < '${minID}'";
            $GLOBALS['log']->info('----->Scheduler is about to trim the tracker table by running the query '.$query);
        }
        else
        {
            $GLOBALS['log']->info('----->Scheduler found nothing to remove');
        }
        $db->query($query,true);
    }
    return true;
}

/* Job 5
 *
 */
function pollMonitoredInboxesForBouncedCampaignEmails() {
	$GLOBALS['log']->info('----->Scheduler job of type pollMonitoredInboxesForBouncedCampaignEmails()');
	global $dictionary;
	require_once('modules/InboundEmail/InboundEmail.php');

	$ie = new InboundEmail();
	$r = $ie->db->query('SELECT id FROM inbound_email WHERE deleted=0 AND status=\'Active\' AND mailbox_type=\'bounce\'');

	while($a = $ie->db->fetchByAssoc($r)) {
		$ieX = new InboundEmail();
		$ieX->retrieve($a['id']);
		$ieX->connectMailserver();

		$newMsgs = array();
		if ($ieX->isPop3Protocol()) {
			$newMsgs = $ieX->getPop3NewMessagesToDownload();
		} else {
			$newMsgs = $ieX->getNewMessageIds();
		}

		//$newMsgs = $ieX->getNewMessageIds();
		if(is_array($newMsgs)) {
			foreach($newMsgs as $k => $msgNo) {
				$uid = $msgNo;
				if ($ieX->isPop3Protocol()) {
					$uid = $ieX->getUIDLForMessage($msgNo);
				} else {
					$uid = imap_uid($ieX->conn, $msgNo);
				} // else

				$ieX->importOneEmail($msgNo, $uid, false,false);
			}
		}
		imap_expunge($ieX->conn);
		imap_close($ieX->conn);
	}

	return true;
}
























































?>
