<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');
/**
 * SugarCRM is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004 - 2007 SugarCRM Inc.
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 * 
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 * 
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU General Public License version 3.
 * 
 * In accordance with Section 7(b) of the GNU General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * SugarCRM" logo. If the display of the logo is not reasonably feasible for
 * technical reasons, the Appropriate Legal Notices must display the words
 * "Powered by SugarCRM".
 */



require_once('modules/ModuleBuilder/views/view.listview.php');
require_once('include/Sugar_Smarty.php');

class ViewSearchView extends ViewListView {

    function ViewSearchView()
    {
        $this->init();
    }

    function init()
    {
        $this->searchlayout = $_REQUEST['searchlayout'];
        parent::init();
    }

	// DO NOT REMOVE - overrides parent ViewEdit preDisplay() which attempts to load a bean for a non-existent module
	function preDisplay() {
	}

    function display() {

        require_once('modules/ModuleBuilder/parsers/ParserFactory.php');
        $parser = ParserFactory::getParser("SearchView",$this->fromModuleBuilder);
        $parser->init($this->editModule, $this->searchlayout);

        $smarty = $this->constructSmarty($parser);

        $ajax = $this->constructAjax();
        $ajax->addSection('center', 'no_change', $smarty->fetch("modules/ModuleBuilder/tpls/listView.tpl") );
       // $ajax->addSection('east', 'no_change', "");

        echo $ajax->getJavascript();

    }
    function constructAjax()
    {
        require_once('modules/ModuleBuilder/MB/AjaxCompose.php');
        $ajax = new AjaxCompose();
        $searchLabel = ($this->searchlayout == 'basic_search') ? translate('LBL_BASIC_SEARCH', 'ModuleBuilder') : translate('LBL_ADVANCED_SEARCH', 'ModuleBuilder');
        if ($this->fromModuleBuilder)
        {
            $ajax->addCrumb(translate('LBL_MODULEBUILDER', 'ModuleBuilder'), 'ModuleBuilder.main("mb")');
            $ajax->addCrumb($_REQUEST['package'],'ModuleBuilder.getContent("module=ModuleBuilder&action=package&package='.$_REQUEST['package'].'")');
            $ajax->addCrumb($_REQUEST['editModule'], 'ModuleBuilder.getContent("module=ModuleBuilder&action=module&view_package='.$_REQUEST['package'].'&view_module='. $_REQUEST['editModule'] . '")');
            $ajax->addCrumb(translate('LBL_LAYOUTS', 'ModuleBuilder'), 'ModuleBuilder.getContent("module=ModuleBuilder&MB=true&action=wizard&editModule='.$_REQUEST['editModule'].'&package='.$_REQUEST['package'].'")');
            if($this->subpanel != "")
            {
                $ajax->addCrumb(translate('LBL_SUBPANELS', 'ModuleBuilder'), '');
                $ajax->addCrumb($this->subpanel, '');
            }
            else
            {
                $ajax->addCrumb(translate('LBL_SEARCH_FORMS', 'ModuleBuilder'), 'ModuleBuilder.getContent("module=ModuleBuilder&MB=true&action=wizard&search=1&editModule='.$this->editModule.'&package='.$_REQUEST['package'].'")');
                $ajax->addCrumb($searchLabel, 'ModuleBuilder.getContent("module=ModuleBuilder&MB=true&action=editLayout&view=SearchView&searchlayout='.$this->searchlayout.'&editModule='.$this->editModule.'&package='.$_REQUEST['package'].'")');
            }
        }
        else
        {
            $ajax->addCrumb(translate('LBL_STUDIO', 'ModuleBuilder'), 'ModuleBuilder.getContent("module=ModuleBuilder&action=wizard")');
            $ajax->addCrumb($this->translatedEditModule, 'ModuleBuilder.getContent("module=ModuleBuilder&action=wizard&editModule='.$this->editModule.'")');

            if($this->subpanel)
            {
                $ajax->addCrumb(translate('LBL_SUBPANELS', 'ModuleBuilder'), 'ModuleBuilder.getContent("module=ModuleBuilder&action=wizard&subpanels=1&editModule='.$this->editModule.'")');
                $ajax->addCrumb($this->subpanel, 'ModuleBuilder.getContent("module=ModuleBuilder&action=editLayout&view=ListView&editModule='.$this->editModule.'&subpanel='.$this->subpanel.'")');
            }
            else
            {
                //$ajax->addCrumb(translate('LBL_SEARCH_FORMS', 'ModuleBuilder'), 'ModuleBuilder.getContent("module=ModuleBuilder&action=wizard&search=1&editModule='.$this->editModule.'")');
                $ajax->addCrumb(translate('LBL_LAYOUTS', 'ModuleBuilder'), 'ModuleBuilder.getContent("module=ModuleBuilder&action=wizard&layouts=1&editModule='.$this->editModule.'")');
                $ajax->addCrumb($searchLabel, 'ModuleBuilder.getContent("module=ModuleBuilder&action=editLayout&view=SearchView&searchlayout='.$this->searchlayout.'&editModule='.$this->editModule.'")');
            }
        }
        return $ajax;
    }

   function constructSmarty($parser) {
       $smarty = parent::constructSmarty($parser);
       $smarty->assign('action', 'searchViewSave');
       $smarty->assign('view', 'searchView');
       $smarty->assign('searchlayout', $this->searchlayout);
       $smarty->assign('helpName', 'searchViewEditor');
       $smarty->assign('helpDefault', 'modify');
       $smarty->assign('assistant', array('key'=>'multiselect_field_warning', 'group'=>'searchViewEditor'));
       return $smarty;
   }


}

?>
