<?php
/*********************************************************************************
 * SugarCRM is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004 - 2007 SugarCRM Inc.
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 * 
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 * 
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU General Public License version 3.
 * 
 * In accordance with Section 7(b) of the GNU General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * SugarCRM" logo. If the display of the logo is not reasonably feasible for
 * technical reasons, the Appropriate Legal Notices must display the words
 * "Powered by SugarCRM".
 ********************************************************************************/
$mod_strings = array(
'help'=>array(
	'package'=>array(
			'create'=>'Provide a <b>Name</b> for the package.  The name you enter must be alphanumeric and contain no spaces. (Example: HR_Management)<br/><br/> You can provide <b>Author</b> and <b>Description</b> information for package. <br/><br/>Click <b>Save</b> to create the package.',
			'modify'=>'You can modify the <b>Name</b>, <b>Author</b> and <b>Description</b> of the package, as well as view and customize all of the modules contained within the package.<br><br>You can also <b>Publish</b> and <b>Deploy</b> the package, as well as <b>Export</b> the customizations made in the package.',
			'name'=>'This is the <b>Name</b> of the current package. <br/><br/>The name you enter must be alphanumeric and contain no spaces. (Example: HR_Management)',
			'author'=>'This is the <b>Author</b> that is displayed during installation as the name of the entity that created the package. The Author can be either an individual or a company.',
			'description'=>'This is the <b>Description</b> of the package that is displayed during installation.',
			'publishbtn'=>'Click <b>Publish</b> to save all entered data and create a .zip file that is an installable version of the package.<br><br>Use <b>Module Loader</b> to upload the .zip file and install the package.',
			'deploybtn'=>'Click <b>Deploy</b> to save all entered data and install the package, including all modules, in the current instance.',
			'duplicatebtn'=>'Click <b>Duplicate</b> to copy the contents of the package into a new package and to display the new package. <br/><br/>For the new package, a new name will be generated automatically by appending a number to the end of the name of the package used to create the new one. You can rename the new package by entering a new <b>Name</b> and clicking <b>Save</b>.',
			'exportbtn'=>'Click <b>Export</b> to create a .zip file containing the customizations made in the package.<br><br> The generated file contains code for the package customizations, and it is not an installable version of the package.<br><br>Use <b>Module Loader</b> to import the .zip file and to make the customizations available for new packages.',
			'deletebtn'=>'Click <b>Delete</b> to delete this package and all files related to this package.',
			'savebtn'=>'Click <b>Save</b> to save all entered data related to the package.',
			'existing_module'=>'Click the <b>name of a module</b> to edit the properties and customize the fields, relationships and layouts associated with the module.',
			'new_module'=>'Click <b>New Module</b> to create a new module for this package.',
			'key'=>'This 5-letter, alphanumeric <b>Key</b> will be used to prefix all directories, class names and database tables for all of the modules in the current package.<br><br>The key is used in an effort to achieve table name uniqueness.',
			'readme'=>'You can add <b>Readme</b> text for this package.<br><br>The Readme will be available at the time of installation.',
	),
	'main'=>array(


	),
	'module'=>array(




		'create'=>'Provide a <b>Name</b> for the module. The <b>Label</b> that you provide will appear in the navigation tab. <br/><br/>Choose to display a navigation tab for the module by checking the <b>Navigation Tab</b> checkbox.<br/><br/>Then choose the type of module you would like to create. <br/><br/>Select a template type. Each template contains a specific set of fields, as well as pre-defined layouts, to use as a basis for your module. <br/><br/>Click <b>Save</b> to create the module.',

		'modify'=>'You can change the module properties or customize the <b>Fields</b>, <b>Relationships</b> and <b>Layouts</b> related to the module.',
		'team_security'=>'Checking the <b>Team Security</b> checkbox will enable team security for this module.  <br/><br/>If team security is enabled, the Team selection field will appear within the records in the module ',
		'reportable'=>'Checking this box will allow this module to have reports run against it.',
		'assignable'=>'Checking this box will allow a record in this module to be assigned to a selected user.',
		'has_tab'=>'Checking <b>Navigation Tab</b> will provide a navigation tab for the module.',
		'acl'=>'Checking this box will enable Access Controls on this module, including Field Level Security.',
		'studio'=>'Checking this box will allow administrators to customize this module within Studio.',
		'audit'=>'Checking this box will enable Auditing for this module. Changes to certain fields will be recorded so that administrators can review the change history.',
		'viewfieldsbtn'=>'Click <b>View Fields</b> to view the fields associated with the module and to create and edit custom fields.',
		'viewrelsbtn'=>'Click <b>View Relationships</b> to view the relationships associated with this module and to create new relationships.',
		'viewlayoutsbtn'=>'Click <b>View Layouts</b> to view the layouts for the module and to customize the field arrangement within the layouts.',
		'duplicatebtn'=>'Click <b>Duplicate</b> to copy the properties of the module into a new module and to display the new module. <br/><br/>For the new module, a new name will be generated automatically by appending a number to the end of the name of the module used to create the new one.<br><br>You can rename the new modulee by entering a new <b>Name</b> and clicking <b>Save</b>.',
		'deletebtn'=>'Click <b>Delete</b> to delete this module.',
		'name'=>'This is the <b>Name</b> of the current module. <br/><br/>The name you enter must be alphanumeric and must start with a letter and contain no spaces. (Example: HR_Management)',
		'label'=>'This is the <b>Label</b> that will appear in the navigation tab for the module. ',
		'savebtn'=>'Click <b>Save</b> to save all entered data related to the module.',
		'type_basic'=>'The <b>Basic</b> template type provides basic fields, such as the Name, Assigned to, Team, Date Created and Description fields.',
		'type_company'=>'The <b>Company</b> template type provides organization-specific fields, such as Company Name, Industry and Billing Address.<br/><br/>Use this template to create modules that are similar to the standard Accounts module.',
		'type_issue'=>'The <b>Issue</b> template type provides case- and bug-specific fields, such as Number, Status, Priority and Description.<br/><br/>Use this template to create modules that are similar to the standard Cases and Bug Tracker modules.',
		'type_person'=>'The <b>Person</b> template type provides individual-specific fields, such as Salutation, Title, Name, Address and Phone Number.<br/><br/>Use this template to create modules that are similar to the standard Contacts and Leads modules.',

	),
	'dropdowns'=>array(
		'default' => 'All of the dropdowns for the application are listed here.<br><br>  To make changes to an existing dropdown, click on the dropdown\'s name. <br><br>Make your changes within the <b>Dropdown Editor</b> form in the right-hand pane, and click <b>Save</b>. Make changes, as necessary, and then click <b>Save</b>.<br><br>To create a new dropdown, click <b>Add Dropdown</b>. Enter properties for the dropdown in the <b>Dropdown Editor</b> form, and click <b>Save</b>.'
	),
	'listViewEditor'=>array(
		'modify'	=> 'The <b>Default</b> column contains the fields that are displayed in a list view by default.<br/><br/>The <b>Available</b> column contains fields that a user can choose to create a custom list view. <br/><br/>The <b>Hidden</b> column contains fields that you as an admin can add to the Default or Available columns for users to see.',
		'savebtn'	=> 'Click <b>Save & Deploy</b> to save all changes you made and makes them active within the module.',
		'Hidden' 	=> 'Hidden fields not currently available for users to see in list views.',
		'Available' => 'Available fields are not shown by default, but can be added to list views by users.',
		'Default'	=> 'Default fields are displayed to users who have not created custom list views.'
	),
	'searchViewEditor'=>array(
		'modify'	=> 'The <b>Default</b> column contains the fields that will be displayed in the search view.<br/><br/>The <b>Hidden</b> column contains fields available for you as an admin to add to the view.',
		'savebtn'	=> 'Clicking <b>Save & Deploy</b> will save all changes and make them active',
		'Hidden' 	=> 'Hidden fields are fields that will not be shown in the search view.',
		'Default'	=> 'Default fields will be shown in the search view.'
	),
	'layoutEditor'=>array(
		'default'	=> 'Make changes to the displayed layout by dragging and dropping elements and fields between the two areas on this page.<br/><br/>The left-hand column, titled <b>Toolbox</b>, contains useful tools, elements and fields for changing the layout.<br/><br/>The right-hand area, titled <b>Current Layout</b> or <b>Layout Preview</b>, contains the module layout.<br/><br/>If the layout area is titled <b>Current Layout</b> then you are working on a copy of the layout that is currently displaying in the module.<br/><br/>If the layout area is titled <b>Layout Preview</b> then you are working on a copy created earlier by clicking <b>Save</b>.  Note: If another user deploys a different copy of the layout, the one you see in this area might not match the current version.',
		'saveBtn'	=> 'Click <b>Save</b> to preserve the changes you make to the layout. If you do not deploy the changes before you leave Studio, the changes will not be displayed in the module.  When you return to Studio to edit the layout, you will view the layout with the preserved changes. The layout will not be displayed in the module until you click <b>Save & Deploy</b>.',
		'publishBtn'=> 'Click <b>Save & Deploy</b> to deploy the layout.<br><br>After deployment, the layout will immediately be displayed in the module.',
		'toolbox'	=> 'The <b>Toolbox</b> contains a variety of useful tools for editing layouts, including the Trash, additional layout elements and the set of available fields.<br/><br/>Any of the elements and fields can be dragged and dropped into the layout, and any layout elements and fields can be dragged and dropped into the Trash.<br/><br/>Dragging a new row or new panel element to the layout will add it in to the layout where it is dropped.<br/><br/>A filler field creates blank space in the layout where it is placed.<br/><br/>Drag and drop any of the available fields onto a field in a panel to swap the two.',
		'panels'	=> 'This area displays how your layout will appear within the module when it is deployed.<br/><br/>You can reposition fields, rows and panels by dragging and dropping them in the desired location.<br/><br/>Remove elements by dragging and dropping them in the Trash in the Toolbox, or add new elements and fields by dragging them from the Toolbox and dropping them in the desired location in the layout.',
		'delete'	=> 'Drag and drop any element here to remove it from the layout',
	),
	'fieldsEditor'=>array(
		'default'	=> 'All of the fields that are available for the current module are listed here.<br><br> The standard fields that are included in the module by default appear in the <b>Default</b> area.<br><br>Custom fields that were created for the module appear in the <b>Custom</b> area.<br><br>To edit fields, click the <b>Field Name</b>.  Make changes within the <b>Properties</b> form in the right-hand pane, and click <b>Save</b>.  <br/><br/>While viewing the field properties, you can quickly create a new field with similar properties by clicking <b>Clone</b>.  Make changes, as necessary, and then click <b>Save</b>.<br><br>To create a new field, click <b>Add Field</b>. Enter properties for the field in the <b>Properties</b> form, and click <b>Save</b>. The new field will appear in the <b>Custom</b> area.<br><br>To change labels for any of the fields, click <b>Edit Labels</b>.',
	),
	'exportcustom'=>array(
	    'exportHelp'=>'Export customizations made in Studio by creating packages that can be uploaded into another Sugar instance through the <b>Module Loader</b>.<br><br>  First, provide a <b>Package Name</b>.  You can provide <b>Author</b> and <b>Description</b> information for package as well.<br><br>Select the module(s) that contain the customizations you wish to export. Only modules containing customizations will appear for you to select.<br><br>Then click <b>Export</b> to create a .zip file for the package containing the customizations.',
	    'exportCustomBtn'=>'Click <b>Export</b> to create a .zip file for the package containing the customizations that you wish to export.',
	    'name'=>'This is the <b>Name</b> of the package. This name will be displayed during installation.',
	    'author'=>'This is the <b>Author</b> that is displayed during installation as the name of the entity that created the package. The Author can be either an individual or a company.',
	    'description'=>'This is the <b>Description</b> of the package that is displayed during installation.',
	),
	'studioWizard'=>array(
		'mainHelp' 	=> 'Welcome to the <b>Developer Tools</b> area. <br/><br/>Use the tools within this area to create and manage standard and custom modules and fields.',
		'studioBtn'	=> 'Use <b>Studio</b> to customize installed modules.',
		'mbBtn'		=> 'Use <b>Module Builder</b> to create new modules.',
		'sugarPortalBtn' => 'Use <b>Sugar Portal Editor</b> to manage and customize the Sugar Portal.',
		'dropDownEditorBtn' => 'Use <b>Dropdown Editor</b> to add and edit global dropdowns for the application.',
		'appBtn' 	=> 'Application mode is where you can customize various properties of the program, such as how many TPS reports are displayed on the homepage',
		'backBtn'	=> 'Return to the previous step.',
		'studioHelp'=> 'In <b>Studio</b>, you can change how information is displayed, determine what data is available and create custom data fields for <i>installed</i> modules.',
		'moduleBtn'	=> 'Click to edit this module.',
		'moduleHelp'=> 'Select which module component you would like to edit.',
		'fieldsBtn'	=> 'Determine what information can be stored in the module by controlling the <b>Fields</b> in the module. <br/><br/>You can edit and create new fields to store information.',
		'labelsBtn' => 'Edit the <b>Labels</b> that display for the fields in the module.'	,
		'layoutsBtn'=> 'Edit the following module <b>Layouts</b>: Edit View, Detail View, List View and Search View.',
		'subpanelBtn'=> 'Determine what information is displayed in the <b>Subpanels</b> for this module.',
		'layoutsHelp'=> 'Select a <b>Layout</b> to edit.',
		'subpanelHelp'=> 'Select a <b>Subpanel</b> to edit.',
		'labelsHelp'=> 'The display names for the <b>Labels</b> for all of the fields that are available in the current module are displayed in the right-hand column.<br><br>Edit the name by clicking within the field, entering a new name and clicking <b>Save</b>.',
        'newPackage'=>'Click <b>New Package</b> to create a new package.',
        'exportBtn' => 'Click <b>Export Customizations</b> to create a package containing customizations made in Studio for specific modules.',
        'mbHelp'    => '<b>Welcome to Module Builder.</b><br/><br/>Use <b>Module Builder</b> to create packages containing custom modules based on standard or custom objects. <br/><br/>To begin, click <b>New Package</b> to create a new package, or select a package to edit.',
	    'viewBtnEditView' => 'Edit the module\'s <b>EditView</b> layout.',
	    'viewBtnDetailView' => 'Edit the module\'s <b>Detail View</b> layout.',
	    'viewBtnListView' => 'Edit the module\'s <b>List View</b> layout.',
	    'searchBtn' => 'Edit the module\'s <b>Search</b> layouts.',
		'viewBtnQuickCreate' =>  'Edit the module\'s <b>Quick Create</b> layout.',
	    'searchHelp'=> 'Select a <b>Search Layout</b> to edit.',
	    'BasicSearchBtn' => 'Edit the <b>Basic Search</b> form that appears in the Basic Search tab in the Search area for the module.',
	    'AdvancedSearchBtn' => 'Edit the <b>Advanced Search</b> form that appears in the Advanced Search tab in the Search area for the module.',
	    'portalHelp' => 'Manage and customize the <b>Sugar Portal</b>.',
	    'SPUploadCSS' => 'Upload a <b>Style Sheet</b> for the Sugar Portal.',
	    'SPSync' => '<b>Sync</b> customizations to the Sugar Portal instance.',
	    'Layouts' => 'Edit the <b>Layouts</b> of the Sugar Portal modules.',
	    'portalLayoutHelp' => 'The modules within the Sugar Portal appear in this area.<br><br>Select a module to edit the <b>Layouts</b>.',
		'relationshipsHelp' => 'You can relate this module to other modules in the same package or to modules already installed in the application.<br/><br/>To create a new relationship, click <b>Add Relationship</b>. The relationship properties are displayed in the form in the right-hand pane. Use the <b>Relate To</b> drop down list to select the module to which to relate the current module.<br><br>Provide a <b>Label</b> that will display as title of the sub-panel for the related module.<br><br>The relationships between the modules\' records will be managed through sub-panels that appear under the Detail Views of the modules.<br><br>For the sub-panel of the related module, you might be able to select different sub-panel layouts, depending on which module is selected for the relationship.<br/><br/> Click <b>Save</b> to create the relationship. Click <b>Delete</b> to delete the selected relationship.<br/><br/>To edit an existing relationship, click the <b>Relationship Name</b>, and edit the properties within the right-hand pane.',
		'editDropDownBtn' => 'Edit a global Dropdown',
		'addDropDownBtn' => 'Add a new global Dropdown',
	),
	'portalSync'=>array(
	    'default' => 'Enter the <b>Sugar Portal URL</b> of the portal instance to update, and click <b>Go</b>.<br><br>Enter a valid Sugar user name and password, and then click <b>Begin Sync</b>.<br><br>The customizations made to the Sugar Portal <b>Layouts</b>, along with the <b>Style Sheet</b> if one was uploaded, will be transferred to specified the portal instance.',
	),
	'portalStyle'=>array(
	    'default' => 'From here you can customize the look of the Sugar Portal.',
	),
),

'assistantHelp'=>array(
	'package'=>array(
			//custom begin
			'nopackages'=>'To get started on a project, click <b>New Package</b> to create a new package to house your custom module(s). <br/><br/>Each package can contain one or more modules.<br/><br/>For instance, you might want to create a package containing one custom module that is related to the standard Accounts module. Or, you might want to create a package containing several new modules that work together as a project and that are related to each other and to other modules already in the application.',
			'somepackages'=>'A <b>package</b> acts as a container for custom modules, all of which are part of one project. The package can contain one or more custom <b>modules</b> that can be related to each other or to other modules in the application.<br/><br/>After creating a package for your project, you can create modules for the package right away, or you can return to the Module Builder at a later time to complete the project.<br><br>When the project is complete, you can <b>Deploy</b> the package to install the custom modules within the application.',
			'afterSave'=>'Your new package should contain at least one module. You can create one or more custom modules for the package.<br/><br/>Click <b>New Module</b> to create a custom module for this package.<br/><br/> After creating at least one module, you can publish or deploy the package to make it available for your instance and/or other users\' instances.<br/><br/> To deploy the package in one step within your Sugar instance, click <b>Deploy</b>.<br><br>Click <b>Publish</b> to save the package as a .zip file. After the .zip file is saved to your system, use the <b>Module Loader</b> to upload and install the package within your Sugar instance.  <br/><br/>You can distribute the file to other users to upload and install within their own Sugar instances.',
			'create'=>'A <b>package</b> acts as a container for custom modules, all of which are part of one project. The package can contain one or more custom <b>modules</b> that can be related to each other or to other modules in the application.<br/><br/>After creating a package for your project, you can create modules for the package right away, or you can return to the Module Builder at a later time to complete the project.',
			),
	'main'=>array(
		'welcome'=>'Use the <b>Developer Tools</b> to create and manage standard and custom modules and fields. <br/><br/>To manage modules in the application, click <b>Studio</b>. <br/><br/>To create custom modules, click <b>Module Builder</b>.',
		'studioWelcome'=>'All of the currently installed modules, including standard and module-loaded objects, are customizable within Studio.'
	),
	'module'=>array(
		'somemodules'=>"Since the current package contains at least one module, you can <b>Deploy</b> the modules in the package within your Sugar instance or <b>Publish</b> the package to be installed in the current Sugar instance or another instance using the <b>Module Loader</b>.<br/><br/>To install the package directly within your Sugar instance, click <b>Deploy</b>.<br><br>To create a .zip file for the package that can be loaded and installed within the current Sugar instance and other instances using the <b>Module Loader</b>, click <b>Publish</b>.<br/><br/> You can build the modules for this package in stages, and publish or deploy when you are ready to do so. <br/><br/>After publishing or deploying a package, you can make changes to the package properties and customize the modules further.  Then re-publish or re-deploy the package to apply the changes." ,
		'editView'=> 'Here you can edit the existing fields. You can remove any of the existing fields or add available fields in the left panel.',
		'create'=>'When choosing the type of <b>Type</b> of module that you wish to create, keep in mind the types of fields you would like to have within the module. <br/><br/>Each module template contains a set of fields pertaining to the type of module described by the title.<br/><br/><b>Basic</b> - Provides basic fields that appear in standard modules, such as the Name, Assigned to, Team, Date Created and Description fields.<br/><br/> <b>Company</b> - Provides organization-specific fields, such as Company Name, Industry and Billing Address.  Use this template to create modules that are similar to the standard Accounts module.<br/><br/> <b>Person</b> - Provides individual-specific fields, such as Salutation, Title, Name, Address and Phone Number.  Use this template to create modules that are similar to the standard Contacts and Leads modules.<br/><br/><b>Issue</b> - Provides case- and bug-specific fields, such as Number, Status, Priority and Description.  Use this template to create modules that are similar to the standard Cases and Bug Tracker modules.<br/><br/>Note: After you create the module, you can edit the labels of the fields provided by the template, as well as create custom fields to add to the module layouts.',
		'afterSave'=>'Customize the module to suit your needs by editing and creating fields, establishing relationships with other modules and arranging the fields within the layouts.<br/><br/>To view the template fields and manage custom fields within the module, click <b>View Fields</b>.<br/><br/>To create and manage relationships between the module and other modules, whether modules already in the application or other custom modules within the same package, click <b>View Relationships</b>.<br/><br/>To edit the module layouts, click <b>View Layouts</b>. You can change the Detail View, Edit View and List View layouts for the module just as you would for modules already in the application within Studio.<br/><br/> To create a module with the same properties as the current module, click <b>Duplicate</b>.  You can further customize the new module.',
		'viewfields'=>'The fields in the module can be customized to suit your needs.<br/><br/>You can not delete standard fields, but you can remove them from the appropriate layouts within the Layouts pages. <br/><br/>You can edit the labels of the standard fields. The other properties of the standard fields are not editable. However, you can quickly create new fields that have similar properties by clicking a field name and then clicking <b>Clone</b> in the <b>Properties</b> form.  Enter any new properties, and then click <b>Save</b>.<br/><br/>If you are customizing a new module, once the module has been installed, not all of the field properties can be edited.  Set all of the properties for the standard fields and custom fields before you publish and install the package containing the custom module.',
		'viewrelationships'=>'You can create many-to-many relationships between the current module and other modules in the package, and/or between the current module and modules already installed in the application.<br><br> To create one-to-many and one-to-one relationships, create <b>Relate</b> and <b>Flex Relate</b> fields for the modules.',
		'viewlayouts'=>'You can control what fields are available for capturing data within the <b>Edit View</b>.  You can also control what data displays within the <b>Detail View</b>.  The views do not have to match. <br/><br/>The Quick Create form is displayed when the <b>Create</b> is clicked in a module subpanel. By default, the <b>Quick Create</b> form layout is the same as the default <b>Edit View</b> layout. You can customize the Quick Create form so that it contains less and/or different fields than the Edit View layout. <br><br>You can determine the module security using Layout customization along with <b>Role Management</b>.<br><br>',
		'existingModule' =>'After creating and customizing this module, you can create additional modules or return to the package to <b>Publish</b> or <b>Deploy</b> the package.<br><br>To create additional modules, click <b>Duplicate</b> to create a module with the same properties as the current module, or navigate back to the package, and click <b>New Module</b>.<br><br> If you are ready to <b>Publish</b> or <b>Deploy</b> the package containing this module, navigate back to the package to perform these functions. You can publish and deploy packages containing at least one module.',
		'labels'=> 'The labels of the standard fields as well as custom fields can be changed.  Changing field labels will not affect the data stored in the fields.',
	),
	'listViewEditor'=>array(
		'modify'	=> 'There are three columns displayed to the left. The "Default" column contains the fields that are displayed in a list view by default, the "Available" column contains fields that a user can choose to use for creating a custom list view, and the "Hidden" column contains fields available for you as an admin to either add to the default or Available columns for use by users but are currently disabled.',
		'savebtn'	=> 'Clicking <b>Save</b> will save all changes and make them active',
		'Hidden' 	=> 'Hidden fields are fields that are not currently available to users for use in list views.',
		'Available' => 'Available fields are fields that are not shown by default, but can be enabled by users.',
		'Default'	=> 'Default fields are displayed to users who have not created custom list view settings.'
	),
	'searchViewEditor'=>array(
		'modify'	=> 'There are two columns displayed to the left. The "Default" column contains the fields that will be displayed in the search view, and the "Hidden" column contains fields available for you as an admin to add to the view.',
		'savebtn'	=> 'Clicking <b>Save & Deploy</b> will save all changes and make them active',
		'Hidden' 	=> 'Hidden fields are fields that will not be shown in the search view.',
		'Default'	=> 'Default fields will be shown in the search view.',
		'multiselect_field_warning'=>'<br>Please be aware that if you have any multi-select fields in this module, adding them to the "Default" section of the search layout may cause performance issues.<br>'
	),
	'layoutEditor'=>array(
		'default'	=> 'There are two columns displayed to the left. The right-hand column, labeled Current Layout or Layout Preview, is where you change the module layout. The left-hand column, entitled Toolbox, contains useful elements and tools for use when editing the layout. <br/><br/>If the layout area is titled Current Layout then you are working on a copy of the layout currently used by the module for display.<br/><br/>If it is titled Layout Preview then you are working on a copy created earlier by a click on the Save button, that might have already been changed from the version seen by users of this module.',
		'saveBtn'	=> 'Clicking this button saves the layout so that you can preserve your changes. When you return to this module you will start from this changed layout. Your layout however will not be seen by users of the module until you click the Save and Publish button.',
		'publishBtn'=> 'Click this button to deploy the layout. This means that this layout will immediately be seen by users of this module.',
		'toolbox'	=> 'The toolbox contains a variety of useful features for editing layouts, including a trash area, a set of additional elements and a set of available fields. Any of these can be dragged and dropped onto the layout.',
		'panels'	=> 'This area shows how your layout will look to users of this module when it is depolyed.<br/><br/>You can reposition elements such as fields, rows and panels by dragging and dropping them; delete elements by dragging and dropping them on the trash area in the toolbox, or add new elements by dragging them from the toolbox and dropping them on to the layout in the desired position.'
	),
	'dropdownEditor'=>array(
		'default'	=> 'There are two columns displayed to the left. The right-hand column, labeled Current Layout or Layout Preview, is where you change the module layout. The left-hand column, entitled Toolbox, contains useful elements and tools for use when editing the layout. <br/><br/>If the layout area is titled Current Layout then you are working on a copy of the layout currently used by the module for display.<br/><br/>If it is titled Layout Preview then you are working on a copy created earlier by a click on the Save button, that might have already been changed from the version seen by users of this module.',
		'dropdownaddbtn'=> 'Clicking this button adds a new item to the dropdown.',
	),
	'exportcustom'=>array(
	    'exportHelp'=>'Export customizations made in Studio by creating packages that can be uploaded into another Sugar instance through the <b>Module Loader</b>.<br><br>  First, provide a <b>Package Name</b>.  You can provide <b>Author</b> and <b>Description</b> information for package as well.<br><br>Select the module(s) that contain the customizations you wish to export. Only modules containing customizations will appear for you to select.<br><br>Then click <b>Export</b> to create a .zip file for the package containing the customizations.',
	    'exportCustomBtn'=>'Click <b>Export</b> to create a .zip file for the package containing the customizations that you wish to export.
',
	    'name'=>'This is the <b>Name</b> of the package. This name will be displayed during installation.',
	    'author'=>'This is the <b>Author</b> that is displayed during installation as the name of the entity that created the package. The Author can be either an individual or a company.
',
	    'description'=>'This is the <b>Description</b> of the package that is displayed during installation.',
	),
	'studioWizard'=>array(
		'mainHelp' 	=> 'Welcome to the <b>Developer Tools</b1> area. <br/><br/>Use the tools within this area to create and manage standard and custom modules and fields.',
		'studioBtn'	=> 'Use <b>Studio</b> to customize installed modules by changing the field arrangement, selecting what fields are available and creating custom data fields.',
		'mbBtn'		=> 'Use <b>Module Builder</b> to create new modules.',
		'appBtn' 	=> 'Use Application mode to customize various properties of the program, such as how many TPS reports are displayed on the homepage',
		'backBtn'	=> 'Return to the previous step.',
		'studioHelp'=> 'Use <b>Studio</b> to customize installed modules.',
		'moduleBtn'	=> 'Click to edit this module.',
		'moduleHelp'=> 'Select the module component that you would like to edit',
		'fieldsBtn'	=> 'Edit what information is stored in the module by controlling the <b>Fields</b> in the module.<br/><br/>You can edit and create custom fields here.',
		'labelsBtn' => 'Click <b>Save</b> to save your custom labels.'	,
		'layoutsBtn'=> 'Customize the <b>Layouts</b> of the Edit, Detail, List and search views.',
		'subpanelBtn'=> 'Edit what information is shown in this modules subpanels.',
		'layoutsHelp'=> 'Select a <b>Layout to edit</b>.<br/<br/>To change the layout that contains data fields for entering data, click <b>Edit View</b>.<br/><br/>To change the layout that displays the data entered into the fields in the Edit View, click <b>Detail View</b>.<br/><br/>To change the columns which appear in the default list, click <b>List View</b>.<br/><br/>To change the Basic and Advanced search form layouts, click <b>Search</b>.',
		'subpanelHelp'=> 'Select a <b>Subpanel</b> to edit.',
		'searchHelp' => 'Select a <b>Search</b> layout to edit.',
		'labelsBtn'	=> 'Edit the <b>Labels</b> to display for values in this module.',
        'newPackage'=>'Click <b>New Package</b> to create a new package.',
        'mbHelp'    => '<b>Welcome to Module Builder.</b><br/><br/>Use <b>Module Builder</b> to create packages containing custom modules based on standard or custom objects. <br/><br/>To begin, click <b>New Package</b> to create a new package, or select a package to edit.<br/><br/> A <b>package</b> acts as a container for custom modules, all of which are part of one project. The package can contain one or more custom modules that can be related to each other or to modules in the application. <br/><br/>Examples: You might want to create a package containing one custom module that is related to the standard Accounts module. Or, you might want to create a package containing several new modules that work together as a project and that are related to each other and to modules in the application.',
        'exportBtn' => 'Click <b>Export Customizations</b> to create a package containing customizations made in Studio for specific modules.',
	),


),
//HOME
'LBL_HOME_EDIT_DROPDOWNS'=>'Edit Dropdowns',

//ASSISTANT
'LBL_AS_SHOW' => 'Show Assistant in future.',
'LBL_AS_IGNORE' => 'Ignore Assistant in future.',
'LBL_AS_SAYS' => 'Assistant Says:',


//STUDIO2
'LBL_MODULEBUILDER'=>'Module Builder',
'LBL_STUDIO' => 'Studio',
'LBL_DROPDOWNEDITOR' => 'Dropdown Editor',
'LBL_DEVELOPER_TOOLS' => 'Developer Tools',
'LBL_SUGARPORTAL' => 'Sugar Portal Editor',
'LBL_SYNCPORTAL' => 'Sync Portal',
'LBL_PACKAGE_LIST' => 'Package List',
'LBL_HOME' => 'Home',
'LBL_NONE'=>'-None-',

'LBL_ADD_FIELDS'=>'Add Custom Fields',
'LBL_AVAILABLE_SUBPANELS'=>'Available Subpanels',
'LBL_ADVANCED'=>'Advanced',
'LBL_ADVANCED_SEARCH'=>'Advanced Search',
'LBL_BASIC'=>'Basic',
'LBL_BASIC_SEARCH'=>'Basic Search',
'LBL_CURRENT_LAYOUT'=>'Current Layout',
'LBL_DISPLAY_HTML'=>'Display HTML Code',
'LBL_DETAILVIEW'=>'DetailView',
'LBL_DROP_HERE' => '[Drop Here]',
'LBL_EDIT'=>'Edit',
'LBL_EDIT_LAYOUT'=>'Edit Layout',
'LBL_EDIT_ROWS'=>'Edit Rows',
'LBL_EDIT_COLUMNS'=>'Edit Columns',
'LBL_EDIT_LABELS'=>'Edit Labels',
'LBL_EDIT_FIELDS'=>'Edit Custom Fields',
'LBL_EDIT_PORTAL'=>'Edit Portal for ',
'LBL_EDIT_FIELDS'=>'Edit Fields',
'LBL_EDITVIEW'=>'EditView',
'LBL_FILLER'=>'(filler)',
'LBL_FIELDS'=>'Fields',
'LBL_FAILED_TO_SAVE' => 'Failed To Save',
'LBL_FAILED_PUBLISHED' => 'Failed to Publish',
'LBL_LAYOUT_PREVIEW'=>'Layout Preview',
'LBL_LAYOUTS'=>'Layouts',
'LBL_LISTVIEW'=>'ListView',
'LBL_MODULES'=>'Modules',
'LBL_MODULE_TITLE' => 'Studio',
'LBL_NEW_PACKAGE' => 'New Package',
'LBL_NEW_PANEL'=>'New Panel',
'LBL_NEW_ROW'=>'New Row',
'LBL_PUBLISHING' => 'Publishing ...',
'LBL_PUBLISHED' => 'Published',
'LBL_RELATIONSHIPS'=>'Relationships',
'LBL_SELECT_FILE'=> 'Select File',
'LBL_SAVE_LAYOUT'=> 'Save Layout',
'LBL_SELECT_A_SUBPANEL' => 'Select a Subpanel',
'LBL_SELECT_SUBPANEL' => 'Select Subpanel',
'LBL_SUBPANELS' => 'Subpanels',
'LBL_SUBPANEL' => 'Subpanel',
'LBL_SEARCH_FORMS' => 'Search Forms',
'LBL_SEARCH'=>'Search',
'LBL_STAGING_AREA' => 'Staging Area (drag and drop items here)',
'LBL_SUGAR_FIELDS_STAGE' => 'Sugar Fields (click items to add to staging area)',
'LBL_SUGAR_BIN_STAGE' => 'Sugar Bin (click items to add to staging area)',
'LBL_TOOLBOX' => 'Toolbox',
'LBL_VIEW_SUGAR_FIELDS' => 'View Sugar Fields',
'LBL_VIEW_SUGAR_BIN' => 'View Sugar Bin',
'LBL_QUICKCREATE' => 'QuickCreate',
'LBL_EDIT_DROPDOWNS' => 'Edit a Global Dropdown',
'LBL_ADD_DROPDOWN' => 'Add a new Global Dropdown',
'LBL_BLANK' => '-blank-',
'LBL_TAB_ORDER' => 'Tab Order',

'LBL_DROPDOWN_TITLE_NAME' => 'Dropdown Name',
'LBL_DROPDOWN_LANGUAGE' => 'Dropdown Language',
'LBL_DROPDOWN_ITEMS' => 'Dropdown Items',
'LBL_DROPDOWN_ITEM_NAME' => 'Item Name',
'LBL_DROPDOWN_ITEM_LABEL' => 'Display Label',

//STUDIO QUESTIONS
'LBL_QUESTION_FUNCTION' => 'Select a function or component.',
'LBL_QUESTION_MODULE1' => 'Select a module.',
'LBL_QUESTION_EDIT' => 'Select a module to edit.',
'LBL_QUESTION_LAYOUT' => 'Select a layout to edit.',
'LBL_QUESTION_SUBPANEL' => 'Select a subpanel to edit.',
'LBL_QUESTION_SEARCH' => 'Select a search layout to edit.',
'LBL_QUESTION_MODULE' => 'Select a module component to edit.',
'LBL_QUESTION_PACKAGE' => 'Select a package to edit, or create a new package.',
'LBL_QUESTION_EDITOR' => 'Select a tool.',
'LBL_QUESTION_DROPDOWN' => 'Select a dropdown to edit, or create a new dropdown.',
//CUSTOM FIELDS
'LBL_RELATE_TO'=>'Relate To',
'LBL_NAME'=>'Name',
'LBL_LABELS'=>'Labels',
'LBL_MASS_UPDATE'=>'Mass Update',
'LBL_AUDITED'=>'Audit',
'LBL_CUSTOM_MODULE'=>'Module',
'LBL_DEFAULT_VALUE'=>'Default Value',
'LBL_REQUIRED'=>'Required',
'LBL_DATA_TYPE'=>'Type',
'LBL_HCUSTOM'=>'CUSTOM',
'LBL_HDEFAULT'=>'DEFAULT',
'LBL_LANGUAGE'=>'Language:',


//SECTION
'LBL_SECTION_EDLABELS' => 'Edit Labels',
'LBL_SECTION_PACKAGES' => 'Packages',
'LBL_SECTION_PACKAGE' => 'Package',
'LBL_SECTION_MODULES' => 'Modules',
'LBL_SECTION_PORTAL' => 'Portal',
'LBL_SECTION_DROPDOWNS' => 'Dropdowns',
'LBL_SECTION_PROPERTIES' => 'Properties',
'LBL_SECTION_DROPDOWNED' => 'Dropdown Editor',
'LBL_SECTION_HELP' => 'Help',
'LBL_SECTION_ACTION' => 'Action',
'LBL_SECTION_MAIN' => 'Main',
'LBL_SECTION_EDPANELLABEL' => 'Edit Panel Label',
'LBL_SECTION_FIELDEDITOR' => 'Field Editor',
'LBL_SECTION_DEPLOY' => 'Deploy',
'LBL_SECTION_MODULE' => 'Module',
//WIZARDS

//LIST VIEW EDITOR
'LBL_DEFAULT'=>'Default',
'LBL_HIDDEN'=>'Hidden',
'LBL_AVAILABLE'=>'Available',
'LBL_LISTVIEW_DESCRIPTION'=>'There are three columns displayed below. The <b>Default</b> column contains fields that are displayed in a list view by default.  The <b>Additional</b> column contains fields that a user can choose to use for creating a custom view.  The <b>Available</b> column displays fields availabe for you as an admin to add to the Default or Additional columns for use by users.',
'LBL_LISTVIEW_EDIT'=>'List View Editor',

//Manager Backups History
'LBL_MB_PREVIEW'=>'Preview',
'LBL_MB_RESTORE'=>'Restore',
'LBL_MB_DELETE'=>'Delete',
'LBL_MB_COMPARE'=>'Compare',

//END WIZARDS

//BUTTONS
'LBL_BTN_ADD'=>'Add',
'LBL_BTN_SAVE'=>'Save',
'LBL_BTN_SAVE_CHANGES'=>'Save Changes',
'LBL_BTN_DONT_SAVE'=>'Discard Changes',
'LBL_BTN_CANCEL'=>'Cancel',
'LBL_BTN_UPLOAD'=>'Upload',
'LBL_BTN_SAVEPUBLISH'=>'Save & Deploy',
'LBL_BTN_NEXT'=>'Next',
'LBL_BTN_BACK'=>'Back',
'LBL_BTN_CLONE'=>'Clone',
'LBL_BTN_ADDCOLS'=>'Add Columns',
'LBL_BTN_ADDROWS'=>'Add Rows',
'LBL_BTN_ADDFIELD'=>'Add Field',
'LBL_BTN_ADDDROPDOWN'=>'Add Dropdown',
'LBL_BTN_EDLABELS'=>'Edit Labels',
'LBL_BTN_UNDO'=>'Undo',
'LBL_BTN_REDO'=>'Redo',
'LBL_BTN_ADDCUSTOMFIELD'=>'Add Custom Field',
'LBL_BTN_EXPORT'=>'Export Customizations',
'LBL_BTN_DUPLICATE'=>'Duplicate',
'LBL_BTN_PUBLISH'=>'Publish',
'LBL_BTN_DEPLOY'=>'Deploy',
'LBL_BTN_EXP'=>'Export',
'LBL_BTN_DELETE'=>'Delete',
'LBL_BTN_VIEW_LAYOUTS'=>'View Layouts',
'LBL_BTN_VIEW_FIELDS'=>'View Fields',
'LBL_BTN_VIEW_RELATIONSHIPS'=>'View Relationships',
'LBL_BTN_ADD_RELATIONSHIP'=>'Add Relationship',
//TABS


//ERRORS
'ERROR_ALREADY_EXISTS'=> 'Error: Field Already Exists',
'ERROR_INVALID_KEY_VALUE'=> "Error: Invalid Key Value: [']",





































//PACKAGE AND MODULE BUILDER
'LBL_PACKAGE_NAME'=>'Package Name:',
'LBL_MODULE_NAME'=>'Module Name:',
'LBL_AUTHOR'=>'Author:',
'LBL_DESCRIPTION'=>'Description:',
'LBL_KEY'=>'Key:',
'LBL_ADD_README'=>' Readme',
'LBL_MODULES'=>'Modules:',
'LBL_LAST_MODIFIED'=>'Last Modified:',
'LBL_NEW_MODULE'=>'New Module',
'LBL_LABEL'=>'Label:',
'LBL_LABEL_TITLE'=>'Label',
'LBL_WIDTH'=>'Width',
'LBL_PACKAGE'=>'Package:',
'LBL_TYPE'=>'Type:',
'LBL_TEAM_SECURITY'=>'Team Security',
'LBL_ASSIGNABLE'=>'Assignable',
'LBL_PERSON'=>'Person',
'LBL_COMPANY'=>'Company',
'LBL_ISSUE'=>'Issue',
'LBL_NAV_TAB'=>'Navigation Tab',
'LBL_CREATE'=>'Create',
'LBL_LIST'=>'List',
'LBL_LIST_VIEW'=>'List View',
'LBL_HISTORY'=>'History',
'LBL_ACTIVITIES'=>'Activities',
'LBL_SEARCH'=>'Search',
'LBL_NEW'=>'New',
'LBL_TYPE_BASIC'=>'basic',
'LBL_TYPE_COMPANY'=>'company',
'LBL_TYPE_PERSON'=>'person',
'LBL_TYPE_ISSUE'=>'issue',
'LBL_RSUB'=>'This is the subpanel that will be displayed in your module',
'LBL_MSUB'=>'This is the subpanel that your module provides to the related module for display',

//EXPORT CUSTOMS
'LBL_EC_TITLE'=>'Export Customizations',
'LBL_EC_NAME'=>'Package Name:',
'LBL_EC_AUTHOR'=>'Author:',
'LBL_EC_DESCRIPTION'=>'Description:',
'LBL_EC_KEY'=>'Key:',
'LBL_EC_CHECKERROR'=>'Please select a module.',
'LBL_EC_CUSTOMFIELD'=>'customized field(s)',
'LBL_EC_CUSTOMLAYOUT'=>'customized layout(s)',
'LBL_EC_NOCUSTOM'=>'No modules have been customized.',
'LBL_EC_EMPTYCUSTOM'=>'has empty customizations.',
'LBL_EC_EXPORTBTN'=>'Export',
'LBL_MODULE_DEPLOYED' => 'Module has been deployed.',
'LBL_UNDEFINED' => 'undefined',

//AJAX STATUS
'LBL_AJAX_FAILED_DATA' => 'Failed to retrieve data',
'LBL_AJAX_TIME_DEPENDENT' => 'A time dependent action is in progress please wait and try again in a few seconds',
'LBL_AJAX_LOADING' => 'Loading...',
'LBL_AJAX_DELETING' => 'Deleting...',
'LBL_AJAX_BUILDPROGRESS' => 'Build In Progress...',
'LBL_AJAX_DEPLOYPROGRESS' => 'Deploy In Progress...',

//JS
'LBL_JS_REMOVE_PACKAGE' => 'Are you sure you wish to remove this package? This will permanently delete all files associated with this package.',

'LBL_DEPLOY_IN_PROGRESS' => 'Deploying Package',
'LBL_JS_VALIDATE_NAME'=>'Name - Must be alphanumeric with no spaces and starting with a letter',
'LBL_JS_VALIDATE_LABEL'=>'Please enter a label that will be used as the Display Name for this module',
'LBL_JS_VALIDATE_TYPE'=>'Please select the type of module you wish to build from the list above',
'LBL_JS_VALIDATE_REL_NAME'=>'Name - Must be alphanumeric with no spaces',
'LBL_JS_VALIDATE_REL_LABEL'=>'Label - please add a label that will be displayed above the subpanel',

//CONFIRM
'LBL_CONFIRM_FIELD_DELETE'=>'Deleting a custom field will delete all the data related to the custom field. You will still need to remove the field from any layout you have added it to',
'LBL_CONFIRM_RELATIONSHIP_DELETE'=>'Are you sure you wish to delete this relationship?',
'LBL_CONFIRM_DONT_SAVE' => 'Changes have been made since you last saved, would you like to save?',
'LBL_CONFIRM_DONT_SAVE_TITLE' => 'Save Changes?',
);

