<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');
/**
 * SugarCRM is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004 - 2007 SugarCRM Inc.
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 * 
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 * 
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU General Public License version 3.
 * 
 * In accordance with Section 7(b) of the GNU General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * SugarCRM" logo. If the display of the logo is not reasonably feasible for
 * technical reasons, the Appropriate Legal Notices must display the words
 * "Powered by SugarCRM".
 */



require_once ('include/utils/file_utils.php');
class Configurator {
	var $config = '';
	var $override = '';
	var $allow_undefined = array ('stack_trace_errors', 'export_delimiter', 'use_real_names', 'developerMode');
	var $errors = array ('main' => '');
	function Configurator() {
		$this->loadConfig();
	}

	function loadConfig() {

		global $sugar_config;
		$this->config = $sugar_config;
	}

	function populateFromPost() {
		foreach ($_POST as $key => $value) {
			if (isset ($this->config[$key]) || in_array($key, $this->allow_undefined)) {
				$this->config[$key] = $_POST[$key];
			}
		}
	}


	function handleOverride() {
		global $sugar_config, $sugar_version;

		$this->readOverride();
		foreach ($this->config as $key => $value) {

			if ((in_array($key, $this->allow_undefined) || isset ($sugar_config[$key]) && strcmp("{$sugar_config[$key]}", "{$value}") != 0)) {
				if (strcmp("$value", 'true') == 0) {
					$value = true;
					$this->config[$key] = $value;
				}
				if (strcmp("$value", 'false') == 0) {

					$value = false;
					$this->config[$key] = false;
				}
				$this->replaceOverride('sugar_config', $key, $value);
			}
		}
		sugar_cache_put('sugar_config', $this->config);
		$GLOBALS['sugar_config'] = $this->config;
		$this->saveOverride();
	}

	function saveConfig() {
		$this->saveImages();
		$this->populateFromPost();
		$this->handleOverride();
	}

	function readOverride() {
		$this->override = '';
		if (file_exists('config_override.php')) {
			$this->override = file_get_contents('config_override.php');
		} else {
			$this->override = "<?php\n\n?>";
		}
	}
	function saveOverride() {
		$fp = fopen('config_override.php', 'w');
		fwrite($fp, $this->override);
		
		fclose($fp);
	}

	function overrideClearDuplicates($array_name, $key) {

		if (!empty ($this->override)) {
			$pattern = '/.*CONFIGURATOR[^\$]*\$'.$array_name.'\[\''.$key.'\'\][\ ]*=[\ ]*[^;]*;\n/';

			$this->override = preg_replace($pattern, '', $this->override);
		} else {
			$this->override = "<?php\n\n?>";
		}

	}

	function replaceOverride($array_name, $key, $value) {
		$GLOBALS[$array_name][$key] = $value;
		$this->overrideClearDuplicates($array_name, $key);
		$new_entry = '/***CONFIGURATOR***/'.override_value_to_string($array_name, $key, $value);
		$this->override = str_replace('?>', "$new_entry\n?>", $this->override);
	}

	function restoreConfig() {
		$this->readOverride();
		$this->overrideClearDuplicates('sugar_config', '[a-zA-Z0-9\_]+');
		$this->saveOverride();
		ob_clean();
		header('Location: index.php?action=EditView&module=Configurator');
	}

	function saveImages() {
		if (!empty ($_POST['company_logo'])) {
			$this->saveCompanyLogo($_POST['company_logo']);
		}





	}
	function saveCompanyLogo($path) {

			copy($path, 'include/images/company_logo.png');
			//copy to each themes dir
			foreach (unserialize($_SESSION['avail_themes']) as $dir => $name) {
				copy('include/images/company_logo.png', 'themes/'.$dir.'/images/company_logo.png');
			}

	}
	






	
}
?>
