<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');
/**
 * SugarCRM is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004 - 2007 SugarCRM Inc.
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 * 
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 * 
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU General Public License version 3.
 * 
 * In accordance with Section 7(b) of the GNU General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * SugarCRM" logo. If the display of the logo is not reasonably feasible for
 * technical reasons, the Appropriate Legal Notices must display the words
 * "Powered by SugarCRM".
 */




require_once('include/Dashlets/Dashlet.php');
require_once('include/Sugar_Smarty.php');
require_once('include/charts/Charts.php');
require_once('modules/Dashboard/Forms.php');

class CampaignROIChartDashlet extends Dashlet {
    var $refresh = false;
    var $campaign_id;
    
    function CampaignROIChartDashlet($id, $options) {
        global $timedate;
        parent::Dashlet($id);
        $this->isConfigurable = true;
        $this->isRefreshable = true;
        
        if(!empty($options['campaign_id'])){
        	$this->campaign_id = $options['campaign_id'];
        }
        
		$this->loadLanguage('CampaignROIChartDashlet', 'modules/Charts/Dashlets/');

        if(empty($options['title'])) 
        	$this->title = $this->dashletStrings['LBL_TITLE'];
    }

    function saveOptions($req) {
        global $sugar_config, $timedate, $current_user, $theme;
        $options = array();
        $options['campaign_id'] = $_REQUEST['campaign_id'];
        
        return $options;
    }

    function displayOptions() {
        global $timedate, $image_path, $app_strings, $current_user, $app_list_strings;
        
        $ss = new Sugar_Smarty();
        $ss->assign('id', $this->id);
		$ss->assign('module', $_REQUEST['module']);
        $ss->assign('dashletType', 'predefined_chart');      
        $ss->assign('LBL_CAMPAIGN_NAME', translate('LBL_CAMPAIGN_NAME', 'Campaigns'));
        $ss->assign('LBL_SUBMIT_BUTTON_LABEL', $app_strings['LBL_SUBMIT_BUTTON_LABEL']);
        
        require_once('modules/Campaigns/Campaign.php');
        
        $campaignList = array();
        $campaign = array();
        $focus = new Campaign();
        $focus->disable_row_level_security = false;

    	$campaigns = $focus->get_full_list("","");
    	
    	if ($campaigns != null){

	    	foreach($campaigns as $c){
				$campaignList[$c->id] = $c->name;
			}    	
			
			$ss->assign('campaign_list', get_select_options($campaignList, ''));
    	}
        return parent::displayOptions() . $ss->fetch('modules/Charts/Dashlets/CampaignROIChartDashlet/CampaignROIChartConfigure.tpl');
    }

    /**
     * Displays the javascript for the dashlet
     * 
     * @return string javascript to use with this dashlet
     */
    function displayScript() {
    	global $sugar_config, $current_user, $current_language;
		
		$xmlFile = $sugar_config['tmp_dir']. $current_user->id . '_' . $this->id . '.xml';
		$chartStringsXML = $sugar_config['tmp_dir'].'chart_strings.' . $current_language .'.lang.xml';    
    	
    	$ss = new Sugar_Smarty();
        $ss->assign('chartName', $this->id);
        $ss->assign('chartXMLFile', $xmlFile);    

        $ss->assign('chartStyleCSS', chartStyle());
        $ss->assign('chartColorsXML', chartColors());
        $ss->assign('chartStringsXML', $chartStringsXML);
                
        $str = $ss->fetch('modules/Charts/Dashlets/PredefinedChartDashletScript.tpl');     
        return $str;
    }

    function getTitle($text) {
        global $image_path, $app_strings, $sugar_config;
        
        if($this->isConfigurable) 
            $additionalTitle = '<table width="100%" cellspacing="0" cellpadding="0" border="0"><tr><td width="99%">' . $text 
                               . '</td><td nowrap width="1%"><div style="width: 100%;text-align:right"><a href="#" onclick="SUGAR.mySugar.configureDashlet(\'' 
                               . $this->id . '\'); return false;" class="chartToolsLink">'    
                               . get_image($image_path.'edit','title="' . translate('LBL_DASHLET_EDIT', 'Home') . '" alt="' . translate('LBL_DASHLET_EDIT', 'Home') . '"  border="0"  align="absmiddle"').'</a> ' 
                               . '';
        else 
            $additionalTitle = '<table width="100%" cellspacing="0" cellpadding="0" border="0"><tr><td width="99%">' . $text 
                   . '</td><td nowrap width="1%"><div style="width: 100%;text-align:right">';
        
        if($this->isRefreshable)
            $additionalTitle .= '<a href="#" onclick="SUGAR.mySugar.retrieveDashlet(\'' 
                                . $this->id . '\',\'predefined_chart\'); return false;"><img width="13" height="13" border="0" align="absmiddle" title="' . translate('LBL_DASHLET_REFRESH', 'Home') . '" alt="' . translate('LBL_DASHLET_REFRESH', 'Home') . '" src="' 
                                . $image_path . 'refresh.gif"/></a> ';
        $additionalTitle .= '<a href="#" onclick="SUGAR.mySugar.deleteDashlet(\'' 
                            . $this->id . '\'); return false;"><img width="13" height="13" border="0" align="absmiddle" title="' . translate('LBL_DASHLET_DELETE', 'Home') . '" alt="' . translate('LBL_DASHLET_DELETE', 'Home') . '" src="' 
                            . $image_path . 'close_dashboard.gif"/></a></div></td></tr></table>';
            
        if(!function_exists('get_form_header')) {
            global $theme;
            require_once('themes/'.$theme.'/layout_utils.php');
        }
        
        $str = '<div ';
        if(empty($sugar_config['lock_homepage']) || $sugar_config['lock_homepage'] == false) $str .= ' onmouseover="this.style.cursor = \'move\';"';
        $str .= 'id="dashlet_header_' . $this->id . '">' . get_form_header($this->title, $additionalTitle, false) . '</div>';
        
        return $str;
    }    
    
    function display() {
        global $app_list_strings, $current_language, $sugar_config, $currentModule, $action, $current_user, $theme, $timedate, $image_path;
               
        $this->loadLanguage('CampaignROIChartDashlet', 'modules/Charts/Dashlets/');
        $returnStr = '';
        
        $user_dateFormat = $timedate->get_date_format();
        $current_module_strings = return_module_language($current_language, 'Charts');      

        require_once('modules/Campaigns/Charts.php');

        $current_module_strings = return_module_language($current_language, 'Campaigns');
        $roi_chart = new campaign_charts();
        $chartStr = $roi_chart->campaign_response_roi($app_list_strings['roi_type_dom'],$app_list_strings['roi_type_dom'],$this->campaign_id,'',true,true,true,$this->id);
        
		$returnStr = '<script type="text/javascript" src="include/javascript/swfobject.js"></script>' . $chartStr;
		
        return $this->getTitle('<div align="center"></div>') . '<div align="center">' . $returnStr . '</div><br />';
    }  

}

?>
