<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');
/*********************************************************************************
 * SugarCRM is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004 - 2007 SugarCRM Inc.
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 * 
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 * 
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU General Public License version 3.
 * 
 * In accordance with Section 7(b) of the GNU General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * SugarCRM" logo. If the display of the logo is not reasonably feasible for
 * technical reasons, the Appropriate Legal Notices must display the words
 * "Powered by SugarCRM".
 ********************************************************************************/
/*********************************************************************************

* Description: This file generates the appropriate manager for the database
* 
* Portions created by SugarCRM are Copyright (C) SugarCRM, Inc.
* All Rights Reserved.
* Contributor(s): ______________________________________..
********************************************************************************/

global $sugar_config;

class DBManagerFactory
{
	/** This function returns the correct instance of the manager
	*   depending on the database type
	*/
	function &getInstance($instanceName=''){
		global $sugar_config;
			$temp_var =& DBManager::getInstance($instanceName);
			return $temp_var;
}

    /** This function returns the correct instance of the manager
    *   depending on the database type
    */
    function getHelperInstance(){
        global $sugar_config;

        if( $sugar_config['dbconfig']['db_type'] == "oci8" || $sugar_config['dbconfig']['setup_db_type'] == 'oci8'){



        } 
        elseif( $sugar_config['dbconfig']['db_type'] == "mssql" ) 
		{				
            $my_db_manager = 'MssqlHelper';
        }
        else {
            $my_db_manager = 'MysqlHelper';
            if (!isset($sugar_config['mysqli_disabled']) or $sugar_config['mysqli_disabled']==false) {
                if (function_exists('mysqli_connect')) {
                    $my_db_helper = 'MysqliHelper';    
                }   
            } 
        }
        DBManagerFactory::load_db_manager_class($my_db_manager);
        return new $my_db_manager();
    }
    
	function load_db_manager_class($class_name) {
		global $sugar_config;
		
		if( strcmp($class_name, 'MysqliManager')  == 0 and !class_exists($class_name))
		{
		    require_once('include/database/MysqliManager.php');
			require_once('include/database/MysqliHelper.php');
		}		
		if( strcmp($class_name, 'MysqlManager')  == 0 and !class_exists($class_name))
		{
		    require_once('include/database/MysqlManager.php');
			require_once('include/database/MysqlHelper.php');
		}
		if(strcmp($class_name, 'MssqlManager')  == 0 and !class_exists($class_name))
		{
		    require_once('include/database/MssqlManager.php');  
			require_once('include/database/MssqlHelper.php');
		}







		if( strcmp($class_name, 'FreeTDSManager')  == 0 and !class_exists($class_name))
		{
		    require_once('include/database/FreeTDSManager.php');
			require_once('include/database/FreeTDSHelper.php');
		}		

	}
}

?>
