<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');
/*********************************************************************************
 * SugarCRM is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004 - 2007 SugarCRM Inc.
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 * 
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 * 
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU General Public License version 3.
 * 
 * In accordance with Section 7(b) of the GNU General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * SugarCRM" logo. If the display of the logo is not reasonably feasible for
 * technical reasons, the Appropriate Legal Notices must display the words
 * "Powered by SugarCRM".
 ********************************************************************************/
require_once('include/dir_inc.php');
require_once('include/utils/file_utils.php');
require_once('include/utils/progress_bar_utils.php');
include_once ('include/database/DBManagerFactory.php');
require_once('modules/Relationships/Relationship.php');
define('DISABLED_PATH', 'Disabled');

class ModuleInstaller{
	var $modules = array();
	var $silent = false;
	var $base_dir  = '';
	function ModuleInstaller(){
		$this->modules = get_module_dir_list();
		$this->db = & DBManagerFactory::getInstance();

	}
	function install($base_dir, $is_upgrade = false, $previous_version = ''){
		global $app_strings, $mod_strings;
		$this->base_dir = $base_dir;
		$total_steps = 5; //minimum number of steps with no tasks
		$current_step = 0;
		$tasks = array(
								'pre_execute',
								'install_mkdirs',
								'install_copy',
								'install_images',
								'install_menus',
								'install_userpage',
								'install_dashlets',
								'install_administration',
								'install_vardefs',
								'install_layoutdefs',
								'install_relationships',
								'install_languages',
								'post_execute',
		);
		$total_steps += count($tasks);
		if(file_exists($this->base_dir . '/manifest.php')){
				if(!$this->silent){
					$current_step++;
					display_progress_bar('install', $current_step, $total_steps);
					echo '<div id ="displayLoglink" ><a href="#" onclick="document.getElementById(\'displayLog\').style.display=\'\'">'.$app_strings['LBL_DISPLAY_LOG'].'</a> </div><div id="displayLog" style="display:none">';
				}

				require_once($this->base_dir . '/manifest.php');
				if($is_upgrade && !empty($previous_version)){
					//check if the upgrade path exists
					if(!empty($upgrade_manifest)){
						if(!empty($upgrade_manifest['upgrade_paths'])){
							if(!empty($upgrade_manifest['upgrade_paths'][$previous_version])){
								$installdefs = 	$upgrade_manifest['upgrade_paths'][$previous_version];
							}else{
								$errors[] = 'No Upgrade Path Found in manifest.';
								$this->abort($errors);
							}//fi
						}//fi
					}//fi
				}//fi
				$this->id_name = $installdefs['id'];
				$this->installdefs = $installdefs;
				$installed_modules = array();
				if(isset($installdefs['beans'])){
					$str = "<?php \n //WARNING: The contents of this file are auto-generated\n";
					foreach($installdefs['beans'] as $bean){
						if(!empty($bean['module']) && !empty($bean['class']) && !empty($bean['path'])){
							$module = $bean['module'];
							$class = $bean['class'];
							$path = $bean['path'];

							$str .= "\$beanList['$module'] = '$class';\n";
							$str .= "\$beanFiles['$class'] = '$path';\n";
							if($bean['tab']){
								$str .= "\$moduleList[] = '$module';\n";
								$this->install_user_prefs($module, empty($bean['hide_by_default']));

							}else{
								$str .= "\$modules_exempt_from_availability_check['$module'] = '$module';\n";
								$str .= "\$modInvisList[] = '$module';\n";
							}
							$installed_modules[] = $module;
						}else{
							$errors[] = 'Bean array not well defined.';
							$this->abort($errors);
						}
					}
					$str.= "\n?>";
					if(!file_exists("custom/Extension/application/Ext/Include")){
						mkdir_recursive("custom/Extension/application/Ext/Include", true);
					}
					$out = fopen("custom/Extension/application/Ext/Include/$this->id_name.php", 'w');
					fwrite($out,$str);
					fclose($out);
					$this->merge_files('Ext/Include', 'modules.ext.php', '', true);
				}
				if(!$this->silent){
					$current_step++;
					update_progress_bar('install', $current_step, $total_steps);
				}

				foreach($tasks as $task){
					$this->$task();
					if(!$this->silent){
						$current_step++;
						update_progress_bar('install', $current_step, $total_steps);
					}
				}
				$this->install_beans($installed_modules);
				if(!$this->silent){
					$current_step++;
					update_progress_bar('install', $total_steps, $total_steps);
				}
				if(isset($installdefs['custom_fields'])){
					$this->log(translate('LBL_MI_IN_CUSTOMFIELD'));
					$this->install_custom_fields($installdefs['custom_fields']);
				}
				if(!$this->silent){
					$current_step++;
					update_progress_bar('install', $current_step, $total_steps);
					echo '</div>';
				}
				if(!$this->silent){
					$current_step++;
					update_progress_bar('install', $current_step, $total_steps);
					echo '</div>';
				}
				$selectedActions = array(
			'clearTpls',
			'clearJsFiles',
			'clearDashlets',
			'clearVardefs',
			'clearJsLangFiles',
			'rebuildAuditTables',
			'repairDatabase',
		);
				VardefManager::clearVardef();
				require_once('modules/Administration/QuickRepairAndRebuild.php');
				$rac = new RepairAndClear();
				$rac->repairAndClearAll($selectedActions, $installed_modules,true, false);
				$this->rebuild_relationships();
				$this->log('<br><b>' . translate('LBL_MI_COMPLETE') . '</b>');


		}else{
			die("No \$installdefs Defined In $this->base_dir/manifest.php");
		}

	}

	function install_user_prefs($module, $hide_from_user=false){
		require_once('include/utils/user_utils.php');
		updateAllUserPrefs('display_tabs', $module, '', true, !$hide_from_user);
		updateAllUserPrefs('hide_tabs', $module, '', true, $hide_from_user);
		updateAllUserPrefs('remove_tabs', $module, '', true, $hide_from_user);
	}
	function uninstall_user_prefs($module){
		require_once('include/utils/user_utils.php');
		updateAllUserPrefs('display_tabs', $module, '', true, true);
		updateAllUserPrefs('hide_tabs', $module, '', true, true);
		updateAllUserPrefs('remove_tabs', $module, '', true, true);
	}
	function install_mkdirs(){
		if(isset($this->installdefs['mkdir'])){
				foreach($this->installdefs['mkdir'] as $mkdir){
					$mkdir['path'] = str_replace('<basepath>', $this->base_dir, $mkdir['path']);
					if(!mkdir_recursive($mkdir['path'], true)){
						die('Failed to make directory ' . $mkdir['path']);
					}
				}
			}
	}

	function pre_execute(){
		require_once($this->base_dir . '/manifest.php');
		if(isset($this->installdefs['pre_execute']) && is_array($this->installdefs['pre_execute'])){
			foreach($this->installdefs['pre_execute'] as $includefile){
				require_once(str_replace('<basepath>', $this->base_dir, $includefile));
			}
		}
	}

	function post_execute(){
		require_once($this->base_dir . '/manifest.php');
		if(isset($this->installdefs['post_execute']) && is_array($this->installdefs['post_execute'])){
			foreach($this->installdefs['post_execute'] as $includefile){
				require_once(str_replace('<basepath>', $this->base_dir, $includefile));
			}
		}
	}

	function pre_uninstall(){
		require_once($this->base_dir . '/manifest.php');
		if(isset($this->installdefs['pre_uninstall']) && is_array($this->installdefs['pre_uninstall'])){
			foreach($this->installdefs['pre_uninstall'] as $includefile){
				require_once(str_replace('<basepath>', $this->base_dir, $includefile));
			}
		}
	}

	function post_uninstall(){
		require_once($this->base_dir . '/manifest.php');
		if(isset($this->installdefs['post_uninstall']) && is_array($this->installdefs['post_uninstall'])){
			foreach($this->installdefs['post_uninstall'] as $includefile){
				require_once(str_replace('<basepath>', $this->base_dir, $includefile));
			}
		}
	}

	function uninstall_mkdirs(){
		if(isset($this->installdefs['mkdir'])){
					foreach($this->installdefs['mkdir'] as $mkdir){
						$mkdir['path'] = str_replace('<basepath>', $this->base_dir, $mkdir['path']);
						rmdir_recursive($mkdir['path']);
					}
		}
	}
	/*
	 * Copies both directories and files from a loaction to a location
	 */
	function install_copy(){
		if(isset($this->installdefs['copy'])){
			/* BEGIN - RESTORE POINT - by MR. MILK August 31, 2005 02:22:11 PM */
			$backup_path = clean_path( remove_file_extension(urldecode($_REQUEST['install_file']))."-restore" );
			/* END - RESTORE POINT - by MR. MILK August 31, 2005 02:22:18 PM */
			foreach($this->installdefs['copy'] as $cp){
				$GLOBALS['log']->debug("Copying ..." . $cp['from'].  " to " .$cp['to'] );
				/* BEGIN - RESTORE POINT - by MR. MILK August 31, 2005 02:22:11 PM */
				//$this->copy_path($cp['from'], $cp['to']);
				$this->copy_path($cp['from'], $cp['to'], $backup_path);
				/* END - RESTORE POINT - by MR. MILK August 31, 2005 02:22:18 PM */
			}
			//here we should get the module list again as we could have copied something to the modules dir
			$this->modules = get_module_dir_list();
		}
	}
	function uninstall_copy(){
		if(!empty($this->installdefs['copy'])){
					foreach($this->installdefs['copy'] as $cp){
						$cp['to'] = clean_path(str_replace('<basepath>', $this->base_dir, $cp['to']));
						$GLOBALS['log']->debug('Unlink ' . $cp['to']);
				/* BEGIN - RESTORE POINT - by MR. MILK August 31, 2005 02:22:11 PM */
						//rmdir_recursive($cp['to']);
						$backup_path = clean_path( remove_file_extension(urldecode($_REQUEST['install_file']))."-restore/".$cp['to'] );
						$this->copy_path($backup_path, $cp['to'], $backup_path, true);
				/* END - RESTORE POINT - by MR. MILK August 31, 2005 02:22:18 PM */
					}
					$backup_path = clean_path( remove_file_extension(urldecode($_REQUEST['install_file']))."-restore");
					if(file_exists($backup_path))
						rmdir_recursive($backup_path);
				}
	}


	function install_dashlets(){
        if(isset($this->installdefs['dashlets'])){
			foreach($this->installdefs['dashlets'] as $cp){
				$this->log(translate('LBL_MI_IN_DASHLETS') . $cp['name']);
				$cp['from'] = str_replace('<basepath>', $this->base_dir, $cp['from']);
				$path = 'custom/modules/Home/Dashlets/' . $cp['name'] . '/';
				$GLOBALS['log']->debug("Installing Dashlet " . $cp['name'] . "..." . $cp['from'] );
				if(!file_exists($path)){
					mkdir_recursive($path, true);
				}
				copy_recursive($cp['from'] , $path);
			}
			include('modules/Administration/RebuildDashlets.php');

		}
	}

	function uninstall_dashlets(){
        if(isset($this->installdefs['dashlets'])){
					foreach($this->installdefs['dashlets'] as $cp){
						$this->log(translate('LBL_MI_UN_DASHLETS') . $cp['name']);
						$path = 'custom/modules/Home/Dashlets/' . $cp['name'];
						$GLOBALS['log']->debug('Unlink ' .$path);
						rmdir_recursive($path);
					}
					include('modules/Administration/RebuildDashlets.php');
				}
	}


	function install_images(){
        if(isset($this->installdefs['image_dir'])){
			$this->log( translate('LBL_MI_IN_IMAGES') );
			$this->copy_path($this->installdefs['image_dir'] , 'themes');

		}
	}

	function install_menus(){
        if(isset($this->installdefs['menu'])){
					$this->log(translate('LBL_MI_IN_MENUS'));
					foreach($this->installdefs['menu'] as $menu){
						$menu['from'] = str_replace('<basepath>', $this->base_dir, $menu['from']);
						$GLOBALS['log']->debug("Installing Menu ..." . $menu['from'].  " for " .$menu['to_module'] );
						$path = 'custom/Extension/modules/' . $menu['to_module']. '/Ext/Menus';
						if($menu['to_module'] == 'application'){
							$path ='custom/Extension/' . $menu['to_module']. '/Ext/Menus';
						}
						if(!file_exists($path)){
							mkdir_recursive($path, true);

						}
						copy_recursive($menu['from'] , $path . '/'. $this->id_name . '.php');
					}
					$this->rebuild_menus();
		}

	}

	function uninstall_menus(){
        if(isset($this->installdefs['menu'])){
					$this->log(translate('LBL_MI_UN_MENUS'));
					foreach($this->installdefs['menu'] as $menu){
						$menu['from'] = str_replace('<basepath>', $this->base_dir, $menu['from']);
						$GLOBALS['log']->debug("Uninstalling Menu ..." . $menu['from'].  " for " .$menu['to_module'] );
						$path = 'custom/Extension/modules/' . $menu['to_module']. '/Ext/Menus';
						if($menu['to_module'] == 'application'){
							$path ='custom/Extension/' . $menu['to_module']. '/Ext/Menus';
						}
						rmdir_recursive( $path . '/'. $this->id_name . '.php');

					}
					$this->rebuild_menus();
				}
	}

	function install_administration(){
        if(isset($this->installdefs['administration'])){
					$this->log(translate('LBL_MI_IN_ADMIN'));
					foreach($this->installdefs['administration'] as $administration){
						$administration['from'] = str_replace('<basepath>', $this->base_dir, $administration['from']);
						$GLOBALS['log']->debug("Installing Administration Section ..." . $administration['from'] );
						$path = 'custom/Extension/modules/Administration/Ext/Administration';
						if(!file_exists($path)){
							mkdir_recursive($path, true);

						}
						copy_recursive($administration['from'] , $path . '/'. $this->id_name . '.php');
					}
					$this->rebuild_administration();
				}

	}
	function uninstall_administration(){
            if(isset($this->installdefs['administration'])){
					$this->log(translate('LBL_MI_UN_ADMIN'));
					foreach($this->installdefs['administration'] as $administration){
						$administration['from'] = str_replace('<basepath>', $this->base_dir, $administration['from']);
						$GLOBALS['log']->debug("Uninstalling Administration Section ..." . $administration['from'] );
						$path = 'custom/Extension/modules/Administration/Ext/Administration';
						rmdir_recursive( $path . '/'. $this->id_name . '.php');
					}
					$this->rebuild_administration();
				}
	}

	function install_userpage(){
        if(isset($this->installdefs['user_page'])){
					$this->log(translate('LBL_MI_IN_USER'));
					foreach($this->installdefs['user_page'] as $userpage){
						$userpage['from'] = str_replace('<basepath>', $this->base_dir, $userpage['from']);
						$GLOBALS['log']->debug("Installing User Page Section ..." . $userpage['from'] );
						$path = 'custom/Extension/modules/Users/Ext/UserPage';
						if(!file_exists($path)){
							mkdir_recursive($path, true);

						}
						copy_recursive($userpage['from'] , $path . '/'. $this->id_name . '.php');
					}
					$this->rebuild_userpage();
				}

	}
	function uninstall_userpage(){
            if(isset($this->installdefs['user_page'])){
					$this->log(translate('LBL_MI_UN_USER') );
					foreach($this->installdefs['user_page'] as $userpage){
						$userpage['from'] = str_replace('<basepath>', $this->base_dir, $userpage['from']);
						$GLOBALS['log']->debug("Uninstalling User Page Section ..." . $userpage['from'] );
						$path = 'custom/Extension/modules/Users/Ext/UserPage';
						rmdir_recursive( $path . '/'. $this->id_name . '.php');
					}
					$this->rebuild_userpage();
				}
	}

	/*
	 * handles the installation of vardefs
	 *
	 */
	function install_vardefs(){
        if(isset($this->installdefs['vardefs'])){
			$this->log(translate('LBL_MI_IN_VAR') );
			foreach($this->installdefs['vardefs'] as $vardefs){
				$vardefs['from'] = str_replace('<basepath>', $this->base_dir, $vardefs['from']);
				$this->install_vardef($vardefs['from'], $vardefs['to_module'], $this->id_name);
			}
			$this->rebuild_vardefs();
		}
	}
	function uninstall_vardefs(){
        if(isset($this->installdefs['vardefs'])){
					$this->log(translate('LBL_MI_UN_VAR') );
					foreach($this->installdefs['vardefs'] as $vardefs){
						$vardefs['from'] = str_replace('<basepath>', $this->base_dir, $vardefs['from']);
						$GLOBALS['log']->debug("Uninstalling Vardefs ..." . $vardefs['from'] .  " for " .$vardefs['to_module']);
						$path = 'custom/Extension/modules/' . $vardefs['to_module']. '/Ext/Vardefs';
						if($vardefs['to_module'] == 'application'){
							$path ='custom/Extension/' . $vardefs['to_module']. '/Ext/Vardefs';
						}
						if(file_exists($path . '/'. $this->id_name . '.php'))
							rmdir_recursive( $path . '/'. $this->id_name . '.php');
					}
					$this->rebuild_vardefs();
				}
	}
	function install_vardef($from, $to_module){
			$GLOBALS['log']->debug("Installing Vardefs ..." . $from .  " for " .$to_module);
			$path = 'custom/Extension/modules/' . $to_module. '/Ext/Vardefs';
			if($to_module == 'application'){
				$path ='custom/Extension/' . $to_module. '/Ext/Vardefs';
			}
			if(!file_exists($path)){
				mkdir_recursive($path, true);
			}
			copy_recursive($from , $path.'/'. $this->id_name . '.php');
	}
	function install_layoutdefs(){
        if(isset($this->installdefs['layoutdefs'])){
			$this->log(translate('LBL_MI_IN_SUBPANEL') );
			foreach($this->installdefs['layoutdefs'] as $layoutdefs){
				$layoutdefs['from'] = str_replace('<basepath>', $this->base_dir, $layoutdefs['from']);
				$this->install_layoutdef($layoutdefs['from'], $layoutdefs['to_module'], $this->id_name);
			}
			$this->rebuild_layoutdefs();
		}
	}
	function uninstall_layoutdefs(){
        if(isset($this->installdefs['layoutdefs'])){
					$this->log(translate('LBL_MI_UN_SUBPANEL') );
					foreach($this->installdefs['layoutdefs'] as $layoutdefs){
						$layoutdefs['from'] = str_replace('<basepath>', $this->base_dir, $layoutdefs['from']);
						$GLOBALS['log']->debug("Uninstalling Layoutdefs ..." . $layoutdefs['from'] .  " for " .$layoutdefs['to_module']);
						$path = 'custom/Extension/modules/' . $layoutdefs['to_module']. '/Ext/Layoutdefs';
						if($layoutdefs['to_module'] == 'application'){
							$path ='custom/Extension/' . $layoutdefs['to_module']. '/Ext/Layoutdefs';
						}

						rmdir_recursive( $path . '/'. $this->id_name . '.php');
					}
					$this->rebuild_layoutdefs();
				}
	}
	function install_layoutdef($from, $to_module){
			$GLOBALS['log']->debug("Installing Layout Defs ..." . $from .  " for " .$to_module);
			$path = 'custom/Extension/modules/' . $to_module. '/Ext/Layoutdefs';
			if($to_module == 'application'){
				$path ='custom/Extension/' . $to_module. '/Ext/Layoutdefs';
			}
			if(!file_exists($path)){
				mkdir_recursive($path, true);
			}
			copy_recursive($from , $path.'/'. $this->id_name . '.php');
	}

	function install_languages(){
        $languages = array();
				if(isset($this->installdefs['language'])){
					$this->log(translate('LBL_MI_IN_LANG') );
					foreach($this->installdefs['language'] as $packs){
						$modules[]=$packs['to_module'];
						$languages[$packs['language']] = $packs['language'];
						$packs['from'] = str_replace('<basepath>', $this->base_dir, $packs['from']);
						$GLOBALS['log']->debug("Installing Language Pack ..." . $packs['from']  .  " for " .$packs['to_module']);
						$path = 'custom/Extension/modules/' . $packs['to_module']. '/Ext/Language';
						if($packs['to_module'] == 'application'){
							$path ='custom/Extension/' . $packs['to_module']. '/Ext/Language';
						}

						if(!file_exists($path)){
							mkdir_recursive($path, true);

						}
						copy_recursive($packs['from'] , $path.'/'.$packs['language'].'.'. $this->id_name . '.php');
					}
					$this->rebuild_languages($languages, $modules);

				}
	}

	function uninstall_languages(){
        $languages = array();
				if(isset($this->installdefs['language'])){
					$this->log(translate('LBL_MI_UN_LANG') );
					foreach($this->installdefs['language'] as $packs){
						$modules[]=$packs['to_module'];						
						$languages[$packs['language']] = $packs['language'];
						$packs['from'] = str_replace('<basepath>', $this->base_dir, $packs['from']);
						$GLOBALS['log']->debug("Uninstalling Language Pack ..." . $packs['from']  .  " for " .$packs['to_module']);
						$path = 'custom/Extension/modules/' . $packs['to_module']. '/Ext/Language';
						if($packs['to_module'] == 'application'){
							$path ='custom/Extension/' . $packs['to_module']. '/Ext/Language';
						}

						rmdir_recursive( $path.'/'.$packs['language'].'.'. $this->id_name . '.php');

					}
					$this->rebuild_languages($languages, $modules);

				}
	}

/* BEGIN - RESTORE POINT - by MR. MILK August 31, 2005 02:22:18 PM */
	function copy_path($from, $to, $backup_path='', $uninstall=false){
	//function copy_path($from, $to){
/* END - RESTORE POINT - by MR. MILK August 31, 2005 02:22:18 PM */
		$to = str_replace('<basepath>', $this->base_dir, $to);

		if(!$uninstall) {
		$from = str_replace('<basepath>', $this->base_dir, $from);
		$GLOBALS['log']->debug('Copy ' . $from);
		}
		else {
			$from = str_replace('<basepath>', $backup_path, $from);
			//$GLOBALS['log']->debug('Restore ' . $from);
		}
		$from = clean_path($from);
		$to = clean_path($to);

		$dir = dirname($to);
		if(!file_exists($dir))
			mkdir_recursive($dir, true);
/* BEGIN - RESTORE POINT - by MR. MILK August 31, 2005 02:22:18 PM */
		if(empty($backup_path)) {
/* END - RESTORE POINT - by MR. MILK August 31, 2005 02:22:18 PM */
		if(!copy_recursive($from, $to)){
			die('Failed to copy ' . $from. ' ' . $to);
		}
/* BEGIN - RESTORE POINT - by MR. MILK August 31, 2005 02:22:18 PM */
		}
		elseif(!$this->copy_recursive_with_backup($from, $to, $backup_path, $uninstall)){
			die('Failed to copy ' . $from. ' ' . $to);
		}
/* END - RESTORE POINT - by MR. MILK August 31, 2005 02:22:18 PM */
	}

	function install_custom_fields($fields){
		global $beanList, $beanFiles;
		include('include/modules.php');
		foreach($fields as $field){
			$installed = false;
			if(isset($beanList[ $field['module']])){
				$class = $beanList[ $field['module']];
                if(!isset($field['ext4']))$field['ext4'] = '';
                if(!isset($field['mass_update']))$field['mass_update'] = 0;
                if(!isset($field['duplicate_merge']))$field['duplicate_merge'] = 0;
                if(!isset($field['help']))$field['help'] = '';
				if(!isset($field['comments']))$field['comments'] = '';

				if(file_exists($beanFiles[$class])){
					require_once($beanFiles[$class]);
					$mod = new $class();
					$installed = true;
					$mod->custom_fields->use_existing_labels =  true;
					if(!empty($field['id']))
						$mod->custom_fields->maintain_label_value = true;
					$mod->custom_fields->addField($field['name'], $field['label'], $field['type'], $field['max_size'], $field['require_option'], $field['default_value'], $field['ext1'], $field['ext2'], $field['ext3'], $field['audited'], $field['mass_update'],$field['ext4'], $field['help'], $field['duplicate_merge'], $field['comments']);
				}
				}
				if(!$installed){
					$GLOBALS['log']->debug('Could not install custom field ' . $field['name'] . ' for module ' .  $field['module'] . ': Module does not exist');
				}
		}
	}

	function uninstall_custom_fields($fields){
		global $beanList, $beanFiles;
		require_once('modules/DynamicFields/DynamicField.php');
		$dyField = new DynamicField();

		foreach($fields as $field){
			$class = $beanList[ $field['module']];
			if(file_exists($beanFiles[$class])){
					require_once($beanFiles[$class]);
					$mod = new $class();
					$dyField->bean = $mod;
					$dyField->module = $field['module'];
					$dyField->dropField($field['name']);
			}
		}
	}

	function install_relationships(){
    if(isset($this->installdefs['relationships'])){
			$this->log(translate('LBL_MI_IN_RELATIONSHIPS') );
			$str = "<?php \n //WARNING: The contents of this file are auto-generated\n";
			$save_table_dictionary = false;
			foreach($this->installdefs['relationships'] as $relationship){

						$filename	=basename($relationship['meta_data']);
						$this->copy_path($relationship['meta_data'], 'metadata/'. $filename);
						$this->install_relationship('metadata/'. $filename);
						$save_table_dictionary  = true;
						$str .= "include('metadata/$filename');\n";
						if(!empty($relationship['module_vardefs'])){
							$relationship['module_vardefs'] = str_replace('<basepath>', $this->base_dir, $relationship['module_vardefs']);
							$this->install_vardef($relationship['module_vardefs'], $relationship['module']);
						}
						if(!empty($relationship['module_layoutdefs'])){
							$relationship['module_layoutdefs'] = str_replace('<basepath>', $this->base_dir, $relationship['module_layoutdefs']);
							$this->install_layoutdef($relationship['module_layoutdefs'], $relationship['module']);
						}
					}
				$this->rebuild_vardefs();
				$this->rebuild_layoutdefs();
				if($save_table_dictionary){
					if(!file_exists("custom/Extension/application/Ext/TableDictionary")){
						mkdir_recursive("custom/Extension/application/Ext/TableDictionary", true);
					}
					$out = fopen("custom/Extension/application/Ext/TableDictionary/$this->id_name.php", 'w');
					fwrite($out,$str . "\n?>");
					fclose($out);
					$this->rebuild_tabledictionary();
				}


			}
	}
	function install_relationship($file){
		$_REQUEST['moduleInstaller'] = true;
		if(!file_exists($file)){
			$GLOBALS['log']->debug( 'File does not exists : '.$file);
			return;
		}
		include($file);
		$rel_dictionary = $dictionary;
		 foreach ($rel_dictionary as $rel_name => $rel_data)
   	{
		$table = $rel_data['table'];



      if(!$this->db->tableExists($table))
      {
      	$this->db->createTableParams($table, $rel_data['fields'], $rel_data['indices']);
      }

	if(!$this->silent)$GLOBALS['log']->debug("Processing relationship meta for ". $rel_name."...");
	  SugarBean::createRelationshipMeta($rel_name, $this->db,$table,$rel_dictionary,'');
	Relationship::delete_cache();
	 if(!$this->silent) $GLOBALS['log']->debug( 'done<br>');


   }
	}

	function uninstall_relationship($file){
        if(!file_exists($file)){
			$GLOBALS['log']->debug( 'File does not exists : '.$file);
			return;
		}

		include($file);
		$rel_dictionary = $dictionary;
		foreach ($rel_dictionary as $rel_name => $rel_data)
   		{
            if (isset($rel_data['table'])){
			    $table = $rel_data['table'];
            }
            else{
                $table = ' One-to-Many ';
            }

        	if ($this->db->tableExists($table))
         	{
         	    SugarBean::removeRelationshipMeta($rel_name, $this->db,$table,$rel_dictionary,'');
         		$this->db->dropTableName($table);
         		if(!$this->silent) $this->log( translate('LBL_MI_UN_RELATIONSHIPS_DROP') . $table);
         	}
        }
        Relationship::delete_cache();
	}

	function uninstall_relationships(){
        if(isset($this->installdefs['relationships'])){
					$this->log(translate('LBL_MI_UN_RELATIONSHIPS') );
					foreach($this->installdefs['relationships'] as $relationship){
						$filename	=basename($relationship['meta_data']);
						if(isset($GLOBALS['mi_remove_tables']) && $GLOBALS['mi_remove_tables'])
							$this->uninstall_relationship('metadata/'. $filename);
						unlink( 'metadata/'. $filename);
						//remove the vardefs
						$path = 'custom/Extension/modules/' . $relationship['module']. '/Ext/Vardefs';
						if($relationship['module'] == 'application'){
							$path ='custom/Extension/' . $relationship['module']. '/Ext/Vardefs';
						}
						if(!empty($relationship['module_vardefs']) && file_exists($path . '/'. $this->id_name . '.php'))
							rmdir_recursive( $path . '/'. $this->id_name . '.php');
						//remove the layoutdefs
						$path = 'custom/Extension/modules/' . $relationship['module']. '/Ext/Layoutdefs';
						if($relationship['module'] == 'application'){
							$path ='custom/Extension/' . $relationship['module']. '/Ext/Layoutdefs';
						}

						if(!empty($relationship['module_layoutdefs']) && file_exists($path . '/'. $this->id_name . '.php'))
							rmdir_recursive( $path . '/'. $this->id_name . '.php');
					}
					if(file_exists("custom/Extension/application/Ext/TableDictionary/$this->id_name.php")){
						unlink("custom/Extension/application/Ext/TableDictionary/$this->id_name.php");
					}
					$this->rebuild_tabledictionary();
					$this->rebuild_vardefs();
					$this->rebuild_layoutdefs();
				}
	}




	function uninstall($base_dir){
		global $app_strings;
		$total_steps = 5; //min steps with no tasks
		$current_step = 0;
		$this->base_dir = $base_dir;
		$tasks = array(
							'pre_uninstall',
							'uninstall_mkdirs',
							'uninstall_copy',
							'uninstall_menus',
							'uninstall_dashlets',
							'uninstall_userpage',
							'uninstall_administration',
							'uninstall_vardefs',
							'uninstall_layoutdefs',
							'uninstall_relationships',
							'uninstall_languages',
							'post_uninstall',
							);
		$total_steps += count($tasks); //now the real number of steps
		if(file_exists($this->base_dir . '/manifest.php')){
				if(!$this->silent){
					$current_step++;
					display_progress_bar('install', $current_step, $total_steps);
					echo '<div id ="displayLoglink" ><a href="#" onclick="toggleDisplay(\'displayLog\')">'.$app_strings['LBL_DISPLAY_LOG'].'</a> </div><div id="displayLog" style="display:none">';
				}

				require_once($this->base_dir . '/manifest.php');
				$this->installdefs = $installdefs;
				$this->id_name = $this->installdefs['id'];
				$installed_modules = array();
				if(isset($this->installdefs['beans'])){

					foreach($this->installdefs['beans'] as $bean){

						$installed_modules[] = $bean['module'];
						$this->uninstall_user_prefs($bean['module']);


					}

					$this->uninstall_beans($installed_modules);
					if(!$this->silent){
						$current_step++;
						update_progress_bar('install', $total_steps, $total_steps);
					}
					rmdir_recursive("custom/Extension/application/Ext/Include/$this->id_name.php");
					$this->merge_files('Ext/Include', 'modules.ext.php', '', true);
				}
				if(!$this->silent){
					$current_step++;
					update_progress_bar('install', $current_step, $total_steps);
				}


				foreach($tasks as $task){
					$this->$task();
					if(!$this->silent){
						$current_step++;
						update_progress_bar('install', $current_step, $total_steps);
					}
				}
				if(isset($installdefs['custom_fields']) && (isset($GLOBALS['mi_remove_tables']) && $GLOBALS['mi_remove_tables'])){
					$this->log(translate('LBL_MI_UN_CUSTOMFIELD'));
					$this->uninstall_custom_fields($installdefs['custom_fields']);
				}
				if(!$this->silent){
					$current_step++;
					update_progress_bar('install', $current_step, $total_steps);
					echo '</div>';
				}
				$this->rebuild_relationships();
				$this->remove_acl_actions();
			if(!$this->silent){
					$current_step++;
					update_progress_bar('install', $current_step, $total_steps);
					echo '</div>';
				}

				$this->log('<br><b>' . translate('LBL_MI_COMPLETE') . '</b>');
				update_progress_bar('install', $total_steps, $total_steps);
		}else{
			die("No manifest.php Defined In $this->base_dir/manifest.php");
		}
	}

	function rebuild_languages($languages, $modules=""){
            foreach($languages as $language=>$value){
				$this->log(translate('LBL_MI_REBUILDING') . " Language...$language");
				$this->merge_files('Ext/Language/', $language.'.lang.ext.php', $language);
	            if($modules!=""){
	                foreach($modules as $module){
	                	LanguageManager::clearLanguageCache($module, $language);
	                }
	            }
			}
			sugar_cache_reset();
			
	}

	function rebuild_vardefs(){
            $this->log(translate('LBL_MI_REBUILDING') . " Vardefs...");
			$this->merge_files('Ext/Vardefs/', 'vardefs.ext.php');
			sugar_cache_reset();
	}
	function rebuild_layoutdefs(){
            $this->log(translate('LBL_MI_REBUILDING') . " Layoutdefs...");
			$this->merge_files('Ext/Layoutdefs/', 'layoutdefs.ext.php');

	}

	function rebuild_menus(){
            $this->log(translate('LBL_MI_REBUILDING') . " Menus...");
			$this->merge_files('Ext/Menus/', 'menu.ext.php');
	}


	function rebuild_administration(){
            $this->log(translate('LBL_MI_REBUILDING') . " administration " . translate('LBL_MI_SECTION'));
			$this->merge_files('Ext/Administration/', 'administration.ext.php');
	}
	function rebuild_userpage(){
            $this->log(translate('LBL_MI_REBUILDING') . " User Page " . translate('LBL_MI_SECTION'));
			$this->merge_files('Ext/UserPage/', 'userpage.ext.php');
	}
	function rebuild_tabledictionary(){
            $this->log(translate('LBL_MI_REBUILDING') . " administration " . translate('LBL_MI_SECTION'));
			$this->merge_files('Ext/TableDictionary/', 'tabledictionary.ext.php');
	}

	function rebuild_relationships() {
        if(!$this->silent) echo translate('LBL_MI_REBUILDING') . ' Relationships';
		$_REQUEST['silent'] = true;
		global $beanFiles;
		include('include/modules.php');
		include("modules/Administration/RebuildRelationship.php");
	}
	
	function remove_acl_actions() {
		global $beanFiles, $beanList, $current_user;
		include('include/modules.php');
		include("modules/ACL/remove_actions.php");
	}

	/**
	 * Wrapper call to modules/Administration/RepairIndex.php
	 */
	function repair_indices() {
		global $current_user,$beanFiles,$dictionary;
		$this->log(translate('LBL_MI_REPAIR_INDICES'));
		$_REQUEST['silent'] = true; // local var flagging echo'd output in repair script
		$_REQUEST['mode'] = 'execute'; // flag to just go ahead and run the script
		include("modules/Administration/RepairIndex.php");
	}

	function rebuild_all($silent=false){

		$this->silent=$silent;
		global $sugar_config;

		$this->rebuild_languages($sugar_config['languages']);
		$this->rebuild_vardefs();
		$this->rebuild_layoutdefs();
		$this->rebuild_menus();
		$this->rebuild_userpage();
		$this->rebuild_administration();
		$this->rebuild_relationships();
		//$this->repair_indices();
		sugar_cache_reset();
	}

	function merge_files($path, $name, $filter = '', $application = false){
		if(!$application){
		$GLOBALS['log']->debug("Merging module files for $name in $path");
		foreach($this->modules as $module){
				$GLOBALS['log']->debug("Merging Files for: ".$module);
				$GLOBALS['log']->debug("Merging Files for path: ".$path);
				$extension = "<?php \n //WARNING: The contents of this file are auto-generated\n";
				$extpath = "modules/$module/$path";
				$module_install  = 'custom/Extension/'.$extpath;
				$shouldSave = false;
				if(is_dir($module_install)){
					$dir = dir($module_install);
					$shouldSave = true;
					$override = array(); 
					while($entry = $dir->read()){
						if((empty($filter) || substr_count($entry, $filter) > 0) && is_file($module_install.'/'.$entry) 
						     && $entry != '.' && $entry != '..'){
						    if (substr($entry, 0, 9) == '_override') { 
						    	$override[] = $entry;	
						    } else {
							    $fp = fopen($module_install . '/' . $entry, 'r');
							    $file = fread($fp , filesize($module_install . '/' . $entry));
							    fclose($fp);
							    $extension .= "\n". str_replace(array('<?php', '?>', '<?PHP', '<?'), array('','', '' ,'') , $file);
						    }
						}
					}
					foreach ($override as $entry) {
						$fp = fopen($module_install . '/' . $entry, 'r');
                        $file = fread($fp , filesize($module_install . '/' . $entry));
                        fclose($fp);
                        $extension .= "\n". str_replace(array('<?php', '?>', '<?PHP', '<?'), array('','', '' ,'') , $file);
					}
				}
				$extension .= "\n?>";

				if($shouldSave){
					if(!file_exists("custom/$extpath")){
					mkdir_recursive("custom/$extpath", true);
				}
					$out = fopen("custom/$extpath/$name", 'w');
					fwrite($out,$extension);
					fclose($out);
				}else{
					if(file_exists("custom/$extpath/$name")){
						unlink("custom/$extpath/$name");
					}
				}
			}

		}

		$GLOBALS['log']->debug("Merging application files for $name in $path");
		//Now the application stuff
		$extension = "<?php \n //WARNING: The contents of this file are auto-generated\n";
		$extpath = "application/$path";
		$module_install  = 'custom/Extension/'.$extpath;
		$shouldSave = false;
					if(is_dir($module_install)){
						$dir = dir($module_install);
						while($entry = $dir->read()){
								$shouldSave = true;
								if((empty($filter) || substr_count($entry, $filter) > 0) && is_file($module_install.'/'.$entry) && $entry != '.' && $entry != '..'){
									$fp = fopen($module_install . '/' . $entry, 'r');
									$file = fread($fp , filesize($module_install . '/' . $entry));
									fclose($fp);
									$extension .= "\n". str_replace(array('<?php', '?>', '<?PHP', '<?'), array('','', '' ,'') , $file);
								}
						}
					}
					$extension .= "\n?>";
					if($shouldSave){
						if(!file_exists("custom/$extpath")){
							mkdir_recursive("custom/$extpath", true);
						}
						$out = fopen("custom/$extpath/$name", 'w');
						fwrite($out,$extension);
						fclose($out);
					}else{
					if(file_exists("custom/$extpath/$name")){
						unlink("custom/$extpath/$name");
					}
				}

}

	function install_beans($beans){
        include('include/modules.php');
		foreach($beans as $bean){
			$this->log( translate('LBL_MI_IN_BEAN') . " $bean");
			if(isset($beanList[$bean])){
				$class = $beanList[$bean];
				if(file_exists($beanFiles[$class])){
					require_once($beanFiles[$class]);
					$mod = new $class();
					if(is_subclass_of($mod, 'SugarBean')){
						$GLOBALS['log']->debug( "Creating Tables Bean : $bean");
						$mod->create_tables();
						SugarBean::createRelationshipMeta($mod->getObjectName(), $mod->db,$mod->table_name,'',$mod->module_dir);
					}
				}else{
					$GLOBALS['log']->debug( "File Does Not Exist:" . $beanFiles[$class] );
				}
			}
		}
	}

		function uninstall_beans($beans){
		include('include/modules.php');
        foreach($beans as $bean){
			$this->log( translate('LBL_MI_UN_BEAN') . " $bean");
			if(isset($beanList[$bean])){
				$class = $beanList[$bean];

				if(file_exists($beanFiles[$class])){
					require_once($beanFiles[$class]);
					$mod = new $class();

					if(is_subclass_of($mod, 'SugarBean')){
						$GLOBALS['log']->debug( "Drop Tables : $bean");
						if(isset($GLOBALS['mi_remove_tables']) && $GLOBALS['mi_remove_tables'])
							$mod->drop_tables();
					}
				}else{
					$GLOBALS['log']->debug( "File Does Not Exist:" . $beanFiles[$class] );
				}
			}
		}
	}

	function log($str){
		$GLOBALS['log']->debug('ModuleInstaller:'. $str);
		if(!$this->silent){
			echo $str . '<br>';
		}
	}

/* BEGIN - RESTORE POINT - by MR. MILK August 31, 2005 02:15:18 PM 	*/
function copy_recursive_with_backup( $source, $dest, $backup_path, $uninstall=false ) {





	if(is_file($source)) {
	    if($uninstall) {
		    $GLOBALS['log']->debug("Restoring ... " . $source.  " to " .$dest );
		    if(copy( $source, $dest)) {
			    if(is_writable($dest))
			    	touch( $dest, filemtime($source) );
		    	return(unlink($source));
	    	}
		    else {
		    	$GLOBALS['log']->debug( "Can't restore file: " . $source );
		    	return true;
	    	}
	    }
	    else {
			if(file_exists($dest)) {
				$rest = clean_path($backup_path."/$dest");
				if( !is_dir(dirname($rest)) )
					mkdir_recursive(dirname($rest), true);

				$GLOBALS['log']->debug("Backup ... " . $dest.  " to " .$rest );
				if(copy( $dest, $rest)) {
					if(is_writable($rest))
						touch( $rest, filemtime($dest) );
				}
				else {
					$GLOBALS['log']->debug( "Can't backup file: " . $dest );
				}
			}
			return( copy( $source, $dest ) );
		}
    }
    elseif(!is_dir($source)) {
	    if($uninstall) {
			if(is_file($dest))
				return(unlink($dest));
			else {
				rmdir_recursive($dest);
				return true;
			}
		}
		else
			return false;
	}

    if( !is_dir($dest) && !$uninstall){
        mkdir( $dest );
    }

    $status = true;

    $d = dir( $source );
    while( $f = $d->read() ){
        if( $f == "." || $f == ".." ){
            continue;
        }
        $status &= $this->copy_recursive_with_backup( "$source/$f", "$dest/$f", $backup_path, $uninstall );
    }
    $d->close();
    return( $status );
}
/* END - RESTORE POINT - by MR. MILK August 31, 2005 02:15:34 PM */


	/**
	 * Static function which allows a module developer to abort their progress, pass in an array of errors and
	 * redirect back to the main module loader page
	 *
	 * @param errors	an array of error messages which will be displayed on the
	 * 					main module loader page once it is loaded.
	 */
	function abort($errors = array()){
		//set the errors onto the session so we can display them one the moduler loader page loads
		$_SESSION['MODULEINSTALLER_ERRORS'] = $errors;
		echo '<META HTTP-EQUIV="Refresh" content="0;url=index.php?module=Administration&action=UpgradeWizard&view=module">';
		die();
		//header('Location: index.php?module=Administration&action=UpgradeWizard&view=module');
	}

	/**
	 * Return the set of errors stored in the SESSION
	 *
	 * @return an array of errors
	 */
	function getErrors(){
		if(!empty($_SESSION['MODULEINSTALLER_ERRORS'])){
			$errors = $_SESSION['MODULEINSTALLER_ERRORS'];
			unset($_SESSION['MODULEINSTALLER_ERRORS']);
			return $errors;
		}
		else
			return null;
	}

	///////////////////
	//********** DISABLE/ENABLE FUNCTIONS
	///////////////////
	function enable($base_dir, $is_upgrade = false, $previous_version = ''){
		global $app_strings;
		$this->base_dir = $base_dir;
		$total_steps = 3; //minimum number of steps with no tasks
		$current_step = 0;
		$tasks = array(
								'enable_copy',
								'enable_menus',
								'enable_userpage',
								'enable_dashlets',
								'enable_administration',
								'enable_vardefs',
								'enable_layoutdefs',
								'enable_relationships',
								'enable_languages',
		);
		$total_steps += count($tasks);
		if(file_exists($this->base_dir . '/manifest.php')){
				if(!$this->silent){
					$current_step++;
					display_progress_bar('install', $current_step, $total_steps);
					echo '<div id ="displayLoglink" ><a href="#" onclick="toggleDisplay(\'displayLog\')">'.$app_strings['LBL_DISPLAY_LOG'].'</a> </div><div id="displayLog" style="display:none">';
				}

				require_once($this->base_dir . '/manifest.php');
				if($is_upgrade && !empty($previous_version)){
					//check if the upgrade path exists
					if(!empty($upgrade_manifest)){
						if(!empty($upgrade_manifest['upgrade_paths'])){
							if(!empty($upgrade_manifest['upgrade_paths'][$previous_version])){
								$installdefs = 	$upgrade_manifest['upgrade_paths'][$previous_version];
							}else{
								$errors[] = 'No Upgrade Path Found in manifest.';
								$this->abort($errors);
							}//fi
						}//fi
					}//fi
				}//fi
				$this->id_name = $installdefs['id'];
				$this->installdefs = $installdefs;
				$installed_modules = array();
				if(isset($installdefs['beans'])){

					if(!file_exists("custom/Extension/application/Ext/Include")){
						mkdir_recursive("custom/Extension/application/Ext/Include", true);
					}
					rename("custom/Extension/application/Ext/Include/".DISABLED_PATH.'/'. $this->id_name . '.php',"custom/Extension/application/Ext/Include/$this->id_name.php");
					$this->merge_files('Ext/Include', 'modules.ext.php', '', true);
				}
				if(!$this->silent){
					$current_step++;
					update_progress_bar('install', $current_step, $total_steps);
				}

				foreach($tasks as $task){
					$this->$task();
					if(!$this->silent){
						$current_step++;
						update_progress_bar('install', $current_step, $total_steps);
					}
				}

				if(!$this->silent){
					$current_step++;
					update_progress_bar('install', $current_step, $total_steps);
					echo '</div>';
				}

				$GLOBALS['log']->debug('Complete');

		}else{
			die("No \$installdefs Defined In $this->base_dir/manifest.php");
		}

	}
	function disable($base_dir){
		global $app_strings;
		$total_steps = 4; //min steps with no tasks
		$current_step = 0;
		$this->base_dir = $base_dir;
		$tasks = array(
							'disable_copy',
							'disable_menus',
							'disable_dashlets',
							'disable_userpage',
							'disable_administration',
							'disable_vardefs',
							'disable_layoutdefs',
							'disable_relationships',
							'disable_languages',
							);
		$total_steps += count($tasks); //now the real number of steps
		if(file_exists($this->base_dir . '/manifest.php')){
				if(!$this->silent){
					$current_step++;
					display_progress_bar('install', $current_step, $total_steps);
					echo '<div id ="displayLoglink" ><a href="#" onclick="toggleDisplay(\'displayLog\')">'.$app_strings['LBL_DISPLAY_LOG'].'</a> </div><div id="displayLog" style="display:none">';
				}

				require_once($this->base_dir . '/manifest.php');
				$this->installdefs = $installdefs;
				$this->id_name = $this->installdefs['id'];
				$installed_modules = array();
				if(isset($this->installdefs['beans'])){
					if(!$this->silent){
						$current_step++;
						update_progress_bar('install', $total_steps, $total_steps);
					}
					mkdir_recursive("custom/Extension/application/Ext/Include/".DISABLED_PATH, true);
					rename("custom/Extension/application/Ext/Include/$this->id_name.php", "custom/Extension/application/Ext/Include/".DISABLED_PATH.'/'. $this->id_name . '.php');
					$this->merge_files('Ext/Include', 'modules.ext.php', '', true);
				}
				if(!$this->silent){
					$current_step++;
					update_progress_bar('install', $current_step, $total_steps);
				}
				foreach($tasks as $task){
					$this->$task();
					if(!$this->silent){
						$current_step++;
						update_progress_bar('install', $current_step, $total_steps);
					}
				}
				if(!$this->silent){
					$current_step++;
					update_progress_bar('install', $current_step, $total_steps);
					echo '</div>';
				}

		}else{
			die("No manifest.php Defined In $this->base_dir/manifest.php");
		}
	}
	function enable_vardef($to_module){
			$GLOBALS['log']->debug("Enabling Vardefs ..." .$to_module);
			$path = 'custom/Extension/modules/' . $to_module. '/Ext/Vardefs';
			if($to_module == 'application'){
				$path ='custom/Extension/' . $to_module. '/Ext/Vardefs';
			}
			if(!file_exists($path)){
				mkdir_recursive($path, true);
			}
			rename($path . '/'.DISABLED_PATH.'/'. $this->id_name . '.php',  $path . '/'. $this->id_name . '.php');
	}
	function enable_vardefs(){
		if(isset($this->installdefs['vardefs'])){

					foreach($this->installdefs['vardefs'] as $vardefs){
						$vardefs['from'] = str_replace('<basepath>', $this->base_dir, $vardefs['from']);
						$GLOBALS['log']->debug("Enabling Vardefs ..." . $vardefs['from'] .  " for " .$vardefs['to_module']);
						$path = 'custom/Extension/modules/' . $vardefs['to_module']. '/Ext/Vardefs';
						if($vardefs['to_module'] == 'application'){
							$path ='custom/Extension/' . $vardefs['to_module']. '/Ext/Vardefs';
						}
						if(file_exists($path . '/'.DISABLED_PATH.'/'. $this->id_name . '.php'))
							rename( $path . '/'.DISABLED_PATH.'/'. $this->id_name . '.php', $path . '/'. $this->id_name . '.php');
					}
					$this->rebuild_vardefs();
				}
	}
	function disable_vardefs(){
		$GLOBALS['log']->debug("Disabling Vardefs ".var_export($this->installdefs, true));
		if(isset($this->installdefs['vardefs'])){

					foreach($this->installdefs['vardefs'] as $vardefs){
						$vardefs['from'] = str_replace('<basepath>', $this->base_dir, $vardefs['from']);
						$GLOBALS['log']->debug("Disabling Vardefs ..." . $vardefs['from'] .  " for " .$vardefs['to_module']);
						$path = 'custom/Extension/modules/' . $vardefs['to_module']. '/Ext/Vardefs';
						if($vardefs['to_module'] == 'application'){
							$path ='custom/Extension/' . $vardefs['to_module']. '/Ext/Vardefs';
						}
						mkdir_recursive($path . '/'.DISABLED_PATH, true);
						if(file_exists($path . '/'. $this->id_name . '.php'))
							rename( $path . '/'. $this->id_name . '.php', $path . '/'.DISABLED_PATH.'/'. $this->id_name . '.php');
					}
					$this->rebuild_vardefs();
				}
	}

	function enable_relationships(){
		if(isset($this->installdefs['relationships'])){
			$str = "<?php \n //WARNING: The contents of this file are auto-generated\n";
			$save_table_dictionary = false;
			foreach($this->installdefs['relationships'] as $relationship){

						$filename	=basename($relationship['meta_data']);

						$save_table_dictionary  = true;
						$str .= "include_once('metadata/$filename');\n";
						if(!empty($relationship['module_vardefs'])){
							$this->enable_vardef($relationship['module']);
						}
						if(!empty($relationship['module_layoutdefs'])){
							$this->enable_layoutdef($relationship['module']);
						}
					}
				$this->rebuild_vardefs();
				$this->rebuild_layoutdefs();
				if($save_table_dictionary){
					if(!file_exists("custom/Extension/application/Ext/TableDictionary")){
						mkdir_recursive("custom/Extension/application/Ext/TableDictionary", true);
					}
					rename("custom/Extension/application/Ext/TableDictionary/".DISABLED_PATH."/$this->id_name.php", "custom/Extension/application/Ext/TableDictionary/$this->id_name.php");
					$this->rebuild_tabledictionary();
				}


			}
	}

	function disable_relationships($action = 'disable'){
		if(isset($this->installdefs['relationships'])){
					foreach($this->installdefs['relationships'] as $relationship){
						$filename	=basename($relationship['meta_data']);


						//remove the vardefs
						$path = 'custom/Extension/modules/' . $relationship['module']. '/Ext/Vardefs';
						if($relationship['module'] == 'application'){
							$path ='custom/Extension/' . $relationship['module']. '/Ext/Vardefs';
						}
						if(!empty($relationship['module_vardefs']) && file_exists($path . '/'. $this->id_name . '.php')){
							mkdir_recursive($path . '/'.DISABLED_PATH, true);
							rename( $path . '/'. $this->id_name . '.php', $path . '/'.DISABLED_PATH.'/'. $this->id_name . '.php');
						}
						//remove the layoutdefs
						$path = 'custom/Extension/modules/' . $relationship['module']. '/Ext/Layoutdefs';
						if($relationship['module'] == 'application'){
							$path ='custom/Extension/' . $relationship['module']. '/Ext/Layoutdefs';
						}

						if(!empty($relationship['module_layoutdefs']) && file_exists($path . '/'. $this->id_name . '.php')){
							mkdir_recursive($path . '/'.DISABLED_PATH, true);
							rename( $path . '/'. $this->id_name . '.php', $path . '/'.DISABLED_PATH.'/'. $this->id_name . '.php');
						}

					}
					if(file_exists("custom/Extension/application/Ext/TableDictionary/$this->id_name.php")){
						mkdir_recursive("custom/Extension/application/Ext/TableDictionary/".DISABLED_PATH, true);
						rename("custom/Extension/application/Ext/TableDictionary/$this->id_name.php", "custom/Extension/application/Ext/TableDictionary/".DISABLED_PATH."/$this->id_name.php");
					}
					$this->rebuild_tabledictionary();
					$this->rebuild_vardefs();
					$this->rebuild_layoutdefs();
				}
	}

	function enable_layoutdefs(){
		if(isset($this->installdefs['layoutdefs'])){
			foreach($this->installdefs['layoutdefs'] as $layoutdefs){
				$this->enable_layoutdef($layoutdefs['to_module'], $this->id_name);
			}
			$this->rebuild_layoutdefs();
		}
	}
	function enable_layoutdef($to_module){
			$GLOBALS['log']->debug("Enabling Layout Defs ..." .$to_module);
			$path = 'custom/Extension/modules/' . $to_module. '/Ext/Layoutdefs';
			if($to_module == 'application'){
				$path ='custom/Extension/' . $to_module. '/Ext/Layoutdefs';
			}
			if(!file_exists($path)){
				mkdir_recursive($path, true);
			}
			rename($path . '/'.DISABLED_PATH.'/'. $this->id_name . '.php',  $path . '/'. $this->id_name . '.php');
	}

	function disable_layoutdefs(){
		if(isset($this->installdefs['layoutdefs'])){

					foreach($this->installdefs['layoutdefs'] as $layoutdefs){
						$layoutdefs['from'] = str_replace('<basepath>', $this->base_dir, $layoutdefs['from']);
						$GLOBALS['log']->debug("Disabling Layoutdefs ..." . $layoutdefs['from'] .  " for " .$layoutdefs['to_module']);
						$path = 'custom/Extension/modules/' . $layoutdefs['to_module']. '/Ext/Layoutdefs';
						if($layoutdefs['to_module'] == 'application'){
							$path ='custom/Extension/' . $layoutdefs['to_module']. '/Ext/Layoutdefs';
						}
						mkdir_recursive($path . '/'.DISABLED_PATH, true);
						rename( $path . '/'. $this->id_name . '.php', $path . '/'.DISABLED_PATH.'/'. $this->id_name . '.php');
					}
					$this->rebuild_layoutdefs();
				}
	}

	function enable_menus(){
		if(isset($this->installdefs['menu'])){
					foreach($this->installdefs['menu'] as $menu){
						$menu['from'] = str_replace('<basepath>', $this->base_dir, $menu['from']);
						$GLOBALS['log']->debug("Enabling Menu ..." . $menu['from'].  " for " .$menu['to_module'] );
						$path = 'custom/Extension/modules/' . $menu['to_module']. '/Ext/Menus';
						if($menu['to_module'] == 'application'){
							$path ='custom/Extension/' . $menu['to_module']. '/Ext/Menus';
						}
						if(!file_exists($path)){
							mkdir_recursive($path, true);

						}
						rename($path . '/'.DISABLED_PATH.'/'. $this->id_name . '.php',  $path . '/'. $this->id_name . '.php');
					}
					$this->rebuild_menus();
		}

	}

	function disable_menus(){
		if(isset($this->installdefs['menu'])){
					foreach($this->installdefs['menu'] as $menu){
						$menu['from'] = str_replace('<basepath>', $this->base_dir, $menu['from']);
						$GLOBALS['log']->debug("Disabling Menu ..." . $menu['from'].  " for " .$menu['to_module'] );
						$path = 'custom/Extension/modules/' . $menu['to_module']. '/Ext/Menus';
						if($menu['to_module'] == 'application'){
							$path ='custom/Extension/' . $menu['to_module']. '/Ext/Menus';
						}
						mkdir_recursive($path . '/'.DISABLED_PATH, true);
						rename( $path . '/'. $this->id_name . '.php', $path . '/'.DISABLED_PATH.'/'. $this->id_name . '.php');
					}
					$this->rebuild_menus();
				}
	}

	function enable_administration(){
		if(isset($this->installdefs['administration'])){
					foreach($this->installdefs['administration'] as $administration){
						$administration['from'] = str_replace('<basepath>', $this->base_dir, $administration['from']);
						$GLOBALS['log']->debug("Installing Administration Section ..." . $administration['from'] );
						$path = 'custom/Extension/modules/Administration/Ext/Administration';
						if(!file_exists($path)){
							mkdir_recursive($path, true);

						}
						rename($path . '/'.DISABLED_PATH.'/'. $this->id_name . '.php',  $path . '/'. $this->id_name . '.php');
					}
					$this->rebuild_administration();
				}

	}
	function disable_administration(){
			if(isset($this->installdefs['administration'])){
					foreach($this->installdefs['administration'] as $administration){
						$administration['from'] = str_replace('<basepath>', $this->base_dir, $administration['from']);
						$GLOBALS['log']->debug("Uninstalling Administration Section ..." . $administration['from'] );
						$path = 'custom/Extension/modules/Administration/Ext/Administration';
						mkdir_recursive($path . '/'.DISABLED_PATH, true);
						rename( $path . '/'. $this->id_name . '.php', $path . '/'.DISABLED_PATH.'/'. $this->id_name . '.php');
					}
					$this->rebuild_administration();
				}
	}

	function enable_dashlets(){
		if(isset($this->installdefs['dashlets'])){
			foreach($this->installdefs['dashlets'] as $cp){
				$cp['from'] = str_replace('<basepath>', $this->base_dir, $cp['from']);
				$path = 'custom/modules/Home/Dashlets/' . $cp['name'] . '/';
				$disabled_path = 'custom/modules/Home/'.DISABLED_PATH.'Dashlets/' . $cp['name'];
				$GLOBALS['log']->debug("Enabling Dashlet " . $cp['name'] . "..." . $cp['from'] );

				rename($disabled_path,  $path);
			}
			include('modules/Administration/RebuildDashlets.php');

		}
	}

	function disable_dashlets(){
		if(isset($this->installdefs['dashlets'])){
					foreach($this->installdefs['dashlets'] as $cp){
						$path = 'custom/modules/Home/Dashlets/' . $cp['name'];
						$disabled_path = 'custom/modules/Home/'.DISABLED_PATH.'Dashlets/' . $cp['name'];
						$GLOBALS['log']->debug('Disabling ' .$path);
						mkdir_recursive('custom/modules/Home/'.DISABLED_PATH.'Dashlets/', true);
						rename( $path, $disabled_path);
					}
					include('modules/Administration/RebuildDashlets.php');
				}
	}

	function enable_languages(){
		$languages = array();
				if(isset($this->installdefs['language'])){
					foreach($this->installdefs['language'] as $packs){
						$languages[$packs['language']] = $packs['language'];
						$packs['from'] = str_replace('<basepath>', $this->base_dir, $packs['from']);
						$GLOBALS['log']->debug("Installing Language Pack ..." . $packs['from']  .  " for " .$packs['to_module']);
						$path = 'custom/Extension/modules/' . $packs['to_module']. '/Ext/Language';
						if($packs['to_module'] == 'application'){
							$path ='custom/Extension/' . $packs['to_module']. '/Ext/Language';
						}

						if(!file_exists($path)){
							mkdir_recursive($path, true);

						}
						rename($path.'/'.DISABLED_PATH.'/'.$packs['language'].'.'. $this->id_name . '.php',  $path.'/'.$packs['language'].'.'. $this->id_name . '.php');
					}
					$this->rebuild_languages($languages);

				}
	}

	function disable_languages(){
		$languages = array();
				if(isset($this->installdefs['language'])){
					foreach($this->installdefs['language'] as $packs){
						$languages[] = $packs['language'];
						$packs['from'] = str_replace('<basepath>', $this->base_dir, $packs['from']);
						$GLOBALS['log']->debug("Uninstalling Language Pack ..." . $packs['from']  .  " for " .$packs['to_module']);
						$path = 'custom/Extension/modules/' . $packs['to_module']. '/Ext/Language';
						if($packs['to_module'] == 'application'){
							$path ='custom/Extension/' . $packs['to_module']. '/Ext/Language';
						}
						mkdir_recursive($path . '/'.DISABLED_PATH, true);
						rename($path.'/'.$packs['language'].'.'. $this->id_name . '.php', $path.'/'.DISABLED_PATH.'/'.$packs['language'].'.'. $this->id_name . '.php');
					}
					$this->rebuild_languages($languages);

				}
	}

	function enable_userpage(){
		if(isset($this->installdefs['user_page'])){
					foreach($this->installdefs['user_page'] as $userpage){
						$userpage['from'] = str_replace('<basepath>', $this->base_dir, $userpage['from']);
						$GLOBALS['log']->debug("Installing User Page Section ..." . $userpage['from'] );
						$path = 'custom/Extension/modules/Users/Ext/UserPage';
						if(!file_exists($path)){
							mkdir_recursive($path, true);

						}
						rename($path . '/'.DISABLED_PATH.'/'. $this->id_name . '.php',  $path . '/'. $this->id_name . '.php');
					}
					$this->rebuild_userpage();
				}

	}
	function disable_userpage(){
			if(isset($this->installdefs['user_page'])){
					foreach($this->installdefs['user_page'] as $userpage){
						$userpage['from'] = str_replace('<basepath>', $this->base_dir, $userpage['from']);
						$GLOBALS['log']->debug("Uninstalling User Page Section ..." . $userpage['from'] );
						$path = 'custom/Extension/modules/Users/Ext/UserPage';
						mkdir_recursive($path . '/'.DISABLED_PATH, true);
						rename( $path . '/'. $this->id_name . '.php', $path . '/'.DISABLED_PATH.'/'. $this->id_name . '.php');
					}
					$this->rebuild_userpage();
				}
	}

	function enable_copy(){
		//copy files back onto file system. first perform md5 check to determine if anything has been modified
		//here we should just go through the files in the -restore directory and copy those back
		if(isset($GLOBALS['mi_overwrite_files']) && $GLOBALS['mi_overwrite_files']){
			if(!empty($this->installdefs['copy'])){
				foreach($this->installdefs['copy'] as $cp){
					$cp['to'] = clean_path(str_replace('<basepath>', $this->base_dir, $cp['to']));
					$backup_path = clean_path( remove_file_extension(urldecode($_REQUEST['install_file']))."-restore/".$cp['to'] );

					//check if this file exists in the -restore directory
					if(file_exists($backup_path)){
						//since the file exists, then we want do an md5 of the install version and the file system version
						//if(is_file($backup_path) && md5_file($backup_path) == md5_file($cp['to'])){
							//since the files are the same then we can safely move back from the -restore
							//directory into the file system
							$GLOBALS['log']->debug("ENABLE COPY:: FROM: ".$cp['from']. " TO: ".$cp['to']);
							$this->copy_path($cp['from'], $cp['to']);
						/*}else{
							//since they are not equal then we need to prompt the user
						}*/
					}//fi
				}//rof
			}//fi
		}//fi
	}

	function disable_copy(){
		//when we disable we want to copy the -restore files back into the file system
		//but we should check the version in the module install against the version on the file system
		//if they match then we can copy the file back, but otherwise we should ask the user.

//		$GLOBALS['log']->debug('ModuleInstaller.php->disable_copy()');		
		if(isset($GLOBALS['mi_overwrite_files']) && $GLOBALS['mi_overwrite_files']){
//		$GLOBALS['log']->debug('ModuleInstaller.php->disable_copy():mi_overwrite_files=true');	
			if(!empty($this->installdefs['copy'])){
//				$GLOBALS['log']->debug('ModuleInstaller.php->disable_copy(): installdefs not empty');	
				foreach($this->installdefs['copy'] as $cp){
					$cp['to'] = clean_path(str_replace('<basepath>', $this->base_dir, $cp['to']));
					$backup_path = clean_path( remove_file_extension(urldecode($_REQUEST['install_file']))."-restore/".$cp['to'] ); // bug 16966 tyoung - replaced missing assignment to $backup_path
					//check if this file exists in the -restore directory
//					$GLOBALS['log']->debug("ModuleInstaller.php->disable_copy(): backup_path=".$backup_path);
					if(file_exists($backup_path)){
						//since the file exists, then we want do an md5 of the install version and the file system version
						$from = str_replace('<basepath>', $this->base_dir, $cp['from']);

						//if(is_file($from) && md5_file($from) == md5_file($cp['to'])){
							//since the files are the same then we can safely move back from the -restore
							//directory into the file system
							$GLOBALS['log']->debug("DISABLE COPY:: FROM: ".$backup_path. " TO: ".$cp['to']);
							$this->copy_path($backup_path, $cp['to']);
						/*}else{
							//since they are not equal then we need to prompt the user
						}*/
					}//fi
				}//rof
			}//fi
		}//fi
	}
}
?>
