/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.utility;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.local.LockOperation;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.core.operation.local.UnlockOperation;
import org.eclipse.team.svn.core.operation.remote.BreakLockOperation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.lock.LockResource;
import org.eclipse.team.svn.ui.lock.LockResourcesPanel;
import org.eclipse.team.svn.ui.operation.RefreshRemoteResourcesOperation;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class LockProposeUtility {
    public static IStatus proposeLock(IResource[] resources, Shell shell) {
        CompositeOperation op = LockProposeUtility.performLockAction(resources, false, shell);
        if (op != null) {
            UIMonitorUtility.doTaskBusyDefault((IActionOperation)op);
            return op.getStatus();
        }
        return Status.CANCEL_STATUS;
    }

    public static IResource[] asResources(LockResource[] lockResources) {
        ArrayList<IResource> res = new ArrayList<IResource>();
        if (lockResources != null) {
            int i = 0;
            while (i < lockResources.length) {
                Object ob = lockResources[i].getAdapter(IResource.class);
                if (ob != null) {
                    res.add((IResource)ob);
                }
                ++i;
            }
        }
        return res.toArray(new IResource[res.size()]);
    }

    public static IRepositoryResource[] asRepositoryResources(LockResource[] lockResources) {
        ArrayList<IRepositoryResource> res = new ArrayList<IRepositoryResource>();
        if (lockResources != null) {
            int i = 0;
            while (i < lockResources.length) {
                Object ob = lockResources[i].getAdapter(IRepositoryResource.class);
                if (ob != null) {
                    res.add((IRepositoryResource)ob);
                }
                ++i;
            }
        }
        return res.toArray(new IRepositoryResource[res.size()]);
    }

    public static CompositeOperation performLockAction(IResource[] resourcesToProcess, boolean forceLock, Shell shell) {
        LockResource[] lockResources = LockResource.getLockResources(resourcesToProcess, false);
        return LockProposeUtility.performLockAction(lockResources, forceLock, shell);
    }

    public static CompositeOperation performLockAction(LockResource[] lockResources, boolean forceLock, Shell shell) {
        LockResourcesPanel panel = new LockResourcesPanel(lockResources, true, forceLock, SVNUIMessages.LocksComposite_LockTitle, SVNUIMessages.LocksComposite_LockDescription, SVNUIMessages.LocksComposite_LockDefaultMessage);
        DefaultDialog dlg = new DefaultDialog(shell, panel);
        if (dlg.open() == 0) {
            IResource[] resources = LockProposeUtility.asResources(panel.getSelectedResources());
            LockOperation mainOp = new LockOperation(resources, panel.getMessage(), panel.getForce());
            CompositeOperation op = new CompositeOperation(mainOp.getId(), mainOp.getMessagesClass());
            op.add((IActionOperation)mainOp);
            op.add((IActionOperation)new RefreshResourcesOperation(resources));
            return op;
        }
        return null;
    }

    public static CompositeOperation performUnlockAction(IResource[] resourcesToProcess, Shell shell) {
        LockResource[] lockResources = LockResource.getLockResources(resourcesToProcess, true);
        return LockProposeUtility.performUnlockAction(lockResources, shell);
    }

    public static CompositeOperation performUnlockAction(LockResource[] lockResources, Shell shell) {
        LockResourcesPanel unlockPanel = new LockResourcesPanel(lockResources, SVNUIMessages.LocksComposite_UnlockTitle, SVNUIMessages.LocksComposite_UnlockDescription, SVNUIMessages.LocksComposite_UnlockDefaultMessage);
        DefaultDialog dlg = new DefaultDialog(shell, unlockPanel);
        if (dlg.open() == 0) {
            IResource[] resources = LockProposeUtility.asResources(unlockPanel.getSelectedResources());
            UnlockOperation mainOp = new UnlockOperation(resources);
            CompositeOperation op = new CompositeOperation(mainOp.getId(), mainOp.getMessagesClass());
            op.add((IActionOperation)mainOp);
            op.add((IActionOperation)new RefreshResourcesOperation(resources));
            return op;
        }
        return null;
    }

    public static CompositeOperation performBreakLockAction(LockResource[] lockResources, Shell shell) {
        LockResourcesPanel panel = new LockResourcesPanel(lockResources, SVNUIMessages.LocksComposite_BreakLockTitle, SVNUIMessages.LocksComposite_BreakLockDescription, SVNUIMessages.LocksComposite_BreakLockDefaultMessage);
        DefaultDialog dlg = new DefaultDialog(shell, panel);
        if (dlg.open() == 0) {
            IRepositoryResource[] reposResources = LockProposeUtility.asRepositoryResources(panel.getSelectedResources());
            BreakLockOperation mainOp = new BreakLockOperation(reposResources);
            CompositeOperation op = new CompositeOperation(mainOp.getId(), mainOp.getMessagesClass());
            op.add((IActionOperation)mainOp);
            op.add((IActionOperation)new RefreshRemoteResourcesOperation(reposResources));
            return op;
        }
        return null;
    }
}

