/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.action.local.management;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.svn.ui.action.AbstractLocalTeamAction;
import org.eclipse.team.svn.ui.wizard.ShareProjectWizard;

public class ShareProjectsAction
extends AbstractLocalTeamAction {
    public void runImpl(IAction action) {
        IProject[] projects = this.getProjectsToShare();
        ShareProjectWizard wizard = new ShareProjectWizard();
        wizard.init(projects);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.setPageSize(500, 400);
        dialog.open();
    }

    protected IProject[] getProjectsToShare() {
        HashSet<IProject> projects = new HashSet<IProject>(Arrays.asList(this.getSelectedProjects()));
        Iterator<IProject> it = projects.iterator();
        while (it.hasNext()) {
            IProject project = it.next();
            if (project.isAccessible() && RepositoryProvider.getProvider((IProject)project) == null) continue;
            it.remove();
        }
        return projects.toArray(new IProject[projects.size()]);
    }

    public boolean isEnabled() {
        IProject[] projects = this.getSelectedProjects();
        int i = 0;
        while (i < projects.length) {
            if (projects[i].isAccessible() && RepositoryProvider.getProvider((IProject)projects[i]) == null) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

