/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.connector;

import java.util.ArrayList;
import java.util.Stack;
import org.eclipse.team.svn.core.connector.ISVNLogEntryCallback;
import org.eclipse.team.svn.core.connector.SVNLogEntry;

public class SVNLogEntryCallbackWithMergeInfo
implements ISVNLogEntryCallback {
    protected Stack<SVNLogEntry> mergeTreeBuilder = new Stack();
    protected ArrayList<SVNLogEntry> entries = new ArrayList();

    public void next(SVNLogEntry log) {
        if (log.revision == -1L) {
            if (!this.mergeTreeBuilder.isEmpty()) {
                log = this.mergeTreeBuilder.pop();
                if (this.mergeTreeBuilder.isEmpty()) {
                    this.addEntry(log);
                }
            }
            return;
        }
        if (!this.mergeTreeBuilder.isEmpty()) {
            this.addChildEntry(this.mergeTreeBuilder.peek(), log);
        } else if (!log.hasChildren()) {
            this.addEntry(log);
        }
        if (log.hasChildren()) {
            this.mergeTreeBuilder.push(log);
        }
    }

    protected void addEntry(SVNLogEntry entry) {
        this.entries.add(entry);
    }

    protected void addChildEntry(SVNLogEntry parent, SVNLogEntry child) {
        parent.add(child);
    }

    public SVNLogEntry[] getEntries() {
        return this.entries.toArray(new SVNLogEntry[this.entries.size()]);
    }
}

