/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.operation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.ActivityCancelledException;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.revision.graph.PathRevision;
import org.eclipse.team.svn.revision.graph.SVNRevisionGraphMessages;
import org.eclipse.team.svn.revision.graph.cache.CacheChangedPath;
import org.eclipse.team.svn.revision.graph.cache.CacheChangedPathWithRevision;
import org.eclipse.team.svn.revision.graph.cache.CacheRevision;
import org.eclipse.team.svn.revision.graph.cache.RepositoryCache;
import org.eclipse.team.svn.revision.graph.cache.TimeMeasure;
import org.eclipse.team.svn.revision.graph.operation.IRepositoryCacheProvider;
import org.eclipse.team.svn.revision.graph.operation.PathRevisionConnectionsValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateRevisionGraphModelOperation
extends AbstractActionOperation {
    protected IRepositoryResource resource;
    protected IRepositoryCacheProvider cacheProvider;
    protected RepositoryCache repositoryCache;
    protected PathRevisionConnectionsValidator pathRevisionValidator;
    protected PathRevision resultNode;

    public CreateRevisionGraphModelOperation(IRepositoryResource resource, IRepositoryCacheProvider cacheProvider) {
        super("Operation_CreateRevisionGraphModel", SVNRevisionGraphMessages.class);
        this.resource = resource;
        this.cacheProvider = cacheProvider;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        long revision;
        this.repositoryCache = this.cacheProvider.getRepositoryCache();
        this.pathRevisionValidator = new PathRevisionConnectionsValidator(this.repositoryCache);
        TimeMeasure processMeasure = new TimeMeasure("Create model");
        String url = this.resource.getUrl();
        String rootUrl = this.resource.getRepositoryLocation().getRepositoryRootUrl();
        SVNRevision svnRevision = this.resource.getSelectedRevision();
        String path = url.substring(rootUrl.length());
        int pathIndex = this.repositoryCache.getPathStorage().add(path);
        if (svnRevision.getKind() == 1) {
            revision = ((SVNRevision.Number)svnRevision).getNumber();
        } else if (svnRevision.getKind() == 7) {
            revision = this.repositoryCache.getLastProcessedRevision();
        } else {
            throw new Exception("Unexpected revision kind: " + svnRevision);
        }
        CacheRevision entry = this.findStartLogEntry(revision, pathIndex);
        if (entry != null) {
            this.resultNode = this.createRevisionNode(entry, pathIndex, false);
            this.process(this.resultNode, monitor);
        }
        processMeasure.end();
    }

    protected void process(PathRevision startNode, IProgressMonitor monitor) {
        PathRevision node;
        LinkedList<PathRevision> nodesQueue = new LinkedList<PathRevision>();
        nodesQueue.offer(startNode);
        while ((node = (PathRevision)nodesQueue.poll()) != null) {
            PathRevision copyFromNode;
            PathRevision startNodeInChain;
            if (monitor.isCanceled()) {
                throw new ActivityCancelledException();
            }
            this.createRevisionsChainForPath(node);
            Map<PathRevision, List<PathRevision>> copiedToEntries = this.findCopiedToNodesInRevisionChain(node);
            if (!copiedToEntries.isEmpty()) {
                for (Map.Entry<PathRevision, List<PathRevision>> mapEntries : copiedToEntries.entrySet()) {
                    PathRevision revisionNode = mapEntries.getKey();
                    List<PathRevision> copyToNodes = mapEntries.getValue();
                    if (copyToNodes.isEmpty()) continue;
                    PathRevision[] existingCopyToNodes = node.getCopiedTo();
                    PathRevision existingCopyToNode = existingCopyToNodes.length == 1 ? existingCopyToNodes[0] : null;
                    for (PathRevision copyToNode : copyToNodes) {
                        if (existingCopyToNode != null && copyToNode.equals(existingCopyToNode)) continue;
                        if (revisionNode.action == PathRevision.RevisionNodeAction.NONE && revisionNode.getNext() == null && revisionNode.getPrevious() == null) {
                            node.insertNodeInRevisionsChain(revisionNode);
                        }
                        revisionNode.addCopiedTo(copyToNode);
                        nodesQueue.add(copyToNode);
                    }
                }
            }
            if ((startNodeInChain = (PathRevision)node.getStartNodeInChain()).getCopiedFrom() != null || (copyFromNode = this.findCopiedFromNode(startNodeInChain)) == null) continue;
            startNodeInChain.setCopiedFrom(copyFromNode);
            nodesQueue.add(copyFromNode);
        }
    }

    protected void createRevisionsChainForPath(PathRevision node) {
        CacheRevision entry;
        PathRevision processNode;
        long rev;
        if (!this.isDeletedNode(node)) {
            rev = node.getRevision();
            processNode = node;
            while (++rev <= this.repositoryCache.getLastProcessedRevision()) {
                entry = this.getEntry(rev);
                if (entry == null) continue;
                PathRevision nextNode = this.createRevisionNode(entry, node.getPathIndex(), true);
                if (nextNode.action == PathRevision.RevisionNodeAction.NONE) continue;
                if (nextNode.action == PathRevision.RevisionNodeAction.RENAME) break;
                processNode.setNext(nextNode);
                if (this.isDeletedNode(nextNode)) break;
                processNode = nextNode;
            }
        }
        if (!this.isCreatedNode(node)) {
            rev = node.getRevision();
            processNode = node;
            while (--rev > 0L) {
                entry = this.getEntry(rev);
                if (entry == null) continue;
                PathRevision prevNode = this.createRevisionNode(entry, node.getPathIndex(), false);
                if (prevNode.action == PathRevision.RevisionNodeAction.NONE) continue;
                processNode.setPrevious(prevNode);
                if (this.isCreatedNode(prevNode)) break;
                processNode = prevNode;
            }
        }
    }

    protected boolean isCreatedNode(PathRevision node) {
        return node.action == PathRevision.RevisionNodeAction.ADD || node.action == PathRevision.RevisionNodeAction.COPY || node.action == PathRevision.RevisionNodeAction.RENAME;
    }

    protected boolean isDeletedNode(PathRevision node) {
        return node.action == PathRevision.RevisionNodeAction.DELETE;
    }

    protected void filterOutCopyToData(long startRevision, long endRevision, int path, List<CacheChangedPathWithRevision> candidateCopyToList, List<CacheChangedPathWithRevision> filteredCopyToList) {
        for (CacheChangedPathWithRevision candidateCopy : candidateCopyToList) {
            long rev = candidateCopy.getCopiedFromRevision();
            if (rev < startRevision || rev > endRevision || !this.isParentPath(candidateCopy.getCopiedFromPathIndex(), path)) continue;
            boolean canAdd = true;
            if (!filteredCopyToList.isEmpty()) {
                Iterator<CacheChangedPathWithRevision> iter = filteredCopyToList.iterator();
                while (iter.hasNext()) {
                    CacheChangedPathWithRevision existingChangedPath = iter.next();
                    if (existingChangedPath.getRevision() != candidateCopy.getRevision()) continue;
                    if (this.isParentPath(existingChangedPath.getPathIndex(), candidateCopy.getPathIndex()) && this.isParentPath(existingChangedPath.getCopiedFromPathIndex(), candidateCopy.getCopiedFromPathIndex())) {
                        iter.remove();
                        continue;
                    }
                    if (!this.isParentPath(candidateCopy.getPathIndex(), existingChangedPath.getPathIndex()) || !this.isParentPath(candidateCopy.getCopiedFromPathIndex(), existingChangedPath.getCopiedFromPathIndex())) continue;
                    canAdd = false;
                    break;
                }
            }
            if (!canAdd) continue;
            filteredCopyToList.add(candidateCopy);
        }
    }

    protected void postProcessCopyToMap(Map<PathRevision, List<PathRevision>> copyToMap) {
        if (!copyToMap.isEmpty()) {
            long renameRevision = Long.MAX_VALUE;
            for (Map.Entry<PathRevision, List<PathRevision>> entry : copyToMap.entrySet()) {
                PathRevision copyFrom = entry.getKey();
                for (PathRevision copyTo : entry.getValue()) {
                    if (copyTo.action != PathRevision.RevisionNodeAction.RENAME || renameRevision <= copyFrom.getRevision()) continue;
                    renameRevision = copyFrom.getRevision();
                }
            }
            if (renameRevision != Long.MAX_VALUE) {
                Iterator<PathRevision> iter = copyToMap.keySet().iterator();
                while (iter.hasNext()) {
                    PathRevision copyFrom = iter.next();
                    if (copyFrom.getRevision() <= renameRevision) continue;
                    iter.remove();
                }
            }
        }
    }

    protected Map<PathRevision, List<PathRevision>> findCopiedToNodesInRevisionChain(PathRevision node) {
        HashMap<PathRevision, List<PathRevision>> copyToMap = new HashMap<PathRevision, List<PathRevision>>();
        long startRevision = ((PathRevision)node.getStartNodeInChain()).getRevision();
        PathRevision endNodeInChain = (PathRevision)node.getEndNodeInChain();
        long endRevision = this.isDeletedNode(endNodeInChain) ? endNodeInChain.getRevision() : Long.MAX_VALUE;
        ArrayList<CacheChangedPathWithRevision> filteredCopyToList = new ArrayList<CacheChangedPathWithRevision>();
        int path = node.getPathIndex();
        while (path != 0) {
            this.filterOutCopyToData(startRevision, endRevision, node.getPathIndex(), this.repositoryCache.getCopiedToData(path), filteredCopyToList);
            path = this.repositoryCache.getPathStorage().getParentPathIndex(path);
        }
        for (CacheChangedPathWithRevision changedPath : filteredCopyToList) {
            List<PathRevision> copyToNodes;
            CacheRevision copyFromEntry;
            int copyToPath = -1;
            if (node.getPathIndex() == changedPath.getCopiedFromPathIndex()) {
                copyToPath = changedPath.getPathIndex();
            } else {
                int[] relativeParts = this.repositoryCache.getPathStorage().makeRelative(changedPath.getCopiedFromPathIndex(), node.getPathIndex());
                copyToPath = this.repositoryCache.getPathStorage().add(changedPath.getPathIndex(), relativeParts);
            }
            if (copyToPath == -1) continue;
            CacheRevision rsCopyTo = this.getEntry(changedPath.getRevision());
            PathRevision copyToNode = null;
            if (rsCopyTo != null) {
                copyToNode = this.createRevisionNode(rsCopyTo, copyToPath, false);
            }
            if (copyToNode == null) continue;
            PathRevision copyFromNode = node.findNodeInChain(changedPath.getCopiedFromRevision());
            if (copyFromNode == null && (copyFromEntry = this.getEntry(changedPath.getCopiedFromRevision())) != null) {
                copyFromNode = this.createRevisionNode(copyFromEntry, node.getPathIndex(), false);
            }
            if (copyFromNode == null) continue;
            if (copyToMap.containsKey(copyFromNode)) {
                copyToNodes = (List)copyToMap.get(copyFromNode);
            } else {
                copyToNodes = new ArrayList();
                copyToMap.put(copyFromNode, copyToNodes);
            }
            copyToNodes.add(copyToNode);
        }
        this.postProcessCopyToMap(copyToMap);
        return copyToMap;
    }

    protected PathRevision findCopiedFromNode(PathRevision node) {
        CacheRevision entry = this.getEntry(node.getRevision());
        if (entry != null && entry.hasChangedPaths()) {
            CacheRevision copiedFromEntry;
            CacheChangedPath parentPath = null;
            CacheChangedPath[] cacheChangedPathArray = entry.getChangedPaths();
            int n = cacheChangedPathArray.length;
            int n2 = 0;
            while (n2 < n) {
                CacheChangedPath changedPath = cacheChangedPathArray[n2];
                if (changedPath.getCopiedFromPathIndex() != -1 && this.isParentPath(changedPath.getPathIndex(), node.getPathIndex()) && (parentPath != null && this.isParentPath(parentPath.getPathIndex(), changedPath.getPathIndex()) || parentPath == null)) {
                    parentPath = changedPath;
                }
                ++n2;
            }
            if (parentPath != null && (copiedFromEntry = this.getEntry(parentPath.getCopiedFromRevision())) != null) {
                int copiedFromPath;
                if (parentPath.getPathIndex() == node.getPathIndex()) {
                    copiedFromPath = parentPath.getCopiedFromPathIndex();
                } else {
                    int[] relativeParts = this.repositoryCache.getPathStorage().makeRelative(parentPath.getPathIndex(), node.getPathIndex());
                    copiedFromPath = this.repositoryCache.getPathStorage().add(parentPath.getCopiedFromPathIndex(), relativeParts);
                }
                return this.createRevisionNode(copiedFromEntry, copiedFromPath, false);
            }
        }
        return null;
    }

    protected CacheRevision findStartLogEntry(long revision, int path) {
        long i = revision;
        while (i > 0L) {
            CacheRevision entry = this.getEntry(i);
            if (entry != null && entry.hasChangedPaths()) {
                CacheChangedPath[] cacheChangedPathArray = entry.getChangedPaths();
                int n = cacheChangedPathArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CacheChangedPath changedPath = cacheChangedPathArray[n2];
                    if (this.isParentPath(changedPath.getPathIndex(), path) && (changedPath.getAction() == 'A' || changedPath.getCopiedFromPathIndex() != -1)) {
                        return entry;
                    }
                    ++n2;
                }
            }
            --i;
        }
        return null;
    }

    protected PathRevision createRevisionNode(CacheRevision entry, int pathIndex, boolean isChooseDeleteActionInReplace) {
        int nodePath = pathIndex;
        PathRevision.RevisionNodeAction action = PathRevision.RevisionNodeAction.NONE;
        if (entry.hasChangedPaths()) {
            CacheChangedPath parentPath = null;
            CacheChangedPath childPath = null;
            CacheChangedPath[] cacheChangedPathArray = entry.getChangedPaths();
            int n = cacheChangedPathArray.length;
            int n2 = 0;
            while (n2 < n) {
                CacheChangedPath changedPath = cacheChangedPathArray[n2];
                if (this.isParentPath(changedPath.getPathIndex(), pathIndex)) {
                    if (parentPath != null) {
                        CacheChangedPath child;
                        CacheChangedPath parent;
                        if (this.isParentPath(parentPath.getPathIndex(), changedPath.getPathIndex())) {
                            parent = parentPath;
                            child = changedPath;
                        } else {
                            parent = changedPath;
                            child = parentPath;
                        }
                        parentPath = child.getAction() != 'M' ? child : (parent.getAction() != 'M' ? parent : child);
                    } else {
                        parentPath = changedPath;
                    }
                }
                if (this.isParentPath(pathIndex, changedPath.getPathIndex()) && (childPath != null && this.isParentPath(changedPath.getPathIndex(), childPath.getPathIndex()) || childPath == null)) {
                    childPath = changedPath;
                }
                ++n2;
            }
            if (parentPath != null) {
                CacheChangedPath renamedLogPath = this.checkRenameAction(parentPath, entry);
                if (renamedLogPath != null) {
                    action = PathRevision.RevisionNodeAction.RENAME;
                    if (parentPath.getAction() == 'D') {
                        nodePath = renamedLogPath.getPathIndex();
                        if (this.repositoryCache.getPathStorage().isParentIndex(parentPath.getPathIndex(), pathIndex)) {
                            int[] relativeParts = this.repositoryCache.getPathStorage().makeRelative(parentPath.getPathIndex(), pathIndex);
                            nodePath = this.repositoryCache.getPathStorage().add(nodePath, relativeParts);
                        }
                    } else {
                        nodePath = pathIndex;
                    }
                } else if (this.isAddOnlyAction(parentPath)) {
                    action = PathRevision.RevisionNodeAction.ADD;
                } else if (this.isCopyAction(parentPath)) {
                    action = PathRevision.RevisionNodeAction.COPY;
                } else if (this.isDeleteAction(parentPath)) {
                    action = PathRevision.RevisionNodeAction.DELETE;
                }
                if (this.isCopyAction(parentPath) && parentPath.getAction() == 'R' && isChooseDeleteActionInReplace) {
                    action = PathRevision.RevisionNodeAction.DELETE;
                }
            }
            if (action == PathRevision.RevisionNodeAction.NONE && childPath != null && this.isModifyAction(pathIndex, childPath)) {
                action = PathRevision.RevisionNodeAction.MODIFY;
            }
        }
        PathRevision.ReviosionNodeType type = PathRevision.ReviosionNodeType.OTHER;
        if (this.resource.getRepositoryLocation().isStructureEnabled() && (action == PathRevision.RevisionNodeAction.ADD || action == PathRevision.RevisionNodeAction.COPY)) {
            Path pPath = new Path(this.repositoryCache.getPathStorage().getPath(nodePath));
            String[] segments = pPath.segments();
            int i = 0;
            while (i < segments.length) {
                if (this.resource.getRepositoryLocation().getTrunkLocation().equals(segments[i])) {
                    type = PathRevision.ReviosionNodeType.TRUNK;
                    break;
                }
                if (this.resource.getRepositoryLocation().getBranchesLocation().equals(segments[i])) {
                    type = PathRevision.ReviosionNodeType.BRANCH;
                    break;
                }
                if (this.resource.getRepositoryLocation().getTagsLocation().equals(segments[i])) {
                    type = PathRevision.ReviosionNodeType.TAG;
                    break;
                }
                ++i;
            }
        }
        PathRevision node = new PathRevision(entry, nodePath, action, type);
        node.setValidator(this.pathRevisionValidator);
        return node;
    }

    protected boolean isDeleteAction(CacheChangedPath parentChangedPath) {
        return parentChangedPath.getAction() == 'D' || parentChangedPath.getAction() == 'R';
    }

    protected boolean isAddOnlyAction(CacheChangedPath parentChangedPath) {
        return parentChangedPath.getAction() == 'A' && parentChangedPath.getCopiedFromPathIndex() == -1;
    }

    protected boolean isCopyAction(CacheChangedPath parentChangedPath) {
        return parentChangedPath.getCopiedFromPathIndex() != -1;
    }

    protected CacheChangedPath checkRenameAction(CacheChangedPath parentChangedPath, CacheRevision parentEntry) {
        CacheChangedPath chPath;
        int n;
        int n2;
        CacheChangedPath[] cacheChangedPathArray;
        if (parentChangedPath.getAction() == 'D') {
            cacheChangedPathArray = parentEntry.getChangedPaths();
            n2 = cacheChangedPathArray.length;
            n = 0;
            while (n < n2) {
                chPath = cacheChangedPathArray[n];
                if (this.isCopyAction(chPath) && chPath.getCopiedFromPathIndex() == parentChangedPath.getPathIndex()) {
                    return chPath;
                }
                ++n;
            }
        }
        if (this.isCopyAction(parentChangedPath)) {
            cacheChangedPathArray = parentEntry.getChangedPaths();
            n2 = cacheChangedPathArray.length;
            n = 0;
            while (n < n2) {
                chPath = cacheChangedPathArray[n];
                if (chPath.getAction() == 'D' && chPath.getPathIndex() == parentChangedPath.getCopiedFromPathIndex()) {
                    return parentChangedPath;
                }
                ++n;
            }
        }
        return null;
    }

    protected boolean isModifyAction(int path, CacheChangedPath childChangedPath) {
        return childChangedPath.getPathIndex() == path ? childChangedPath.getAction() == 'M' : true;
    }

    protected boolean isParentPath(int parentPathIndex, int childPathIndex) {
        return this.repositoryCache.getPathStorage().isParentIndex(parentPathIndex, childPathIndex);
    }

    protected CacheRevision getEntry(long revision) {
        return this.repositoryCache.getRevision(revision);
    }

    public PathRevision getModel() {
        return this.resultNode;
    }

    public IRepositoryResource getResource() {
        return this.resource;
    }

    public RepositoryCache getRepositoryCache() {
        return this.repositoryCache;
    }

    protected String getPath(int pathIndex) {
        return this.repositoryCache.getPathStorage().getPath(pathIndex);
    }
}

