/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.revision.graph.SVNRevisionGraphMessages;
import org.eclipse.team.svn.revision.graph.cache.RepositoryCache;
import org.eclipse.team.svn.revision.graph.operation.CheckRepositoryConnectionOperation;
import org.eclipse.team.svn.revision.graph.operation.FetchNewRevisionsOperation;
import org.eclipse.team.svn.revision.graph.operation.FetchSkippedRevisionsOperation;
import org.eclipse.team.svn.revision.graph.operation.PrepareRevisionDataOperation;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class RepositoryCacheInfo {
    protected static final String START_SKIPPED_REVISION = "startSkippedRevision";
    protected static final String END_SKIPPED_REVISION = "endSkippedRevision";
    protected static final String LAST_PROCESSED_REVISION = "lastProcessedRevision";
    protected static final String CACHE_DATA_FILE_NAME = "dataFileName";
    protected long startSkippedRevision;
    protected long endSkippedRevision;
    protected long lastProcessedRevision;
    protected String cacheDataFileName;
    protected final String repositoryName;
    protected final File metadataFile;
    protected boolean isCalculating;
    protected int cacheReferencesCount;
    protected RepositoryCache repositoryCache;
    protected Set<IRepositoryResource> resourcesForWhichCacheIsOpened = new HashSet<IRepositoryResource>();
    protected final Object calculateLock = new Object();

    public RepositoryCacheInfo(String repositoryName, File metadataFile) {
        this.repositoryName = repositoryName;
        this.metadataFile = metadataFile;
        this.startSkippedRevision = 0L;
        this.endSkippedRevision = 0L;
        this.lastProcessedRevision = 0L;
        this.cacheDataFileName = RepositoryCacheInfo.getCacheDataFileName(this.metadataFile.getName());
    }

    public static String getCacheDataFileName(String metadataFileName) {
        int index = metadataFileName.lastIndexOf(".");
        String cacheDataFileName = index != -1 ? String.valueOf(metadataFileName.substring(0, index)) + ".data" : String.valueOf(metadataFileName) + ".data";
        return cacheDataFileName;
    }

    public void load() throws IOException {
        if (this.metadataFile.exists()) {
            Properties props = new Properties();
            FileInputStream in = new FileInputStream(this.metadataFile);
            try {
                props.load(in);
                this.startSkippedRevision = this.getLongProperty(props, START_SKIPPED_REVISION);
                this.endSkippedRevision = this.getLongProperty(props, END_SKIPPED_REVISION);
                this.lastProcessedRevision = this.getLongProperty(props, LAST_PROCESSED_REVISION);
                this.cacheDataFileName = this.getProperty(props, CACHE_DATA_FILE_NAME);
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected String getProperty(Properties props, String propertyName) {
        String value = props.getProperty(propertyName);
        if (value != null && (value = value.trim()).length() == 0) {
            value = null;
        }
        return value;
    }

    protected long getLongProperty(Properties props, String propertyName) {
        long res = 0L;
        String value = props.getProperty(propertyName);
        if (value != null && (value = value.trim()).length() > 0) {
            try {
                res = Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return res;
    }

    public void save() throws IOException {
        Properties props = new Properties();
        props.put(START_SKIPPED_REVISION, String.valueOf(this.startSkippedRevision));
        props.put(END_SKIPPED_REVISION, String.valueOf(this.endSkippedRevision));
        props.put(LAST_PROCESSED_REVISION, String.valueOf(this.lastProcessedRevision));
        props.put(CACHE_DATA_FILE_NAME, this.cacheDataFileName);
        FileOutputStream out = new FileOutputStream(this.metadataFile);
        try {
            props.store(out, null);
        }
        catch (Throwable throwable) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            out.close();
        }
        catch (IOException iOException) {}
    }

    public long getStartSkippedRevision() {
        return this.startSkippedRevision;
    }

    public long getEndSkippedRevision() {
        return this.endSkippedRevision;
    }

    public long getLastProcessedRevision() {
        return this.lastProcessedRevision;
    }

    public void setSkippedRevisions(long start, long end) {
        this.startSkippedRevision = start;
        this.endSkippedRevision = end;
    }

    public void setLastProcessedRevision(long revision) {
        this.lastProcessedRevision = revision;
    }

    public String getCacheDataFileName() {
        return this.cacheDataFileName;
    }

    public File getMetaDataFile() {
        return this.metadataFile;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheResult createCacheData(IRepositoryResource resource, IProgressMonitor monitor) {
        block24: {
            Object object;
            CacheResult cacheResult;
            boolean isRefresh = false;
            RepositoryCache previousCache = null;
            Object object2 = this.calculateLock;
            synchronized (object2) {
                if (this.resourcesForWhichCacheIsOpened.contains(resource)) {
                    return new CacheResult(CacheResultEnum.BROKEN, null);
                }
                if (this.isCalculating) {
                    return new CacheResult(CacheResultEnum.CALCULATING, null);
                }
                this.isCalculating = true;
                previousCache = this.repositoryCache;
                if (previousCache != null) {
                    isRefresh = true;
                }
            }
            try {
                RepositoryCache cache;
                IActionOperation op;
                if (isRefresh) {
                    op = this.getRefreshOperation(resource, previousCache);
                    cache = previousCache;
                } else {
                    cache = new RepositoryCache(this.getCacheDataFile(), this);
                    op = this.getCreateOperation(resource, cache);
                }
                ProgressMonitorUtility.doTask((IActionOperation)UIMonitorUtility.DEFAULT_FACTORY.getLogged(op), (IProgressMonitor)monitor, (int)1, (int)1);
                if (op.getExecutionState() != 0) break block24;
                Object object3 = this.calculateLock;
                synchronized (object3) {
                    if (!this.resourcesForWhichCacheIsOpened.contains(resource)) {
                        ++this.cacheReferencesCount;
                        this.resourcesForWhichCacheIsOpened.add(resource);
                    }
                    this.repositoryCache = cache;
                }
                cache.prepareModel();
                cacheResult = new CacheResult(CacheResultEnum.OK, cache);
                object = this.calculateLock;
            }
            catch (Throwable throwable) {
                Object object4 = this.calculateLock;
                synchronized (object4) {
                    this.isCalculating = false;
                }
                throw throwable;
            }
            synchronized (object) {
                this.isCalculating = false;
            }
            return cacheResult;
        }
        CacheResult cacheResult = new CacheResult(CacheResultEnum.BROKEN, null);
        Object object = this.calculateLock;
        synchronized (object) {
            this.isCalculating = false;
        }
        return cacheResult;
    }

    protected File getCacheDataFile() {
        File cacheDataFile = new File(this.metadataFile.getParentFile(), this.cacheDataFileName);
        return cacheDataFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheResult refreshCacheData(IRepositoryResource resource, IProgressMonitor monitor) {
        block17: {
            Object object;
            CacheResult cacheResult;
            RepositoryCache previousCache = null;
            Object object2 = this.calculateLock;
            synchronized (object2) {
                previousCache = this.repositoryCache;
                if (previousCache == null) {
                    return new CacheResult(CacheResultEnum.BROKEN, null);
                }
                if (this.isCalculating) {
                    return new CacheResult(CacheResultEnum.CALCULATING, null);
                }
                this.isCalculating = true;
            }
            try {
                IActionOperation op = this.getRefreshOperation(resource, previousCache);
                ProgressMonitorUtility.doTask((IActionOperation)UIMonitorUtility.DEFAULT_FACTORY.getLogged(op), (IProgressMonitor)monitor, (int)1, (int)1);
                if (op.getExecutionState() != 0) break block17;
                previousCache.prepareModel();
                cacheResult = new CacheResult(CacheResultEnum.OK, previousCache);
                object = this.calculateLock;
            }
            catch (Throwable throwable) {
                Object object3 = this.calculateLock;
                synchronized (object3) {
                    this.isCalculating = false;
                }
                throw throwable;
            }
            synchronized (object) {
                this.isCalculating = false;
            }
            return cacheResult;
        }
        CacheResult cacheResult = new CacheResult(CacheResultEnum.BROKEN, null);
        Object object = this.calculateLock;
        synchronized (object) {
            this.isCalculating = false;
        }
        return cacheResult;
    }

    protected IActionOperation getCreateOperation(IRepositoryResource resource, RepositoryCache cache) {
        CompositeOperation op = new CompositeOperation("Operation_CreateCache", SVNRevisionGraphMessages.class);
        CheckRepositoryConnectionOperation checkConnectionOp = new CheckRepositoryConnectionOperation(resource);
        op.add((IActionOperation)checkConnectionOp);
        PrepareRevisionDataOperation prepareDataOp = new PrepareRevisionDataOperation(cache);
        op.add((IActionOperation)prepareDataOp, new IActionOperation[]{checkConnectionOp});
        FetchSkippedRevisionsOperation fetchSkippedOp = new FetchSkippedRevisionsOperation(resource, checkConnectionOp, cache);
        op.add((IActionOperation)fetchSkippedOp, new IActionOperation[]{prepareDataOp});
        FetchNewRevisionsOperation fetchNewOp = new FetchNewRevisionsOperation(resource, checkConnectionOp, cache);
        op.add((IActionOperation)fetchNewOp, new IActionOperation[]{fetchSkippedOp});
        return op;
    }

    protected IActionOperation getRefreshOperation(IRepositoryResource resource, RepositoryCache cache) {
        CompositeOperation op = new CompositeOperation("Operation_RefreshCache", SVNRevisionGraphMessages.class);
        CheckRepositoryConnectionOperation checkConnectionOp = new CheckRepositoryConnectionOperation(resource);
        op.add((IActionOperation)checkConnectionOp);
        FetchSkippedRevisionsOperation fetchSkippedOp = new FetchSkippedRevisionsOperation(resource, checkConnectionOp, cache);
        op.add((IActionOperation)fetchSkippedOp, new IActionOperation[]{checkConnectionOp});
        FetchNewRevisionsOperation fetchNewOp = new FetchNewRevisionsOperation(resource, checkConnectionOp, cache);
        op.add((IActionOperation)fetchNewOp, new IActionOperation[]{fetchSkippedOp});
        return op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeRepositoryCache(IRepositoryResource resource) {
        Object object = this.calculateLock;
        synchronized (object) {
            this.resourcesForWhichCacheIsOpened.remove(resource);
            if (this.cacheReferencesCount > 0 && --this.cacheReferencesCount == 0) {
                this.repositoryCache = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean export(File destination, IProgressMonitor monitor) throws Exception {
        Object object = this.calculateLock;
        synchronized (object) {
            block5: {
                if (!this.isCalculating) break block5;
                return false;
            }
            File cacheDataFile = this.getCacheDataFile();
            if (this.metadataFile.exists() && cacheDataFile.exists()) {
                FileUtility.copyFile((File)destination, (File)cacheDataFile, (IProgressMonitor)monitor);
                FileUtility.copyFile((File)destination, (File)this.metadataFile, (IProgressMonitor)monitor);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove() {
        Object object = this.calculateLock;
        synchronized (object) {
            block4: {
                if (!this.isCalculating) break block4;
                return false;
            }
            this.metadataFile.delete();
            File cacheDataFile = this.getCacheDataFile();
            cacheDataFile.delete();
            return true;
        }
    }

    public String toString() {
        return this.repositoryName;
    }

    public static class CacheResult {
        public final CacheResultEnum status;
        public final RepositoryCache repositoryCache;

        public CacheResult(CacheResultEnum status, RepositoryCache repositoryCache) {
            this.status = status;
            this.repositoryCache = repositoryCache;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CacheResultEnum {
        OK,
        BROKEN,
        CALCULATING;

    }
}

