/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.action;

import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.revision.graph.SVNRevisionGraphMessages;
import org.eclipse.team.svn.revision.graph.SVNRevisionGraphPlugin;
import org.eclipse.team.svn.revision.graph.operation.RevisionGraphUtility;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.ObjectPluginAction;
import org.eclipse.ui.navigator.CommonActionProvider;

public class GraphSynchronizeViewActionProvider
extends CommonActionProvider {
    protected final ShowRevisionGraphAction showRevisionGraph = new ShowRevisionGraphAction();

    public void fillContextMenu(IMenuManager menuManager) {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        this.showRevisionGraph.selectionChanged((IAction)this.showRevisionGraph, (ISelection)selection);
        menuManager.insertAfter("modelManageLocalChanges", (IAction)this.showRevisionGraph);
    }

    protected static class ShowRevisionGraphAction
    extends Action
    implements IViewActionDelegate {
        protected IViewPart viewPart;
        protected IStructuredSelection selection = new StructuredSelection();

        public ShowRevisionGraphAction() {
            this.setText(SVNRevisionGraphMessages.ShowRevisionGraphAction);
            this.setToolTipText(SVNRevisionGraphMessages.ShowRevisionGraphAction);
            this.setImageDescriptor(SVNRevisionGraphPlugin.instance().getImageDescriptor("icons/showgraph.png"));
        }

        public void init(IViewPart viewPart) {
            this.viewPart = viewPart;
        }

        public void run() {
            if (this.selection instanceof IStructuredSelection) {
                this.doRun();
            }
        }

        public void run(IAction action) {
            ObjectPluginAction objectAction;
            if (action instanceof ObjectPluginAction && (objectAction = (ObjectPluginAction)action).getSelection() instanceof IStructuredSelection) {
                this.selection = (IStructuredSelection)objectAction.getSelection();
                this.doRun();
            }
        }

        protected void doRun() {
            IResource resource = this.getSelectedResource();
            IRepositoryResource reposResource = SVNRemoteStorage.instance().asRepositoryResource(resource);
            CompositeOperation op = RevisionGraphUtility.getRevisionGraphOperation(reposResource);
            UIMonitorUtility.doTaskScheduledDefault((IWorkbenchPart)this.viewPart, (IActionOperation)op);
        }

        public void selectionChanged(IAction action, ISelection selection) {
            this.selection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : StructuredSelection.EMPTY;
            this.setEnabled(this.isEnabledForSelection());
        }

        protected boolean isEnabledForSelection() {
            IResource resource;
            return this.selection.size() == 1 && (resource = this.getSelectedResource()) != null && FileUtility.checkForResourcesPresence((IResource[])new IResource[]{resource}, (IStateFilter)IStateFilter.SF_ONREPOSITORY, (int)0);
        }

        protected IResource getSelectedResource() {
            IStructuredSelection selection = this.selection;
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                Object adapter = Platform.getAdapterManager().getAdapter(it.next(), IResource.class);
                if (adapter == null) continue;
                return (IResource)adapter;
            }
            return null;
        }
    }
}

