/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.team.svn.revision.graph.NodeConnections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TopRightTraverseVisitor<T extends NodeConnections<T>> {
    public void traverse(T startNode) {
        LinkedList<Object> queue = new LinkedList<Object>();
        queue.offer(startNode);
        NodeConnections node = null;
        while ((node = (NodeConnections)queue.poll()) != null) {
            this.visit(node);
            NodeConnections next = this.getNext(node);
            if (next != null) {
                queue.offer(next);
            }
            Collection<NodeConnections> copiedToNodes = this.getCopiedToAsCollection(node);
            for (NodeConnections copiedToNode : copiedToNodes) {
                queue.offer(copiedToNode);
            }
        }
    }

    protected Collection<T> getCopiedToAsCollection(T node) {
        return ((NodeConnections)node).getCopiedToAsCollection();
    }

    protected T getNext(T node) {
        return ((NodeConnections)node).getNext();
    }

    protected abstract void visit(T var1);
}

