/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.wizard;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.wizard.AbstractSVNWizard;
import org.eclipse.team.svn.ui.wizard.selectresource.SelectResourceLocationPage;
import org.eclipse.team.svn.ui.wizard.selectresource.SelectSimpleRepositoryLocationPage;

public class SelectRepositoryResourceWizard
extends AbstractSVNWizard {
    protected SelectSimpleRepositoryLocationPage selectLocationPage;
    protected SelectResourceLocationPage selectResourcePage;
    protected IRepositoryLocation location;
    protected boolean showFolders;
    protected IRepositoryResource selectedResource;

    public SelectRepositoryResourceWizard(boolean showFolders) {
        this(showFolders, null);
    }

    public SelectRepositoryResourceWizard(boolean showFolders, IRepositoryLocation location) {
        this.showFolders = showFolders;
        this.location = location;
        this.setWindowTitle(SVNUIMessages.SelectRepositoryResourceWizard_Title);
    }

    public void addPages() {
        if (this.location == null) {
            IRepositoryLocation[] locations = SVNRemoteStorage.instance().getRepositoryLocations();
            this.selectLocationPage = new SelectSimpleRepositoryLocationPage(locations);
            this.addPage((IWizardPage)this.selectLocationPage);
            this.selectResourcePage = new SelectResourceLocationPage(this.showFolders, null);
            this.addPage((IWizardPage)this.selectResourcePage);
        } else {
            this.selectResourcePage = new SelectResourceLocationPage(this.showFolders, this.location);
            this.addPage((IWizardPage)this.selectResourcePage);
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page instanceof SelectSimpleRepositoryLocationPage) {
            this.selectResourcePage.setModelRoot(this.selectLocationPage.getRepositoryLocation());
            return this.selectResourcePage;
        }
        return null;
    }

    public boolean canFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage instanceof SelectResourceLocationPage) {
            return this.selectResourcePage.getRepositoryResource() != null;
        }
        return false;
    }

    public boolean performFinish() {
        this.selectedResource = this.selectResourcePage.getRepositoryResource();
        return true;
    }

    public IRepositoryResource getSelectedResource() {
        return this.selectedResource;
    }
}

