/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.svnstorage;

import java.util.Collection;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.resource.IRepositoryContainer;
import org.eclipse.team.svn.core.resource.IRepositoryFile;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryRoot;
import org.eclipse.team.svn.core.resource.IRevisionLink;
import org.eclipse.team.svn.core.resource.SSHSettings;
import org.eclipse.team.svn.core.resource.SSLSettings;
import org.eclipse.team.svn.core.svnstorage.SVNRepositoryLocation;
import org.eclipse.team.svn.core.svnstorage.SVNRepositoryLocationRoot;
import org.eclipse.team.svn.core.svnstorage.SVNRepositoryRoot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVNRepositoryLocationWrapper
implements IRepositoryLocation {
    protected IRepositoryLocation location;
    protected String url;
    protected String repositoryRootUrl;
    protected String repositoryUUID;

    public SVNRepositoryLocationWrapper(IRepositoryLocation location, String mappedUrl) {
        this.location = location;
        this.url = mappedUrl;
    }

    @Override
    public String asReference(IRepositoryLocation.LocationReferenceTypeEnum locationReferenceType) {
        return this.location.asReference(locationReferenceType);
    }

    @Override
    public void fillLocationFromReference(String[] referenceParts) {
        this.location.fillLocationFromReference(referenceParts);
    }

    @Override
    public String getUrlAsIs() {
        return this.url;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public IRepositoryContainer asRepositoryContainer(String url, boolean allowsNull) {
        return SVNRepositoryLocation.asRepositoryContainer(this, url, allowsNull);
    }

    @Override
    public IRepositoryFile asRepositoryFile(String url, boolean allowsNull) {
        return SVNRepositoryLocation.asRepositoryFile(this, url, allowsNull);
    }

    @Override
    public IRepositoryRoot getRepositoryRoot() {
        return new SVNRepositoryRoot(this);
    }

    @Override
    public IRepositoryRoot getRoot() {
        return new SVNRepositoryLocationRoot(this);
    }

    @Override
    public String getRepositoryRootUrl() {
        if (this.repositoryRootUrl == null) {
            this.fetchRepoInfo();
        }
        return this.repositoryRootUrl == null ? this.getUrl() : this.repositoryRootUrl;
    }

    @Override
    public String getRepositoryUUID() {
        if (this.repositoryUUID == null) {
            this.fetchRepoInfo();
        }
        return this.repositoryUUID;
    }

    @Override
    public ISVNConnector acquireSVNProxy() {
        return this.location.acquireSVNProxy();
    }

    @Override
    public void addRealm(String realm, IRepositoryLocation location) {
        this.location.addRealm(realm, location);
    }

    @Override
    public void addRevisionLink(IRevisionLink link) {
        this.location.addRevisionLink(link);
    }

    @Override
    public void dispose() {
        this.location.dispose();
    }

    @Override
    public String getBranchesLocation() {
        return this.location.getBranchesLocation();
    }

    @Override
    public String getId() {
        return this.location.getId();
    }

    @Override
    public String getLabel() {
        return this.location.getLabel();
    }

    @Override
    public IRepositoryLocation getLocationForRealm(String realm) {
        return this.location.getLocationForRealm(realm);
    }

    @Override
    public String getPassword() {
        return this.location.getPassword();
    }

    @Override
    public Collection<IRepositoryLocation> getRealmLocations() {
        return this.location.getRealmLocations();
    }

    @Override
    public Collection<String> getRealms() {
        return this.location.getRealms();
    }

    @Override
    public IRevisionLink[] getRevisionLinks() {
        return this.location.getRevisionLinks();
    }

    @Override
    public SSHSettings getSSHSettings() {
        return this.location.getSSHSettings();
    }

    @Override
    public SSLSettings getSSLSettings() {
        return this.location.getSSLSettings();
    }

    @Override
    public String getTagsLocation() {
        return this.location.getTagsLocation();
    }

    @Override
    public String getTrunkLocation() {
        return this.location.getTrunkLocation();
    }

    @Override
    public String getUserInputBranches() {
        return this.location.getUserInputBranches();
    }

    @Override
    public String getUserInputTags() {
        return this.location.getUserInputTags();
    }

    @Override
    public String getUserInputTrunk() {
        return this.location.getUserInputTrunk();
    }

    @Override
    public String getUsername() {
        return this.location.getUsername();
    }

    @Override
    public boolean isPasswordSaved() {
        return this.location.isPasswordSaved();
    }

    @Override
    public boolean isStructureEnabled() {
        return this.location.isStructureEnabled();
    }

    @Override
    public void reconfigure() {
        this.location.reconfigure();
    }

    @Override
    public void releaseSVNProxy(ISVNConnector proxy) {
        this.location.releaseSVNProxy(proxy);
    }

    @Override
    public void removeRealm(String realm) {
        this.location.removeRealm(realm);
    }

    @Override
    public void removeRevisionLink(IRevisionLink link) {
        this.location.removeRevisionLink(link);
    }

    @Override
    public void setBranchesLocation(String location) {
        this.location.setBranchesLocation(location);
    }

    @Override
    public void setLabel(String label) {
        this.location.setLabel(label);
    }

    @Override
    public void setPassword(String password) {
        this.location.setPassword(password);
    }

    @Override
    public void setPasswordSaved(boolean saved) {
        this.location.setPasswordSaved(saved);
    }

    @Override
    public void setStructureEnabled(boolean enabled) {
        this.location.setStructureEnabled(enabled);
    }

    @Override
    public void setTagsLocation(String location) {
        this.location.setTagsLocation(location);
    }

    @Override
    public void setTrunkLocation(String location) {
        this.location.setTrunkLocation(location);
    }

    @Override
    public void setUsername(String username) {
        this.location.setUsername(username);
    }

    @Override
    public String getName() {
        return this.location.getName();
    }

    @Override
    public boolean isAuthorNameEnabled() {
        return this.location.isAuthorNameEnabled();
    }

    @Override
    public String getAuthorName() {
        return this.location.getAuthorName();
    }

    @Override
    public void setAuthorNameEnabled(boolean isEnabled) {
        this.location.setAuthorNameEnabled(isEnabled);
    }

    @Override
    public void setAuthorName(String name) {
        this.location.setAuthorName(name);
    }

    public Object getAdapter(Class adapter) {
        return this.location.getAdapter(adapter);
    }

    protected void fetchRepoInfo() {
        String[] values = SVNRepositoryLocation.fetchRepoInfo(this, true);
        this.repositoryRootUrl = values[0];
        this.repositoryUUID = values[1];
    }

    @Override
    public boolean isPasswordSavedForRealm(String realm) {
        return this.location.isPasswordSavedForRealm(realm);
    }

    public boolean equals(Object obj) {
        return this.location.equals(obj);
    }
}

