/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.file;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.file.AbstractFileOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class CheckoutAsOperation
extends AbstractFileOperation {
    protected IRepositoryResource resource;
    protected int recureDepth;
    protected boolean ignoreExternals;
    protected boolean override;

    public CheckoutAsOperation(File to, IRepositoryResource resource, int recureDepth, boolean ignoreExternals, boolean override) {
        super("Operation_CheckoutAsFile", SVNMessages.class, new File[]{to});
        this.resource = resource;
        this.recureDepth = recureDepth;
        this.ignoreExternals = ignoreExternals;
        this.override = override;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        File to = this.operableData()[0];
        if (this.override) {
            FileUtility.deleteRecursive(to, monitor);
        }
        to.mkdirs();
        IRepositoryLocation location = this.resource.getRepositoryLocation();
        ISVNConnector proxy = location.acquireSVNProxy();
        try {
            String path = to.getAbsolutePath();
            proxy.checkout(SVNUtility.getEntryRevisionReference(this.resource), path, this.recureDepth, this.ignoreExternals ? 1L : 0L, new SVNProgressMonitor(this, monitor, null));
        }
        finally {
            location.releaseSVNProxy(proxy);
        }
    }
}

