/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.synchronize;

import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.IResourceVariantComparator;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IResourceChange;
import org.eclipse.team.svn.core.synchronize.AbstractSVNSyncInfo;
import org.eclipse.team.svn.core.synchronize.variant.ResourceVariant;

public class UpdateSyncInfo
extends AbstractSVNSyncInfo {
    public UpdateSyncInfo(ILocalResource local, IResourceChange remote, IResourceVariantComparator comparator) {
        super(local, remote, comparator);
    }

    protected int calculateKind() throws TeamException {
        int remoteMask;
        int localMask;
        String localKind = this.local == null ? IStateFilter.ST_NOTEXISTS : this.local.getStatus();
        int n = localMask = this.local == null ? 0 : this.local.getChangeMask();
        String remoteKind = this.getRemote() == null ? (this.isNonVersioned(localKind, localMask) ? IStateFilter.ST_NOTEXISTS : "Normal") : ((ResourceVariant)this.getRemote()).getStatus();
        int n2 = remoteMask = this.getRemote() == null ? 0 : ((ResourceVariant)this.getRemote()).getResource().getChangeMask();
        if (this.isLinked(localKind, localMask)) {
            if (this.isAdded(remoteKind, remoteMask)) {
                return 13;
            }
            return 0;
        }
        if (this.isTreeConflicted(localKind, localMask)) {
            return 15;
        }
        if (this.isReplaced(remoteKind, remoteMask)) {
            if (this.isNotModified(localKind, localMask)) {
                return 11;
            }
            return 15;
        }
        if (this.isAdded(remoteKind, remoteMask)) {
            if (this.isNotExists(localKind, localMask)) {
                return 9;
            }
            return 13;
        }
        if (this.isModified(remoteKind, remoteMask)) {
            if (this.isNotModified(localKind, localMask)) {
                return 11;
            }
            if (this.isDeleted(localKind, localMask)) {
                return 14;
            }
            return 15;
        }
        if (this.isDeleted(remoteKind, remoteMask)) {
            if (this.isNotModified(localKind, localMask)) {
                return 10;
            }
            return 14;
        }
        if (this.isNonVersioned(remoteKind, remoteMask)) {
            if (this.isIgnored(localKind, localMask) || this.isNotExists(localKind, localMask)) {
                return 0;
            }
            return 5;
        }
        if (this.isConflicted(localKind, localMask)) {
            return 15;
        }
        if (this.isReplaced(localKind, localMask) || this.isModified(localKind, localMask)) {
            return 7;
        }
        if (this.isDeleted(localKind, localMask)) {
            return 6;
        }
        if (this.isAdded(localKind, localMask)) {
            return 5;
        }
        return 0;
    }
}

