/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.synchronize;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.PersistantResourceVariantByteStore;
import org.eclipse.team.svn.core.operation.LoggedOperation;
import org.eclipse.team.svn.core.operation.local.GetAllResourcesOperation;
import org.eclipse.team.svn.core.synchronize.IRemoteStatusCache;
import org.eclipse.team.svn.core.synchronize.UpdateSubscriber;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;

public class PersistentRemoteStatusCache
extends PersistantResourceVariantByteStore
implements IRemoteStatusCache {
    public PersistentRemoteStatusCache(QualifiedName qualifiedName) {
        super(qualifiedName);
    }

    public synchronized boolean containsData() throws TeamException {
        IResource[] roots;
        boolean containsData = false;
        IResource[] iResourceArray = roots = this.roots();
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            IResource root = iResourceArray[n2];
            if (this.getBytes(root) != null) {
                containsData = true;
                break;
            }
            ++n2;
        }
        return containsData;
    }

    public synchronized void clearAll() throws TeamException {
        IResource[] resources;
        IResource[] iResourceArray = resources = this.roots();
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            this.flushBytes(resource, 2);
            ++n2;
        }
    }

    public synchronized IResource[] allMembers(IResource resource) throws TeamException {
        if (!(resource instanceof IContainer)) {
            return FileUtility.NO_CHILDREN;
        }
        HashSet members = new HashSet(Arrays.asList(this.members(resource)));
        if (RepositoryProvider.getProvider((IProject)resource.getProject(), (String)"org.eclipse.team.svn.core.svnnature") != null) {
            IContainer container = (IContainer)resource;
            GetAllResourcesOperation op = new GetAllResourcesOperation(container);
            ProgressMonitorUtility.doTaskExternal(op, (IProgressMonitor)new NullProgressMonitor());
            members.addAll(Arrays.asList(op.getChildren()));
        }
        return members.toArray(new IResource[members.size()]);
    }

    public synchronized IResource[] members(IResource resource) throws TeamException {
        if (this.getBytes(resource) == null) {
            return new IResource[0];
        }
        return super.members(resource);
    }

    public synchronized boolean setBytes(IResource resource, byte[] bytes) throws TeamException {
        return super.setBytes(resource, bytes);
    }

    public synchronized byte[] getBytes(IResource resource) throws TeamException {
        return super.getBytes(resource);
    }

    public synchronized boolean flushBytes(IResource resource, int depth) throws TeamException {
        return super.flushBytes(resource, depth);
    }

    public synchronized boolean deleteBytes(IResource resource) throws TeamException {
        return super.deleteBytes(resource);
    }

    public synchronized void traverse(IResource[] resources, int depth, IRemoteStatusCache.ICacheVisitor visitor) throws TeamException {
        int i = 0;
        while (i < resources.length) {
            this.traverse(resources[i], depth, visitor);
            ++i;
        }
    }

    protected void traverse(IResource resource, int depth, IRemoteStatusCache.ICacheVisitor visitor) throws TeamException {
        IResource[] resources;
        IPath base = resource.getFullPath();
        IResource[] iResourceArray = resources = this.getAllMembers();
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource res = iResourceArray[n2];
            if (this.isChildOf(base, res.getFullPath(), depth)) {
                try {
                    visitor.visit(res.getFullPath(), this.getBytes(res));
                }
                catch (TeamException e) {
                    LoggedOperation.reportError(this.getClass().getName(), e);
                }
            }
            ++n2;
        }
    }

    protected boolean isChildOf(IPath base, IPath current, int depth) {
        int matchingSegmentsCount;
        int cachedSegmentsCount;
        int difference;
        return base.isPrefixOf(current) && ((difference = (cachedSegmentsCount = current.segmentCount()) - (matchingSegmentsCount = base.matchingFirstSegments(current))) >= 0 && depth == 2 || depth >= difference);
    }

    protected IResource[] getAllMembers() throws TeamException {
        ArrayList<IResource> res = new ArrayList<IResource>();
        IResource[] roots = this.roots();
        LinkedList<IResource> queue = new LinkedList<IResource>();
        IResource[] iResourceArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            IResource root = iResourceArray[n2];
            queue.add(root);
            ++n2;
        }
        IResource resource = null;
        while ((resource = (IResource)queue.poll()) != null) {
            IResource[] members;
            if (this.getBytes(resource) == null) continue;
            res.add(resource);
            IResource[] iResourceArray2 = members = this.members(resource);
            int n3 = members.length;
            int n4 = 0;
            while (n4 < n3) {
                IResource member = iResourceArray2[n4];
                queue.add(member);
                ++n4;
            }
        }
        return res.toArray(new IResource[0]);
    }

    protected IResource[] roots() {
        return UpdateSubscriber.instance().roots();
    }
}

