/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local.property;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.operation.local.property.IPropertyProvider;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;

public class SetMultiPropertiesOperation
extends AbstractWorkingCopyOperation {
    protected IPropertyProvider propertyProvider;
    protected int depth;
    protected IStateFilter filter;

    public SetMultiPropertiesOperation(IResourceProvider resourceProvider, IPropertyProvider propertyProvider, IStateFilter filter, int depth) {
        super("Operation_SetMultiProperties", resourceProvider);
        this.propertyProvider = propertyProvider;
        this.depth = depth;
        this.filter = filter != null ? filter : IStateFilter.SF_VERSIONED;
    }

    public SetMultiPropertiesOperation(IResource[] resources, IPropertyProvider propertyProvider, IStateFilter filter, int depth) {
        super("Operation_SetMultiProperties", resources);
        this.propertyProvider = propertyProvider;
        this.depth = depth;
        this.filter = filter != null ? filter : IStateFilter.SF_VERSIONED;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] resources = this.operableData();
        int i = 0;
        while (i < resources.length && !monitor.isCanceled()) {
            final IResource current = resources[i];
            IRepositoryLocation location = SVNRemoteStorage.instance().getRepositoryLocation(current);
            final ISVNConnector proxy = location.acquireSVNProxy();
            try {
                this.protectStep(new IUnprotectedOperation(){

                    public void run(final IProgressMonitor monitor) throws Exception {
                        FileUtility.visitNodes(current, new IResourceVisitor(){

                            public boolean visit(IResource resource) throws CoreException {
                                SVNProperty[] properties;
                                if (monitor.isCanceled()) {
                                    return false;
                                }
                                ILocalResource local = SVNRemoteStorage.instance().asLocalResourceAccessible(resource);
                                if ((this).SetMultiPropertiesOperation.this.filter.accept(local) && (properties = (this).SetMultiPropertiesOperation.this.propertyProvider.getProperties(resource)) != null) {
                                    SetMultiPropertiesOperation.this.processResource(proxy, resource, properties, monitor);
                                }
                                return (this).SetMultiPropertiesOperation.this.filter.allowsRecursion(local);
                            }
                        }, SetMultiPropertiesOperation.this.depth);
                    }
                }, monitor, resources.length);
            }
            finally {
                location.releaseSVNProxy(proxy);
            }
            ++i;
        }
    }

    protected void processResource(final ISVNConnector proxy, IResource current, SVNProperty[] properties, IProgressMonitor monitor) {
        ProgressMonitorUtility.setTaskInfo(monitor, this, current.getFullPath().toString());
        final String wcPath = FileUtility.getWorkingCopyPath(current);
        int i = 0;
        while (i < properties.length && !monitor.isCanceled()) {
            final SVNProperty property = properties[i];
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    proxy.setProperty(wcPath, property.name, property.value, 0, 0L, null, new SVNProgressMonitor(SetMultiPropertiesOperation.this, monitor, null));
                }
            }, monitor, properties.length);
            ++i;
        }
    }
}

