/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.team.svn.core.operation.local.IUnresolvedConflictDetector;

public class UnresolvedConflictDetectorHelper
implements IUnresolvedConflictDetector {
    protected Set<IResource> processed;
    protected Set<IResource> unprocessed;
    protected boolean hasUnresolvedConflict;
    protected String conflictMessage;

    public void setUnresolvedConflict(boolean hasUnresolvedConflict) {
        this.hasUnresolvedConflict = hasUnresolvedConflict;
    }

    public boolean hasUnresolvedConflicts() {
        return this.hasUnresolvedConflict;
    }

    public String getMessage() {
        return this.conflictMessage;
    }

    public IResource[] getUnprocessed() {
        return this.unprocessed == null ? new IResource[]{} : this.unprocessed.toArray(new IResource[this.unprocessed.size()]);
    }

    public IResource[] getProcessed() {
        return this.processed == null ? new IResource[]{} : this.processed.toArray(new IResource[this.processed.size()]);
    }

    protected void defineInitialResourceSet(IResource[] resources) {
        this.hasUnresolvedConflict = false;
        this.unprocessed = new HashSet<IResource>();
        this.processed = new HashSet<IResource>();
        this.processed.addAll((Collection<IResource>)Arrays.asList(resources));
    }

    public void addUnprocessed(IResource unprocessed) {
        this.unprocessed.add(unprocessed);
    }

    public void setConflictMessage(String message) {
        this.conflictMessage = message;
    }

    public void removeProcessed(IResource resource) {
        this.unprocessed.remove(resource);
    }
}

