/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.extension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.SVNTeamPlugin;
import org.eclipse.team.svn.core.extension.crashrecovery.IResolutionHelper;
import org.eclipse.team.svn.core.extension.factory.ISVNConnectorFactory;
import org.eclipse.team.svn.core.extension.factory.ThreadNameModifierFactory;
import org.eclipse.team.svn.core.extension.options.IIgnoreRecommendations;
import org.eclipse.team.svn.core.extension.options.IOptionProvider;
import org.eclipse.team.svn.core.operation.LoggedOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreExtensionsManager {
    public static final String EXTENSION_NAMESPACE = "org.eclipse.team.svn.core";
    public static final String SVN_CONNECTOR = "svnconnector";
    public static final String CORE_OPTIONS = "coreoptions";
    public static final String CRASH_RECOVERY = "crashrecovery";
    public static final String IGNORE_RECOMMENDATIONS = "resourceIgnoreRules";
    private HashMap<String, ISVNConnectorFactory> connectors = new HashMap();
    private HashSet<String> validConnectors = new HashSet();
    private IOptionProvider optionProvider;
    private IResolutionHelper[] helpers;
    private IIgnoreRecommendations[] ignoreRecommendations;
    private static CoreExtensionsManager instance;
    private boolean disableHelpers = false;

    public static synchronized CoreExtensionsManager instance() {
        if (instance == null) {
            instance = new CoreExtensionsManager();
        }
        return instance;
    }

    public IIgnoreRecommendations[] getIgnoreRecommendations() {
        return this.ignoreRecommendations;
    }

    public IResolutionHelper[] getResolutionHelpers() {
        return this.disableHelpers ? new IResolutionHelper[]{} : this.helpers;
    }

    public void setResolutionHelpersDisabled(boolean disable) {
        this.disableHelpers = disable;
    }

    public boolean isResoultionHelpersDisabled() {
        return this.disableHelpers;
    }

    public IOptionProvider getOptionProvider() {
        return this.optionProvider;
    }

    public void setOptionProvider(IOptionProvider optionProvider) {
        this.optionProvider = optionProvider;
    }

    public Collection<String> getAccessibleClientIds() {
        return this.connectors.keySet();
    }

    public Collection<ISVNConnectorFactory> getAccessibleClients() {
        return this.connectors.values();
    }

    public ISVNConnectorFactory getSVNConnectorFactory() {
        String id = SVNTeamPlugin.instance().getOptionProvider().getSVNConnectorId();
        return this.getSVNConnectorFactory(id);
    }

    public ISVNConnectorFactory getSVNConnectorFactory(String id) {
        ISVNConnectorFactory retVal = this.getFirstValidConnector(id);
        if (retVal == null) {
            retVal = ISVNConnectorFactory.EMPTY;
        }
        return retVal;
    }

    private ISVNConnectorFactory getFirstValidConnector(String id) {
        if (this.validConnectors.contains(id)) {
            return this.connectors.get(id);
        }
        if (this.validConnectors.contains("org.eclipse.team.svn.connector.svnkit15")) {
            return this.connectors.get("org.eclipse.team.svn.connector.svnkit15");
        }
        for (ISVNConnectorFactory connector : this.connectors.values()) {
            if (!this.validConnectors.contains(connector.getId())) continue;
            return connector;
        }
        return null;
    }

    private CoreExtensionsManager() {
        Object[] extensions = this.loadCoreExtensions(SVN_CONNECTOR);
        int i = 0;
        while (i < extensions.length) {
            block4: {
                ThreadNameModifierFactory factory = new ThreadNameModifierFactory((ISVNConnectorFactory)extensions[i]);
                try {
                    if (factory.getCompatibilityVersion().compareTo("0.7.7.I20090410-1500") != 0) {
                    }
                }
                catch (Throwable throwable) {}
                break block4;
                this.connectors.put(factory.getId(), factory);
                this.validateClient(factory);
            }
            ++i;
        }
        extensions = this.loadCoreExtensions(CORE_OPTIONS);
        this.optionProvider = extensions.length != 0 ? (IOptionProvider)extensions[0] : IOptionProvider.DEFAULT;
        extensions = this.loadCoreExtensions(CRASH_RECOVERY);
        this.helpers = Arrays.asList(extensions).toArray(new IResolutionHelper[extensions.length]);
        extensions = this.loadCoreExtensions(IGNORE_RECOMMENDATIONS);
        this.ignoreRecommendations = Arrays.asList(extensions).toArray(new IIgnoreRecommendations[extensions.length]);
    }

    private void validateClient(ISVNConnectorFactory connector) {
        try {
            connector.newInstance().dispose();
            this.validConnectors.add(connector.getId());
        }
        catch (Throwable throwable) {}
    }

    private Object[] loadCoreExtensions(String extensionPoint) {
        return this.loadExtensions(EXTENSION_NAMESPACE, extensionPoint);
    }

    private Object[] loadExtensions(String namespace, String extensionPoint) {
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint(namespace, extensionPoint);
        if (extension == null) {
            String errMessage = SVNMessages.formatErrorString("Error_InvalidExtensionPoint", new String[]{namespace, extensionPoint});
            throw new RuntimeException(errMessage);
        }
        IExtension[] extensions = extension.getExtensions();
        ArrayList<Object> retVal = new ArrayList<Object>();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                try {
                    retVal.add(configElements[j].createExecutableExtension("class"));
                }
                catch (CoreException ex) {
                    LoggedOperation.reportError(SVNMessages.getErrorString("Error_LoadExtensions"), ex);
                }
                ++j;
            }
            ++i;
        }
        return retVal.toArray();
    }
}

