/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.connector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.team.svn.core.connector.SVNLogPath;

public class SVNLogEntry {
    public final long revision;
    public final long date;
    public final String author;
    public final String message;
    public final SVNLogPath[] changedPaths;
    private List<SVNLogEntry> children;

    public SVNLogEntry(long revision, long date, String author, String message, SVNLogPath[] changedPaths, boolean hasChildren) {
        this.message = message;
        this.date = date;
        this.revision = revision;
        this.author = author;
        this.changedPaths = changedPaths;
        this.children = hasChildren ? new ArrayList() : null;
    }

    public SVNLogEntry[] getChildren() {
        return this.children == null ? null : this.children.toArray(new SVNLogEntry[this.children.size()]);
    }

    public boolean hasChildren() {
        return this.children != null;
    }

    public void add(SVNLogEntry child) {
        this.children.add(child);
    }

    public void addAll(SVNLogEntry[] child) {
        this.children.addAll((Collection<SVNLogEntry>)Arrays.asList(child));
    }

    public int hashCode() {
        return (int)this.revision;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SVNLogEntry) {
            return this.revision == ((SVNLogEntry)obj).revision;
        }
        return false;
    }
}

