/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.core.ProjectSetCapability;
import org.eclipse.team.core.ProjectSetSerializationContext;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.SVNTeamPlugin;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.core.operation.remote.CheckoutAsOperation;
import org.eclipse.team.svn.core.operation.remote.management.SaveRepositoryLocationsOperation;
import org.eclipse.team.svn.core.resource.IRepositoryContainer;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;

public class SVNTeamProjectSetCapability
extends ProjectSetCapability {
    protected static final String PLUGIN_INFORMATION = "1.0.1";

    public String[] asReference(IProject[] projects, ProjectSetSerializationContext context, IProgressMonitor monitor) throws TeamException {
        monitor.beginTask(SVNMessages.Operation_ExportProjectSet, projects.length);
        try {
            String[] result = new String[projects.length];
            int i = 0;
            while (i < projects.length) {
                result[i] = this.asReference(projects[i]);
                monitor.worked(1);
                ++i;
            }
            String[] stringArray = result;
            return stringArray;
        }
        finally {
            monitor.done();
        }
    }

    public IProject[] addToWorkspace(String[] referenceStrings, ProjectSetSerializationContext context, IProgressMonitor monitor) throws TeamException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        HashMap<IProject, String> project2reference = new HashMap<IProject, String>();
        int i = 0;
        while (i < referenceStrings.length) {
            String name = this.getNameForReference(referenceStrings[i]);
            if (name != null) {
                project2reference.put(root.getProject(name), referenceStrings[i]);
            }
            ++i;
        }
        Set allProjects = project2reference.keySet();
        IProject[] projects = this.confirmOverwrite(context, allProjects.toArray(new IProject[allProjects.size()]));
        if (projects != null && projects.length > 0) {
            CompositeOperation op = new CompositeOperation("Operation_ImportProjectSet");
            op.add(new SaveRepositoryLocationsOperation());
            ArrayList<IProject> retVal = new ArrayList<IProject>();
            int i2 = 0;
            while (i2 < projects.length) {
                String fullReference = (String)project2reference.get(projects[i2]);
                IProject project = this.configureCheckoutOperation(op, projects[i2], fullReference);
                if (project != null) {
                    retVal.add(project);
                }
                ++i2;
            }
            projects = retVal.toArray(new IProject[retVal.size()]);
            op.add(new RefreshResourcesOperation((IResource[])projects));
            SVNTeamPlugin.instance().getOptionProvider().addProjectSetCapabilityProcessing(op);
            ProgressMonitorUtility.doTaskExternal(op, monitor);
        }
        return projects;
    }

    protected IProject configureCheckoutOperation(CompositeOperation op, IProject project, String fullReference) throws TeamException {
        String[] parts = fullReference.split(",");
        IRepositoryLocation location = this.getLocationForReference(parts);
        IRepositoryContainer resource = location.asRepositoryContainer(parts[1], true);
        if (resource != null) {
            String projectLocation = project.exists() ? FileUtility.getResourcePath((IResource)project).removeLastSegments(1).toString() : Platform.getLocation().toString();
            CheckoutAsOperation mainOp = new CheckoutAsOperation(project.getName(), resource, projectLocation, 3, false);
            op.add(mainOp);
            return mainOp.getProject();
        }
        return null;
    }

    protected IRepositoryLocation getLocationForReference(String[] parts) {
        IRepositoryLocation location = null;
        if (parts.length > 3) {
            location = SVNRemoteStorage.instance().newRepositoryLocation(parts[3]);
            if (SVNRemoteStorage.instance().getRepositoryLocation(location.getId()) != null) {
                return location;
            }
        }
        IRepositoryLocation[] locations = SVNRemoteStorage.instance().getRepositoryLocations();
        Path awaitingFor = new Path(location != null ? location.getUrl() : parts[1]);
        int i = 0;
        while (i < locations.length) {
            if (new Path(locations[i].getUrl()).isPrefixOf((IPath)awaitingFor)) {
                return locations[i];
            }
            ++i;
        }
        if (location == null) {
            location = SVNRemoteStorage.instance().newRepositoryLocation();
            location.setUrl(parts[1]);
        }
        SVNRemoteStorage.instance().addRepositoryLocation(location);
        return location;
    }

    protected String getNameForReference(String fullReference) {
        String[] parts = fullReference.split(",");
        if (parts.length < 3 || !parts[0].equals(PLUGIN_INFORMATION)) {
            return null;
        }
        return parts[2];
    }

    protected String asReference(IProject project) throws TeamException {
        IRepositoryResource resource = SVNRemoteStorage.instance().asRepositoryResource((IResource)project);
        IRepositoryLocation location = resource.getRepositoryLocation();
        String fullReference = PLUGIN_INFORMATION;
        fullReference = String.valueOf(fullReference) + "," + resource.getUrl();
        fullReference = String.valueOf(fullReference) + "," + project.getName();
        fullReference = String.valueOf(fullReference) + "," + SVNRemoteStorage.instance().repositoryLocationAsReference(location);
        return fullReference;
    }
}

